/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.splitter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.fabricmc.fabric.impl.networking.splitter.FabricSplitPacketPayload;
import net.fabricmc.fabric.impl.networking.splitter.PassthroughPacket;
import net.fabricmc.fabric.impl.networking.splitter.SplittablePacket;
import net.fabricmc.fabric.mixin.networking.accessor.EncoderHandlerAccessor;
import net.minecraft.class_2545;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_8710;

public class FabricPacketSplitter
extends MessageToMessageEncoder<class_2596<?>> {
    public static final int SAFE_S2C_SPLIT_SIZE = 0x100000;
    public static final int SAFE_C2S_SPLIT_SIZE = Short.MAX_VALUE;
    private final class_2545<?> encoder;
    private final PayloadTypeRegistryImpl<?> payloadTypeRegistry;

    public FabricPacketSplitter(class_2545<?> encoderHandler, PayloadTypeRegistryImpl<?> payloadTypeRegistry) {
        this.encoder = encoderHandler;
        this.payloadTypeRegistry = payloadTypeRegistry;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, List<Object> list) throws Exception {
        if (packet instanceof SplittablePacket) {
            SplittablePacket splittablePacket = (SplittablePacket)packet;
            splittablePacket.fabric_split(this.payloadTypeRegistry, channelHandlerContext, this.encoder, packet, list::add);
        } else {
            list.add(packet);
        }
        if (packet.method_55943()) {
            channelHandlerContext.pipeline().remove(channelHandlerContext.name());
        }
    }

    public static void genericPacketSplitter(class_2960 packetId, ChannelHandlerContext channelHandlerContext, class_2545<?> encoder, class_2596<?> packet, Function<class_8710, class_2596<?>> packetConstructor, Consumer<class_2596<?>> consumer, int maxChunkSize, int maxPacketSize) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        ((EncoderHandlerAccessor)encoder).fabric_encode(channelHandlerContext, packet, buf);
        if (buf.readableBytes() < maxChunkSize) {
            consumer.accept(new PassthroughPacket(buf));
            return;
        }
        if (buf.readableBytes() > maxPacketSize) {
            throw new EncoderException("Packet '" + String.valueOf(packetId) + "' may not be larger than " + maxPacketSize + " bytes!");
        }
        ByteBuf firstSplit = Unpooled.buffer((int)maxChunkSize);
        class_8703.method_53017((ByteBuf)firstSplit, (int)buf.readableBytes());
        firstSplit.writeBytes(buf.readSlice(maxChunkSize - firstSplit.readableBytes()));
        consumer.accept(packetConstructor.apply(new FabricSplitPacketPayload(firstSplit)));
        while (buf.isReadable()) {
            consumer.accept(packetConstructor.apply(new FabricSplitPacketPayload(buf.readSlice(Math.min(buf.readableBytes(), maxChunkSize)))));
        }
    }
}

