/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static <T extends class_8710> boolean registerGlobalReceiver(class_8710.class_9154<T> type, PlayPayloadHandler<T> handler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(type.comp_2242(), handler);
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterGlobalReceiver(class_2960 id) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(id);
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static <T extends class_8710> boolean registerReceiver(class_8710.class_9154<T> type, PlayPayloadHandler<T> handler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(type.comp_2242(), handler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterReceiver(class_2960 id) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayPayloadHandler)addon.unregisterChannel(id);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static boolean canSend(class_8710.class_9154<?> type) {
        return ClientPlayNetworking.canSend(type.comp_2242());
    }

    public static <T extends class_8710> class_2596<class_8706> createC2SPacket(T packet) {
        return ClientNetworkingImpl.createC2SPacket(packet);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (class_310.method_1551().method_1562() != null) {
            return ClientNetworkingImpl.getAddon(class_310.method_1551().method_1562());
        }
        throw new IllegalStateException("Cannot get payload sender when not in game!");
    }

    public static void send(class_8710 payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.method_56479(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        if (class_310.method_1551().method_1562() != null) {
            class_310.method_1551().method_1562().method_52787(ClientPlayNetworking.createC2SPacket(payload));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayPayloadHandler<T extends class_8710> {
        public void receive(T var1, Context var2);
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.NonExtendable
    public static interface Context {
        public class_310 client();

        public class_746 player();

        public PacketSender responseSender();
    }
}

