/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.model;

import eu.pb4.graves.config.data.WrappedText;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.mixin.PlayerEntityAccessor;
import eu.pb4.graves.model.GraveModel;
import eu.pb4.graves.model.ModelDataProvider;
import eu.pb4.graves.model.ModelTags;
import eu.pb4.graves.model.TaggedText;
import eu.pb4.graves.model.parts.EntityModelPart;
import eu.pb4.graves.model.parts.ItemDisplayModelPart;
import eu.pb4.graves.model.parts.ModelPart;
import eu.pb4.graves.model.parts.TextDisplayModelPart;
import eu.pb4.graves.registry.AbstractGraveBlock;
import eu.pb4.graves.registry.GravesRegistry;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.EntityElement;
import eu.pb4.polymer.virtualentity.api.elements.GenericEntityElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_7718;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class GraveModelHandler
extends ElementHolder {
    private final List<TextsWithPlaceholders> textsWithPlaceholders = new ArrayList<TextsWithPlaceholders>();
    private final List<class_3545<ItemDisplayElement, ItemDisplayModelPart>> itemDisplays = new ArrayList<class_3545<ItemDisplayElement, ItemDisplayModelPart>>();
    private final class_3218 world;
    private class_2680 blockState;
    private float yaw;
    private Set<class_2960> ignoredFlags;
    private final List<class_3545<VirtualElement, ModelPart<?, ?>>> rotatingElements = new ArrayList();
    private ModelDataProvider dataPrivider;
    private final List<class_3545<class_1309, Set<class_2960>>> entityWithEquipment = new ArrayList<class_3545<class_1309, Set<class_2960>>>();
    private int tickTime = 20;
    private final List<EntityModelPart.PlayerElement> delayedPlayerModels = new ArrayList<EntityModelPart.PlayerElement>();

    public GraveModelHandler(class_2680 state, class_3218 world) {
        this.blockState = state;
        this.world = world;
        this.updateYaw();
    }

    private void updateYaw() {
        this.setYaw(class_7718.method_45482((int)((Integer)this.blockState.method_11654((class_2769)AbstractGraveBlock.ROTATION))));
    }

    public void setGrave(ModelDataProvider modelDataProvider) {
        this.dataPrivider = modelDataProvider;
        this.updateModel();
    }

    public void updateModel() {
        String model;
        if (!this.getElements().isEmpty()) {
            this.textsWithPlaceholders.clear();
            this.itemDisplays.clear();
            this.entityWithEquipment.clear();
            this.rotatingElements.clear();
            this.delayedPlayerModels.clear();
            for (VirtualElement element : new ArrayList(this.getElements())) {
                this.removeElement(element);
            }
        }
        if ((model = this.dataPrivider.getGraveModelId()) != null) {
            boolean isProtected = this.dataPrivider.isGraveProtected();
            HashSet<class_2960> flags = new HashSet<class_2960>();
            flags.add(isProtected ? ModelTags.IF_UNPROTECTED : ModelTags.IF_PROTECTED);
            flags.add(this.dataPrivider.isGravePlayerMade() ? ModelTags.IF_NOT_PLAYER_MADE : ModelTags.IF_PLAYER_MADE);
            flags.add(this.dataPrivider.isGravePaymentRequired() ? ModelTags.IF_NOT_REQUIRE_PAYMENT : ModelTags.IF_REQUIRE_PAYMENT);
            flags.add(this.blockState.method_27852((class_2248)GravesRegistry.GRAVE_BLOCK) ? ModelTags.IF_VISUAL : ModelTags.IF_NOT_VISUAL);
            if (!isProtected || GraveManager.INSTANCE.getProtectionTime() <= 0) {
                flags.add(ModelTags.HAS_PROTECTION_TIMER);
            }
            if (this.dataPrivider.isGraveBroken() || GraveManager.INSTANCE.getBreakingTime() <= 0) {
                flags.add(ModelTags.HAS_BREAKING_TIMER);
            }
            this.ignoredFlags = flags;
            GraveModel modelDefinition = GraveModel.setup(model, flags, this::addPart);
            this.tickTime = modelDefinition.tickTime;
        }
    }

    private void addPart(ModelPart<?, ?> part) {
        EntityElement entityElement;
        class_1297 canContinue22;
        class_1799 stack;
        if (this.dataPrivider == null) {
            return;
        }
        Object element = part.construct(this.world);
        if (part instanceof TextDisplayModelPart) {
            TextDisplayModelPart textPart = (TextDisplayModelPart)part;
            if (element instanceof TextDisplayElement) {
                TextDisplayElement textDisplayElement = (TextDisplayElement)element;
                ArrayList<TextNode> list = new ArrayList<TextNode>();
                for (TaggedText.Line l : textPart.text.entry()) {
                    if (l.containsTags(this.ignoredFlags)) continue;
                    WrappedText wrappedText = l.node();
                    TextNode textNode = wrappedText.textNode();
                    list.add(textNode);
                }
                if (list.isEmpty()) {
                    return;
                }
                ArrayList list2 = new ArrayList(list.size() * 2);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    list2.add((TextNode)iter.next());
                    if (!iter.hasNext()) continue;
                    list2.add(TextNode.of((String)"\n"));
                }
                TextNode node = TextNode.asSingle((TextNode[])list2.toArray(new TextNode[0]));
                this.textsWithPlaceholders.add(new TextsWithPlaceholders(node, textDisplayElement));
                textDisplayElement.setText(node.toText(ParserContext.of(WrappedText.DYNAMIC_NODES, this.dataPrivider::getGravePlaceholder)));
            }
        }
        if (part instanceof ItemDisplayModelPart) {
            ItemDisplayModelPart itemDisplayModelPart = (ItemDisplayModelPart)part;
            if (element instanceof ItemDisplayElement) {
                ItemDisplayElement itemDisplayElement = (ItemDisplayElement)element;
                boolean canContinue22 = true;
                if (part.tags.contains(ModelTags.PLAYER_HEAD)) {
                    itemDisplayElement.getItem().method_57379(class_9334.field_49617, (Object)new class_9296(this.dataPrivider.getGraveGameProfile()));
                    canContinue22 = false;
                } else {
                    for (class_2960 class_29602 : ModelTags.EQUIPMENT) {
                        if (!part.tags.contains(class_29602) || (stack = this.dataPrivider.getGraveTaggedItem(class_29602)).method_7960()) continue;
                        itemDisplayElement.setItem(stack);
                        this.itemDisplays.add((class_3545<ItemDisplayElement, ItemDisplayModelPart>)new class_3545((Object)itemDisplayElement, (Object)itemDisplayModelPart));
                        canContinue22 = false;
                        break;
                    }
                }
                if (canContinue22 && part.tags.contains(ModelTags.ITEM)) {
                    int i = this.itemDisplays.size();
                    itemDisplayElement.setItem(this.dataPrivider.getGraveSlotItem(i));
                    this.itemDisplays.add((class_3545<ItemDisplayElement, ItemDisplayModelPart>)new class_3545((Object)itemDisplayElement, (Object)itemDisplayModelPart));
                }
            }
        }
        if (element instanceof EntityElement && (canContinue22 = (entityElement = (EntityElement)element).entity()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)canContinue22;
            boolean hasTag = false;
            for (class_3545<class_2960, class_1304> class_35452 : ModelTags.EQUIPMENT_WITH_SLOT) {
                if (!part.tags.contains(class_35452.method_15442())) continue;
                hasTag = true;
                stack = this.dataPrivider.getGraveTaggedItem((class_2960)class_35452.method_15442());
                livingEntity.method_5673((class_1304)class_35452.method_15441(), stack);
            }
            if (hasTag) {
                this.entityWithEquipment.add((class_3545<class_1309, Set<class_2960>>)new class_3545((Object)livingEntity, part.tags));
            }
        }
        if (this.updateYawFor((VirtualElement)element, part)) {
            this.rotatingElements.add(new class_3545(element, part));
        }
        if (part instanceof EntityModelPart) {
            EntityModelPart playerModelPart = (EntityModelPart)part;
            if (element instanceof EntityModelPart.PlayerElement) {
                EntityModelPart.PlayerElement playerElement = (EntityModelPart.PlayerElement)((Object)element);
                if (playerModelPart.tags.contains(ModelTags.PLAYER_HEAD)) {
                    playerElement.copyTexture(this.dataPrivider.getGraveGameProfile());
                    ((class_1657)playerElement.entity()).method_7283(this.dataPrivider.getGraveMainArm());
                    ((class_1657)playerElement.entity()).method_5841().method_12778(PlayerEntityAccessor.getPLAYER_MODEL_PARTS(), (Object)this.dataPrivider.getGraveSkinModelLayers());
                    if (this.dataPrivider.isGravePlayerModelDelayed()) {
                        this.delayedPlayerModels.add(playerElement);
                        return;
                    }
                    playerElement.copyTexture(this.dataPrivider.getGraveGameProfile());
                }
            }
        }
        this.addElement((VirtualElement)element);
    }

    private boolean updateYawFor(VirtualElement element, ModelPart part) {
        if (part.tags.contains(ModelTags.ROUND_YAW_TO_90)) {
            this.yaw = class_2350.method_10150((double)this.yaw).method_10144();
        }
        boolean ret = false;
        if (part.rotateYaw) {
            if (element instanceof GenericEntityElement) {
                GenericEntityElement x = (GenericEntityElement)element;
                x.setYaw(this.yaw);
                ret = true;
            } else if (element instanceof EntityElement) {
                EntityElement x = (EntityElement)element;
                x.entity().method_36456(this.yaw);
                x.entity().method_5636(this.yaw);
                x.entity().method_5847(this.yaw);
                ret = true;
            }
        }
        if (part.rotatePos) {
            element.setOffset(part.position.method_1024(this.yaw * ((float)Math.PI / 180)));
            ret = true;
        }
        return ret;
    }

    public void setYaw(float value) {
        this.yaw = value;
        for (class_3545<VirtualElement, ModelPart<?, ?>> element : this.rotatingElements) {
            this.updateYawFor((VirtualElement)element.method_15442(), (ModelPart)element.method_15441());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onTick() {
        if (this.dataPrivider != null && this.world.method_8510() % 20L == 0L) {
            void var2_5;
            if (!this.delayedPlayerModels.isEmpty() && !this.dataPrivider.isGravePlayerModelDelayed()) {
                for (EntityModelPart.PlayerElement playerElement : this.delayedPlayerModels) {
                    playerElement.copyTexture(this.dataPrivider.getGraveGameProfile());
                    this.addElement((VirtualElement)playerElement);
                }
                this.delayedPlayerModels.clear();
            }
            Function<String, class_2561> placeholders = this.dataPrivider::getGravePlaceholder;
            for (TextsWithPlaceholders text : this.textsWithPlaceholders) {
                text.displayElement.setText(text.node().toText(ParserContext.of(WrappedText.DYNAMIC_NODES, placeholders)));
            }
            boolean bl = false;
            while (var2_5 < this.itemDisplays.size()) {
                boolean canContinue = true;
                class_3545<ItemDisplayElement, ItemDisplayModelPart> pair = this.itemDisplays.get((int)var2_5);
                class_2960[] class_2960Array = ModelTags.EQUIPMENT;
                int n = class_2960Array.length;
                for (int i = 0; i < n; ++i) {
                    class_1799 stack;
                    class_2960 tag = class_2960Array[i];
                    if (!((ItemDisplayModelPart)pair.method_15441()).tags.contains(tag) || (stack = this.dataPrivider.getGraveTaggedItem(tag)).method_7960()) continue;
                    ((ItemDisplayElement)pair.method_15442()).setItem(stack);
                    canContinue = false;
                    break;
                }
                if (canContinue && ((ItemDisplayModelPart)pair.method_15441()).tags.contains(ModelTags.ITEM)) {
                    ((ItemDisplayElement)pair.method_15442()).setItem(this.dataPrivider.getGraveSlotItem((int)var2_5));
                } else {
                    ((ItemDisplayElement)pair.method_15442()).setItem(class_1799.field_8037);
                }
                ++var2_5;
            }
            for (class_3545<class_1309, Set<class_2960>> pair : this.entityWithEquipment) {
                for (class_3545<class_2960, class_1304> tag : ModelTags.EQUIPMENT_WITH_SLOT) {
                    if (!((Set)pair.method_15441()).contains(tag.method_15442())) continue;
                    class_1799 stack = this.dataPrivider.getGraveTaggedItem((class_2960)tag.method_15442());
                    ((class_1309)pair.method_15442()).method_5673((class_1304)tag.method_15441(), stack);
                }
            }
        }
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        class_2680 state;
        if (BlockBoundAttachment.BLOCK_STATE_UPDATE == updateType && (state = BlockBoundAttachment.get((ElementHolder)this).getBlockState()) != this.blockState) {
            this.blockState = state;
            this.updateYaw();
            this.tick();
        }
    }

    public void maybeTick(long time) {
        this.tick();
    }

    private record TextsWithPlaceholders(TextNode node, TextDisplayElement displayElement) {
    }
}

