/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.easyelytratakeoff_common_forge.events;

import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.easyelytratakeoff_common_forge.services.Services;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ElytraEvent {
    private static final HashMap<String, Integer> newrockets = new HashMap();
    private static final HashMap<String, InteractionHand> playerhands = new HashMap();

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        int left;
        String playerName = player.getName().getString();
        if (newrockets.containsKey(playerName) && (left = newrockets.get(playerName).intValue()) > -6) {
            if (left > 0) {
                EntityFunctions.setEntityFlag((Entity)player, (int)7, (boolean)true);
                FireworkRocketEntity efr = new FireworkRocketEntity((Level)level, player.getItemInHand(InteractionHand.MAIN_HAND), (LivingEntity)player);
                level.addFreshEntity((Entity)efr);
                InteractionHand hand = playerhands.get(playerName);
                if (hand != null) {
                    ItemStack handstack = player.getItemInHand(hand);
                    String handname = handstack.getItem().getDescriptionId().toLowerCase();
                    if (handname.contains("booster_") && !handname.contains("_empty")) {
                        handstack.use((Level)level, (Player)player, hand);
                    }
                    playerhands.remove(playerName);
                }
            }
            EntityFunctions.setEntityFlag((Entity)player, (int)7, (boolean)true);
            newrockets.put(playerName, left - 1);
        }
    }

    public static InteractionResult onFirework(Player player, Level world, InteractionHand hand) {
        ItemStack handstack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        boolean isbooster = false;
        Item item = handstack.getItem();
        String itemname = item.getDescriptionId().toLowerCase();
        if (!handstack.getItem().equals(Items.FIREWORK_ROCKET)) {
            if (!itemname.contains("booster_") || itemname.contains("_empty")) {
                return InteractionResult.PASS;
            }
            isbooster = true;
        }
        if (player.isFallFlying()) {
            return InteractionResult.PASS;
        }
        BlockPos belowpos = player.blockPosition().below();
        boolean inAir = true;
        for (BlockPos next : BlockPos.betweenClosed((int)(belowpos.getX() - 1), (int)(belowpos.getY() - 1), (int)(belowpos.getZ() - 1), (int)(belowpos.getX() + 1), (int)(belowpos.getY() - 1), (int)(belowpos.getZ() + 1))) {
            Block nextblock = world.getBlockState(next).getBlock();
            if (nextblock.equals(Blocks.AIR)) continue;
            inAir = false;
            break;
        }
        if (inAir) {
            return InteractionResult.PASS;
        }
        boolean foundelytra = Services.ELYTRA.isWearingAnElytra(player);
        if (!foundelytra) {
            return InteractionResult.PASS;
        }
        String playerName = player.getName().getString();
        player.teleportTo(player.getX(), player.getY() + 0.2, player.getZ());
        newrockets.put(playerName, 1);
        playerhands.put(playerName, hand);
        if (!player.isCreative() && !isbooster) {
            handstack.shrink(1);
        }
        return InteractionResult.FAIL;
    }
}

