/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogic;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinecartComparatorLogicRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecartComparatorLogicRegistry.class);
    private static final Map<class_1299<?>, MinecartComparatorLogic<?>> LOGICS = new IdentityHashMap();

    private MinecartComparatorLogicRegistry() {
    }

    @Nullable
    public static MinecartComparatorLogic<class_1688> getCustomComparatorLogic(class_1299<?> type) {
        return LOGICS.get(type);
    }

    public static <T extends class_1688> void register(class_1299<T> type, MinecartComparatorLogic<? super T> logic) {
        Objects.requireNonNull(type, "Entity type cannot be null");
        Objects.requireNonNull(logic, "Logic cannot be null");
        if (LOGICS.put(type, logic) != null) {
            LOGGER.warn("Overriding existing minecart comparator logic for entity type {}", (Object)class_7923.field_41177.method_10221(type));
        }
    }
}

