/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.class_10386;
import net.minecraft.class_1257;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1940;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2966;
import net.minecraft.class_2981;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_34;
import net.minecraft.class_3532;
import net.minecraft.class_3551;
import net.minecraft.class_3806;
import net.minecraft.class_3807;
import net.minecraft.class_3951;
import net.minecraft.class_4486;
import net.minecraft.class_4521;
import net.minecraft.class_5219;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6506;
import net.minecraft.class_6611;
import net.minecraft.class_6904;
import net.minecraft.class_7237;
import net.minecraft.class_7497;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import net.minecraft.class_8895;
import net.minecraft.class_8909;
import net.minecraft.class_8911;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger field_24625 = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @class_10386(method_65304="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] $$0) {
        class_155.method_36208();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("recreateRegionFiles");
        OptionSpecBuilder $$9 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$10 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$16 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$17 = $$1.nonOptions();
        try {
            void $$45;
            Dynamic $$38;
            OptionSet $$18 = $$1.parse($$0);
            if ($$18.has((OptionSpec)$$10)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$19 = (Path)$$18.valueOf((OptionSpec)$$16);
            if ($$19 != null) {
                Main.method_49066($$19);
            }
            class_128.method_24305();
            if ($$18.has((OptionSpec)$$15)) {
                class_6611.field_34923.method_37981(class_6506.field_34413);
            }
            class_2966.method_12851();
            class_2966.method_17598();
            class_156.method_29476();
            Path $$20 = Paths.get("server.properties", new String[0]);
            class_3807 $$21 = new class_3807($$20);
            $$21.method_16719();
            class_4486.method_56568($$21.method_16717().field_48711);
            Path $$22 = Paths.get("eula.txt", new String[0]);
            class_2981 $$23 = new class_2981($$22);
            if ($$18.has((OptionSpec)$$3)) {
                field_24625.info("Initialized '{}' and '{}'", (Object)$$20.toAbsolutePath(), (Object)$$22.toAbsolutePath());
                return;
            }
            if (!$$23.method_12866()) {
                field_24625.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$24 = new File((String)$$18.valueOf((OptionSpec)$$11));
            class_7497 $$25 = class_7497.method_44143(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$24);
            String $$26 = Optional.ofNullable((String)$$18.valueOf((OptionSpec)$$12)).orElse($$21.method_16717().field_16820);
            class_32 $$27 = class_32.method_26999($$24.toPath());
            class_32.class_5143 $$28 = $$27.method_52236($$26);
            if ($$28.method_54547()) {
                void $$37;
                try {
                    Dynamic<?> $$29 = $$28.method_54545();
                    class_34 $$30 = $$28.method_29584($$29);
                }
                catch (IOException | class_8909 | class_8911 $$31) {
                    class_32.class_7411 $$32 = $$28.method_54543();
                    field_24625.warn("Failed to load world data from {}", (Object)$$32.method_43425(), (Object)$$31);
                    field_24625.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$33 = $$28.method_54546();
                        class_34 $$34 = $$28.method_29584($$33);
                    }
                    catch (IOException | class_8909 | class_8911 $$35) {
                        field_24625.error("Failed to load world data from {}", (Object)$$32.method_43426(), (Object)$$35);
                        field_24625.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$32.method_43425(), (Object)$$32.method_43426());
                        return;
                    }
                    $$28.method_54548();
                }
                if ($$37.method_255()) {
                    field_24625.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$37.method_38496()) {
                    field_24625.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$38 = null;
            }
            Dynamic $$39 = $$38;
            boolean $$40 = $$18.has((OptionSpec)$$9);
            if ($$40) {
                field_24625.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            class_3283 $$41 = class_3286.method_45285($$28);
            try {
                class_7237.class_6906 $$42 = Main.method_46219($$21.method_16717(), $$39, $$40, $$41);
                class_6904 $$43 = (class_6904)class_156.method_43499(arg_0 -> Main.method_43612($$42, $$39, $$18, (OptionSpec)$$4, $$21, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$44) {
                field_24625.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$44);
                return;
            }
            class_5455.class_6890 $$46 = $$45.comp_358().method_45926();
            class_5219 $$47 = $$45.comp_359();
            boolean $$48 = $$18.has((OptionSpec)$$8);
            if ($$18.has((OptionSpec)$$6) || $$48) {
                Main.method_29173($$28, $$47, class_3551.method_15450(), $$18.has((OptionSpec)$$7), () -> true, $$46, $$48);
            }
            $$28.method_27425($$46, $$47);
            final class_3176 $$49 = MinecraftServer.method_29740(arg_0 -> Main.method_29734($$28, $$41, (class_6904)$$45, $$21, $$25, $$18, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$17, arg_0));
            Thread $$50 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$49.method_3747(true);
                }
            };
            $$50.setUncaughtExceptionHandler(new class_140(field_24625));
            Runtime.getRuntime().addShutdownHook($$50);
        }
        catch (Exception $$51) {
            field_24625.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$51);
        }
    }

    private static void method_49066(Path $$0) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString($$0, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static class_7237.class_6906 method_46219(class_3806 $$0, @Nullable Dynamic<?> $$1, boolean $$2, class_3283 $$3) {
        class_7712 $$8;
        boolean $$7;
        if ($$1 != null) {
            class_7712 $$4 = class_32.method_29580($$1);
            boolean $$5 = false;
            class_7712 $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new class_7712($$0.field_39981, class_7701.field_40183);
        }
        class_7237.class_7238 $$9 = new class_7237.class_7238($$3, $$8, $$2, $$7);
        return new class_7237.class_6906($$9, class_2170.class_5364.field_25420, $$0.field_20324);
    }

    private static void method_29173(class_32.class_5143 $$0, class_5219 $$1, DataFixer $$2, boolean $$3, BooleanSupplier $$4, class_5455 $$5, boolean $$6) {
        field_24625.info("Forcing world upgrade!");
        try (class_1257 $$7 = new class_1257($$0, $$2, $$1, $$5, $$3, $$6);){
            class_2561 $$8 = null;
            while (!$$7.method_5403()) {
                int $$10;
                class_2561 $$9 = $$7.method_5394();
                if ($$8 != $$9) {
                    $$8 = $$9;
                    field_24625.info($$7.method_5394().getString());
                }
                if (($$10 = $$7.method_5397()) > 0) {
                    int $$11 = $$7.method_5400() + $$7.method_5399();
                    field_24625.info("{}% completed ({} / {} chunks)...", new Object[]{class_3532.method_15375((float)$$11 / (float)$$10 * 100.0f), $$11, $$10});
                }
                if (!$$4.getAsBoolean()) {
                    $$7.method_5402();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ class_3176 method_29734(class_32.class_5143 $$0, class_3283 $$1, class_6904 $$2, class_3807 $$3, class_7497 $$4, OptionSet $$5, OptionSpec $$6, OptionSpec $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, Thread $$11) {
        boolean $$13;
        class_3176 $$12 = new class_3176($$11, $$0, $$1, $$2, $$3, class_3551.method_15450(), $$4, class_3951::method_56042);
        $$12.method_3779((Integer)$$5.valueOf($$6));
        $$12.method_3730($$5.has($$7));
        $$12.method_17819((String)$$5.valueOf($$8));
        boolean bl = $$13 = !$$5.has($$9) && !$$5.valuesOf($$10).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.method_13948();
        }
        class_4521.field_20574.method_71664();
        return $$12;
    }

    private static /* synthetic */ CompletableFuture method_43612(class_7237.class_6906 $$0, Dynamic $$1, OptionSet $$2, OptionSpec $$3, class_3807 $$4, OptionSpec $$52, Executor $$6) {
        return class_7237.method_42098($$0, $$5 -> {
            class_7723 $$14;
            class_5285 $$13;
            class_1940 $$12;
            class_2378<class_5363> $$6 = $$5.comp_990().method_30530(class_7924.field_41224);
            if ($$1 != null) {
                class_8895 $$7 = class_32.method_54523($$1, $$5.comp_988(), $$6, $$5.comp_989());
                return new class_7237.class_7661<class_5219>($$7.comp_2008(), $$7.comp_2009().method_45537());
            }
            field_24625.info("No existing world data, creating new world");
            if ($$2.has($$3)) {
                class_1940 $$8 = MinecraftServer.field_17704;
                class_5285 $$9 = class_5285.field_40367;
                class_7723 $$10 = class_5317.method_41598($$5.comp_989());
            } else {
                class_3806 $$11 = $$4.method_16717();
                $$12 = new class_1940($$11.field_16820, $$11.field_16841, $$11.field_16838, $$11.field_16840, false, new class_1928($$5.comp_988().comp_1011()), $$5.comp_988());
                $$13 = $$2.has($$52) ? $$11.field_24623.method_28036(true) : $$11.field_24623;
                $$14 = $$11.method_45157($$5.comp_989());
            }
            class_7723.class_7725 $$15 = $$14.method_45518($$6);
            Lifecycle $$16 = $$15.method_45536().add($$5.comp_989().method_62679());
            return new class_7237.class_7661<class_31>(new class_31($$12, $$13, $$15.comp_1018(), $$16), $$15.method_45537());
        }, class_6904::new, class_156.method_18349(), $$6);
    }
}

