/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.conduitspreventdrowned.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.conduitspreventdrowned_common_forge.events.DrownedEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeDrownedEvent {
    public static void registerEventsInBus() {
        MobSpawnEvent.FinalizeSpawn.BUS.addListener(ForgeDrownedEvent::onDrownedSpawn);
    }

    @SubscribeEvent
    public static boolean onDrownedSpawn(MobSpawnEvent.FinalizeSpawn e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        Mob entity = e.getEntity();
        if (!(entity instanceof Mob)) {
            return false;
        }
        if (!DrownedEvent.onDrownedSpawn(entity, (ServerLevel)level, null, e.getSpawnReason())) {
            e.setSpawnCancelled(true);
            return true;
        }
        return false;
    }
}

