/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.sort_it_out.command.Arguments;
import io.github.jamalam360.sort_it_out.command.CommandFeedback;
import io.github.jamalam360.sort_it_out.network.BidirectionalUserPreferencesUpdatePacket;
import io.github.jamalam360.sort_it_out.preference.ServerUserPreferences;
import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_8710;

public class SortItOutCommands {
    public static void register() {
        CommandRegistrationEvent.EVENT.register(SortItOutCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 register, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sortitout").then(class_2170.method_9247((String)"help").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.translatable((CommandContext<class_2168>)ctx, "text.sort_it_out.command.help", new Object[0]), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"preferences").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"invertSorting").executes(SortItOutCommands::echoInvertSorting)).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(SortItOutCommands::setInvertSorting)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"comparators").executes(SortItOutCommands::echoComparators)).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator0").executes(ctx -> SortItOutCommands.setComparators((CommandContext<class_2168>)ctx, 1))).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator1").executes(ctx -> SortItOutCommands.setComparators((CommandContext<class_2168>)ctx, 2))).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator2").executes(ctx -> SortItOutCommands.setComparators((CommandContext<class_2168>)ctx, 3))).then(Arguments.sortingComparator("comparator3").executes(ctx -> SortItOutCommands.setComparators((CommandContext<class_2168>)ctx, 4)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slotSortingTrigger").executes(SortItOutCommands::echoSlotSortingTrigger)).then(Arguments.slotSortingTrigger("value").executes(SortItOutCommands::setSlotSortingTrigger)))));
    }

    private static void modifyConfig(CommandContext<class_2168> ctx, Consumer<UserPreferences> modifier) {
        ConfigManager<UserPreferences> manager = ServerUserPreferences.INSTANCE.getPlayerConfigManager((class_1657)((class_2168)ctx.getSource()).method_44023());
        modifier.accept((UserPreferences)manager.get());
        manager.save();
        if (((class_2168)ctx.getSource()).method_44023() != null && NetworkManager.canPlayerReceive((class_3222)((class_2168)ctx.getSource()).method_44023(), BidirectionalUserPreferencesUpdatePacket.S2C.TYPE)) {
            NetworkManager.sendToPlayer((class_3222)((class_2168)ctx.getSource()).method_44023(), (class_8710)new BidirectionalUserPreferencesUpdatePacket.S2C((UserPreferences)manager.get()));
        }
    }

    private static int echoInvertSorting(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatInvertSorting(ctx), false);
        return 1;
    }

    private static int setInvertSorting(CommandContext<class_2168> ctx) {
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.invertSorting = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
        });
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatInvertSorting(ctx), false);
        return 1;
    }

    private static int echoComparators(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatComparators(ctx), false);
        return 1;
    }

    private static int setComparators(CommandContext<class_2168> ctx, int cardinality) {
        ArrayList<UserPreferences.SortingComparator> comparators = new ArrayList<UserPreferences.SortingComparator>();
        for (int i = 0; i < cardinality; ++i) {
            comparators.add(Arguments.getSortingComparator(ctx, "comparator" + i));
        }
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.comparators = comparators;
        });
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatComparators(ctx), false);
        return 1;
    }

    private static int echoSlotSortingTrigger(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatSlotSortingTrigger(ctx), false);
        return 1;
    }

    private static int setSlotSortingTrigger(CommandContext<class_2168> ctx) {
        UserPreferences.SlotSortingTrigger trigger = Arguments.getSlotSortingTrigger(ctx, "value");
        if (trigger == null) {
            return 0;
        }
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.slotSortingTrigger = trigger;
        });
        ((class_2168)ctx.getSource()).method_9226(() -> CommandFeedback.formatSlotSortingTrigger(ctx), false);
        return 1;
    }
}

