/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.events.client.ClientPlayLifecycleEvents;
import io.github.jamalam360.sort_it_out.SortItOut;
import io.github.jamalam360.sort_it_out.client.ClientPacketWorkQueue;
import io.github.jamalam360.sort_it_out.client.ClientSortableContainer;
import io.github.jamalam360.sort_it_out.client.Config;
import io.github.jamalam360.sort_it_out.client.button.ScreenSortButtonsLoader;
import io.github.jamalam360.sort_it_out.client.mixin.AbstractContainerScreenAccessor;
import io.github.jamalam360.sort_it_out.network.BidirectionalUserPreferencesUpdatePacket;
import io.github.jamalam360.sort_it_out.network.C2SRequestSortPacket;
import io.github.jamalam360.sort_it_out.preference.ServerUserPreferences;
import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import io.github.jamalam360.sort_it_out.sort.ContainerSorterUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3302;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class SortItOutClient {
    public static final ConfigManager<Config> CONFIG = new ConfigManager("sort_it_out", "client_preferences", Config.class);
    private static class_304 sortKeyMapping;
    private static boolean isClientSortingForced;
    private static boolean isSlotIndexOverlayEnabled;

    public static void init() {
        ServerUserPreferences.INSTANCE.setClientUserPreferences(CONFIG);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)ScreenSortButtonsLoader.INSTANCE, (class_2960)SortItOut.id("sort_button_reloader"));
        sortKeyMapping = new class_304("key.sort_it_out.sort", 73, "category.sort_it_out");
        KeyMappingRegistry.register((class_304)sortKeyMapping);
        ClientTickEvent.CLIENT_LEVEL_POST.register(SortItOutClient::postLevelTick);
        ClientPlayLifecycleEvents.JOIN.register(mc -> ((Config)CONFIG.get()).sync());
        ClientScreenInputEvent.KEY_RELEASED_PRE.register(SortItOutClient::keyReleased);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(SortItOutClient::mouseReleased);
        ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.register(SortItOutClient::renderContainerForeground);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, BidirectionalUserPreferencesUpdatePacket.S2C.TYPE, BidirectionalUserPreferencesUpdatePacket.S2C.STREAM_CODEC, (prefs, ctx) -> {
            ((Config)SortItOutClient.CONFIG.get()).invertSorting = prefs.preferences().invertSorting;
            ((Config)SortItOutClient.CONFIG.get()).comparators = prefs.preferences().comparators;
            CONFIG.save();
            SortItOut.LOGGER.info("Received updated preferences from server (via config-edit commands)");
        });
        ClientCommandRegistrationEvent.EVENT.register((dispatcher, context) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"sortitoutc").then(ClientCommandRegistrationEvent.literal((String)"toggle_force_client_sort").executes(ctx -> {
            isClientSortingForced = !isClientSortingForced;
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$sendSuccess(() -> class_2561.method_43470((String)("Client Sorting Forced: " + isClientSortingForced)), false);
            return 0;
        }))).then(ClientCommandRegistrationEvent.literal((String)"toggle_slot_index_debug_renderer").executes(ctx -> {
            isSlotIndexOverlayEnabled = !isSlotIndexOverlayEnabled;
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$sendSuccess(() -> class_2561.method_43470((String)("Slot Index Debug Overlay: " + isSlotIndexOverlayEnabled)), false);
            return 0;
        }))));
    }

    public static void sortOnEitherSide(class_1703 menu, class_1735 slot) {
        if (NetworkManager.canServerReceive(C2SRequestSortPacket.TYPE) && !isClientSortingForced) {
            NetworkManager.sendToServer((class_8710)new C2SRequestSortPacket(menu.field_7763, slot.field_7874));
        } else if (!ClientPacketWorkQueue.INSTANCE.hasWorkRemaining()) {
            ContainerSorterUtil.sortWithSelectionSort(slot.field_7871, new ClientSortableContainer(slot.field_7871), (UserPreferences)CONFIG.get());
        } else {
            return;
        }
        SortItOut.playSortSound((class_1657)class_310.method_1551().field_1724);
    }

    private static void postLevelTick(class_638 level) {
        ClientPacketWorkQueue.INSTANCE.tick();
        while (sortKeyMapping.method_1436()) {
            int mouseY;
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (!(class_4372 instanceof class_465)) continue;
            class_465 containerScreen = (class_465)class_4372;
            int mouseX = (int)(class_310.method_1551().field_1729.method_1603() * (double)class_310.method_1551().method_22683().method_4486() / (double)class_310.method_1551().method_22683().method_4480());
            class_1735 slot = ((AbstractContainerScreenAccessor)containerScreen).invokeGetHoveredSlot(mouseX, mouseY = (int)(class_310.method_1551().field_1729.method_1604() * (double)class_310.method_1551().method_22683().method_4502() / (double)class_310.method_1551().method_22683().method_4507()));
            if (slot == null) {
                return;
            }
            SortItOutClient.sortOnEitherSide(class_310.method_1551().field_1724.field_7512, slot);
        }
    }

    private static void renderContainerForeground(class_465<?> screen, class_332 graphics, int mouseX, int mouseY, float delta) {
        if (ClientPacketWorkQueue.INSTANCE.hasWorkRemaining()) {
            class_327 font = class_310.method_1551().field_1772;
            class_5250 component = class_2561.method_43471((String)"text.sort_it_out.sort_in_progress");
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate(0.0f, (float)(-((AbstractContainerScreenAccessor)screen).getTopPos()));
            graphics.method_27534(font, (class_2561)component, ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, 6, 0xFFFFFF);
            graphics.method_51448().pushMatrix();
        }
        if (isSlotIndexOverlayEnabled) {
            class_2960 type;
            try {
                type = class_7923.field_41187.method_10221((Object)screen.method_17577().method_17358());
            }
            catch (UnsupportedOperationException e) {
                type = null;
            }
            graphics.method_25300(class_310.method_1551().field_1772, String.valueOf(type), ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, -50, 0xFFFFFF);
            graphics.method_25300(class_310.method_1551().field_1772, screen.getClass().getName(), ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2, -40, 0xFFFFFF);
            for (class_1735 slot : screen.method_17577().field_7761) {
                graphics.method_25303(class_310.method_1551().field_1772, "" + slot.field_7874, slot.field_7873, slot.field_7872, 0xFFFFFF);
            }
        }
    }

    private static EventResult keyReleased(class_310 minecraft, class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (sortKeyMapping.method_1417(keyCode, scanCode)) {
            class_304.method_1420((class_3675.class_306)class_3675.class_307.field_1668.method_1447(keyCode));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static EventResult mouseReleased(class_310 minecraft, class_437 screen, double x, double y, int button) {
        if (sortKeyMapping.method_1433(button)) {
            class_304.method_1420((class_3675.class_306)class_3675.class_307.field_1672.method_1447(button));
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    static {
        isClientSortingForced = false;
        isSlotIndexOverlayEnabled = false;
    }
}

