/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.client;

import io.github.jamalam360.sort_it_out.client.ClientPacketWorkQueue;
import io.github.jamalam360.sort_it_out.sort.ContainerSorterUtil;
import io.github.jamalam360.sort_it_out.sort.SortableContainer;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;

public class ClientSortableContainer
implements SortableContainer {
    private final int size;
    private final class_1263 container;
    private final class_1703 menu;
    private final HashMap<Integer, Integer> containerToMenuSlots = new HashMap();

    public ClientSortableContainer(class_1263 container) {
        this.size = container.method_5439();
        this.container = container;
        this.menu = class_310.method_1551().field_1724.field_7512;
        for (class_1735 slot : this.menu.field_7761) {
            if (slot.field_7871 != this.container) continue;
            this.containerToMenuSlots.put(slot.method_34266(), slot.field_7874);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public class_1799 getItem(int i) {
        return this.container.method_5438(i);
    }

    @Override
    public void mergeStacks(int destination, int source) {
        class_1799 sourceItem = this.getItem(source);
        int sourceCount = sourceItem.method_7947();
        class_1799 destinationItem = this.getItem(destination);
        int destinationCount = destinationItem.method_7947();
        if (!(sourceItem.method_7960() && destinationItem.method_7960() || destination == source)) {
            if (destinationCount + sourceCount <= destinationItem.method_7914()) {
                this.pickup(source);
                this.place(destination, destinationItem.method_46651(destinationCount + sourceCount));
            } else {
                int requiredToFillDestination = destinationItem.method_7914() - destinationCount;
                class_1799 remainder = sourceItem.method_46651(sourceCount - requiredToFillDestination);
                this.pickup(source);
                this.placeExpectingRemainder(destination, destinationItem.method_46651(destinationItem.method_7914()), remainder);
                this.place(source, remainder);
            }
        }
    }

    @Override
    public void swapStacks(int a, int b) {
        class_1799 aItem = this.getItem(a).method_7972();
        class_1799 bItem = this.getItem(b).method_7972();
        if (!(aItem.method_7960() && bItem.method_7960() || a == b)) {
            if (aItem.method_7960()) {
                this.moveStack(b, a);
            } else if (bItem.method_7960()) {
                this.moveStack(a, b);
            } else if (!ContainerSorterUtil.canMerge(aItem, bItem)) {
                this.pickup(a);
                this.placeAndPickupItemInSlot(b, aItem);
                this.place(a, bItem);
            } else {
                int tempSlot = this.findWorkingSlot(aItem, a, b);
                this.moveStack(a, tempSlot);
                this.moveStack(b, a);
                this.moveStack(tempSlot, b);
            }
        }
    }

    private void moveStack(int src, int dst) {
        class_1799 item = this.getItem(src).method_7972();
        this.pickup(src);
        this.place(dst, item);
    }

    private void pickup(int slot) {
        ClientPacketWorkQueue.INSTANCE.submit(new ClientPacketWorkQueue.PickupItemAction(this.menu, this.containerToMenuSlots.getOrDefault(slot, slot), this.getItem(slot).method_7972()));
        this.container.method_5447(slot, class_1799.field_8037);
    }

    private void place(int slot, class_1799 item) {
        ClientPacketWorkQueue.INSTANCE.submit(new ClientPacketWorkQueue.PlaceItem(this.menu, this.containerToMenuSlots.getOrDefault(slot, slot), item, class_1799.field_8037));
        this.container.method_5447(slot, item);
    }

    private void placeAndPickupItemInSlot(int slot, class_1799 carried) {
        ClientPacketWorkQueue.INSTANCE.submit(new ClientPacketWorkQueue.PlaceItem(this.menu, this.containerToMenuSlots.getOrDefault(slot, slot), carried, this.getItem(slot).method_7972()));
        this.container.method_5447(slot, carried);
    }

    private void placeExpectingRemainder(int slot, class_1799 newSlotContents, class_1799 expectedRemainder) {
        ClientPacketWorkQueue.INSTANCE.submit(new ClientPacketWorkQueue.PlaceItem(this.menu, this.containerToMenuSlots.getOrDefault(slot, slot), newSlotContents, expectedRemainder));
        this.container.method_5447(slot, newSlotContents);
    }

    private int findWorkingSlot(class_1799 workingItem, int ... blacklist) {
        for (int i = 0; i < this.size; ++i) {
            int finalI = i;
            if (Arrays.stream(blacklist).anyMatch(b -> finalI == b) || !this.getItem(i).method_7960() && this.getItem(i).method_7909() == workingItem.method_7909()) continue;
            return i;
        }
        return -1;
    }
}

