/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.client;

import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.github.jamalam360.sort_it_out.SortItOut;
import io.github.jamalam360.sort_it_out.client.Config;
import io.github.jamalam360.sort_it_out.client.SortItOutClient;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.class_10936;
import net.minecraft.class_10938;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2813;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class ClientPacketWorkQueue {
    public static final ClientPacketWorkQueue INSTANCE = new ClientPacketWorkQueue();
    private final Queue<ClickAction> workQueue = new LinkedList<ClickAction>();
    private int ticks = 0;

    private ClientPacketWorkQueue() {
    }

    public boolean hasWorkRemaining() {
        return !this.workQueue.isEmpty();
    }

    public void submit(ClickAction action) {
        this.workQueue.offer(action);
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks >= ((Config)SortItOutClient.CONFIG.get()).packetSendInterval) {
            this.ticks = 0;
            this.poll();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void poll() {
        class_2813 packet;
        block3: {
            block2: {
                ClickAction action = this.workQueue.poll();
                if (action == null) return;
                if (class_310.method_1551().method_1562() == null) return;
                packet = action.toPacket();
                if (class_310.method_1551().field_1755 == null) break block2;
                class_437 class_4372 = class_310.method_1551().field_1755;
                if (!(class_4372 instanceof class_465)) break block3;
                class_465 containerScreen = (class_465)class_4372;
                if (containerScreen.method_17577().field_7763 == packet.comp_3842()) break block3;
            }
            SortItOut.LOGGER.info("Aborting sort as the player closed the container window before it was completed");
            this.workQueue.clear();
            return;
        }
        class_310.method_1551().method_1562().method_52787((class_2596)packet);
    }

    public static interface ClickAction {
        public class_2813 toPacket();
    }

    public record PlaceItem(class_1703 menu, int slot, class_1799 newSlotItem, class_1799 newCarriedItem) implements ClickAction
    {
        @Override
        public class_2813 toPacket() {
            return new class_2813(this.menu().field_7763, this.menu().method_37421(), Shorts.checkedCast((long)this.slot()), SignedBytes.checkedCast((long)0L), class_1713.field_7790, Int2ObjectMaps.singleton((int)this.slot(), (Object)class_10938.method_68853((class_1799)this.newSlotItem(), (class_10936.class_10937)class_310.method_1551().method_1562().method_68823())), class_10938.method_68853((class_1799)this.newCarriedItem(), (class_10936.class_10937)class_310.method_1551().method_1562().method_68823()));
        }
    }

    public record PickupItemAction(class_1703 menu, int slot, class_1799 pickedUp) implements ClickAction
    {
        @Override
        public class_2813 toPacket() {
            return new class_2813(this.menu().field_7763, this.menu().method_37421(), Shorts.checkedCast((long)this.slot()), SignedBytes.checkedCast((long)0L), class_1713.field_7790, Int2ObjectMaps.singleton((int)this.slot(), (Object)class_10938.field_58176), class_10938.method_68853((class_1799)this.pickedUp(), (class_10936.class_10937)class_310.method_1551().method_1562().method_68823()));
        }
    }
}

