/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl.generation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import eu.pb4.polymer.resourcepack.impl.generation.InternalRPBuilder;
import eu.pb4.polymer.resourcepack.mixin.accessors.ResourceFilterAccessor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_8617;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultRPBuilder
implements InternalRPBuilder {
    public static final Gson GSON = CommonImpl.GSON;
    private static final Comparator<JsonElement> CMD_COMPARATOR = Comparator.comparingInt(x -> {
        try {
            return x.getAsJsonObject().getAsJsonObject("predicate").get("custom_model_data").getAsInt();
        }
        catch (Throwable ignored) {
            return Integer.MAX_VALUE;
        }
    });
    public final SimpleEvent<Consumer<List<String>>> buildEvent = new SimpleEvent();
    private final TreeMap<String, byte[]> fileMap = new TreeMap();
    private final Path outputPath;
    private final List<ModContainer> modsList = new ArrayList<ModContainer>();
    private final Map<String, JsonArray> atlasDefinitions = new HashMap<String, JsonArray>();
    private final Map<String, JsonObject> objectMergeDefinitions = new HashMap<String, JsonObject>();
    private final List<Path> rootPaths = new ArrayList<Path>();
    private final List<BiFunction<String, byte[], @Nullable byte[]>> converters = new ArrayList<BiFunction<String, byte[], byte[]>>();
    private boolean hasVanilla;
    private final PackMcMeta.Builder packMetadata = new PackMcMeta.Builder();
    private final List<Consumer<ResourcePackBuilder>> preFinishTask = new ArrayList<Consumer<ResourcePackBuilder>>();

    public DefaultRPBuilder(Path outputPath) {
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Couldn't create " + String.valueOf(outputPath.getParent()) + " directory!", e);
        }
        this.outputPath = outputPath;
        try {
            if (outputPath.toFile().exists()) {
                Files.deleteIfExists(outputPath);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Couldn't remove " + String.valueOf(outputPath) + " file!", (Throwable)e);
        }
    }

    private static Path getSelfPath(String path) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("polymer-resource-pack").get()).getPath(path);
    }

    @Override
    public boolean addData(String path, byte[] data) {
        try {
            if (path.endsWith(".json")) {
                if (path.equals("pack.mcmeta")) {
                    return this.addPackMcMeta(path, data, x -> {});
                }
                String[] split = path.split("/");
                if (split.length >= 3 && split[0].equals("assets")) {
                    if (split[2].equals("atlases")) {
                        return this.addAtlasFile(path, data);
                    }
                    if (split[2].equals("lang")) {
                        return this.addMergedObjectFile(path, data);
                    }
                    if (split[2].equals("sounds.json")) {
                        return this.addMergedSoundsFile(path, data);
                    }
                }
            }
            this.fileMap.put(path, data);
            return true;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while adding raw data to path: " + path, (Throwable)e);
            return false;
        }
    }

    private boolean addPackMcMeta(String path, byte[] data, Consumer<String> overlayConsumer) {
        try {
            PackMcMeta pack = PackMcMeta.fromString(new String(data, StandardCharsets.UTF_8));
            this.addPackMcMeta(pack, overlayConsumer);
            return true;
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)path, (Object)e);
            return false;
        }
    }

    private void addPackMcMeta(PackMcMeta pack, Consumer<String> overlayConsumer) {
        pack.filter().ifPresent(x -> ((ResourceFilterAccessor)x).getBlocks().forEach(this.packMetadata::addFilter));
        pack.overlays().ifPresent(x -> x.comp_1577().forEach(o -> {
            overlayConsumer.accept(o.comp_1579());
            this.packMetadata.addOverlay((class_8617.class_8618)o);
        }));
        pack.language().ifPresent(x -> x.definitions().forEach(this.packMetadata::addLanguage));
    }

    private boolean addMergedObjectFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonObject out = this.objectMergeDefinitions.computeIfAbsent(path, x -> new JsonObject());
                for (String key : obj.keySet()) {
                    out.add(key, obj.get(key));
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean addMergedSoundsFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonObject out = this.objectMergeDefinitions.computeIfAbsent(path, x -> new JsonObject());
                for (String key : obj.keySet()) {
                    JsonObject value = obj.getAsJsonObject(key);
                    if (!out.has(key) || value.has("replace") && value.get("replace").getAsBoolean()) {
                        out.add(key, obj.get(key));
                        continue;
                    }
                    JsonObject existing = out.getAsJsonObject(key);
                    if (value.has("subtitle")) {
                        existing.add("subtitle", value.get("subtitle"));
                    }
                    if (!value.has("sounds")) continue;
                    JsonElement jsonElement = existing.get("sounds");
                    if (jsonElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)jsonElement;
                        array.addAll(value.getAsJsonArray("sounds"));
                        continue;
                    }
                    existing.add("sounds", value.get("sounds"));
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean addAtlasFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonArray list = obj.getAsJsonArray("sources");
                this.atlasDefinitions.computeIfAbsent(path, x -> new JsonArray()).addAll(list);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean copyFromPath(Path basePath, String targetPrefix, boolean override) {
        try {
            if (Files.isSymbolicLink(basePath)) {
                basePath = Files.readSymbolicLink(basePath);
            }
            if (Files.isDirectory(basePath, new LinkOption[0])) {
                Path finalBasePath = basePath;
                try (Stream<Path> str = Files.walk(basePath, new FileVisitOption[0]);){
                    str.forEach(file -> {
                        Path relative = finalBasePath.relativize((Path)file);
                        String path = targetPrefix + relative.toString().replace("\\", "/");
                        if ((override || !this.fileMap.containsKey(path)) && Files.isRegularFile(file, new LinkOption[0])) {
                            try {
                                this.addData(path, Files.readAllBytes(file));
                            }
                            catch (IOException e) {
                                CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)path, (Object)e);
                            }
                        }
                    });
                }
                return true;
            }
            if (Files.isRegularFile(basePath, new LinkOption[0])) {
                try (FileSystem fs = FileSystems.newFileSystem(basePath, Collections.emptyMap());){
                    fs.getRootDirectories().forEach(path -> this.copyFromPath((Path)path, targetPrefix, override));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while copying data from: " + String.valueOf(basePath), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean copyAssets(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        if (mod.isPresent()) {
            ModContainer container = (ModContainer)mod.get();
            this.modsList.add(container);
            try {
                for (Path rootPaths : container.getRootPaths()) {
                    try (Stream<Path> str = Files.list(rootPaths);){
                        str.forEach(file -> {
                            try {
                                String name = file.getFileName().toString();
                                if (name.toLowerCase(Locale.ROOT).contains("license") || name.toLowerCase(Locale.ROOT).contains("licence")) {
                                    this.addData("licenses/" + modId + "/" + name, Files.readAllBytes(file));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                    }
                    catch (Throwable e) {
                        CommonImpl.LOGGER.warn("Failed while copying the license!", e);
                    }
                    ArrayList<String> baseToCopy = new ArrayList<String>();
                    baseToCopy.add("assets");
                    try {
                        Path packFile = rootPaths.resolve("pack.mcmeta");
                        if (Files.exists(packFile, new LinkOption[0])) {
                            PackMcMeta pack = PackMcMeta.fromString(Files.readString(packFile));
                            this.addPackMcMeta(pack, baseToCopy::add);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    for (String x : baseToCopy) {
                        Path assets = rootPaths.resolve(x);
                        if (!Files.exists(assets, new LinkOption[0])) continue;
                        Stream<Path> str = Files.walk(assets, new FileVisitOption[0]);
                        try {
                            str.forEach(file -> {
                                Path relative = assets.relativize((Path)file);
                                String path = relative.toString().replace("\\", "/");
                                if (Files.isRegularFile(file, new LinkOption[0])) {
                                    try {
                                        this.addData(x + "/" + path, Files.readAllBytes(file));
                                    }
                                    catch (IOException e) {
                                        CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)(String.valueOf(assets) + "/" + path), (Object)e);
                                    }
                                }
                            });
                        }
                        finally {
                            if (str == null) continue;
                            str.close();
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                CommonImpl.LOGGER.error("Something went wrong while copying assets of mod: " + modId, (Throwable)e);
                return false;
            }
        }
        CommonImpl.LOGGER.warn("Tried to copy assets from non existing mod " + modId);
        return false;
    }

    @Override
    public byte[] getData(String path) {
        return this.fileMap.get(path);
    }

    @Override
    @Nullable
    public byte[] getDataOrSource(String path) {
        if (this.fileMap.containsKey(path)) {
            return this.fileMap.get(path);
        }
        return this.getSourceData(path);
    }

    @Override
    public void forEachFile(BiConsumer<String, byte[]> consumer) {
        Map.copyOf(this.fileMap).forEach(consumer);
    }

    @Override
    public boolean addAssetsSource(String modId) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            this.rootPaths.addAll(((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getRootPaths());
            return true;
        }
        return false;
    }

    @Override
    public void addWriteConverter(BiFunction<String, byte[], @Nullable byte[]> converter) {
        this.converters.add(converter);
    }

    @Override
    public void addPreFinishTask(Consumer<ResourcePackBuilder> consumer) {
        this.preFinishTask.add(consumer);
    }

    @Nullable
    private byte[] getSourceData(String path) {
        try {
            InputStream stream = this.getSourceStream(path);
            if (stream != null) {
                return stream.readAllBytes();
            }
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", e);
        }
        return null;
    }

    @Nullable
    private InputStream getSourceStream(String path) {
        try {
            if (!this.hasVanilla && path.startsWith("assets/minecraft/")) {
                this.rootPaths.add(PolymerCommonUtils.getClientJarRoot());
                this.hasVanilla = true;
            }
            for (Path rootPath : this.rootPaths) {
                Path entry = rootPath.resolve(path);
                if (!Files.exists(entry, new LinkOption[0])) continue;
                return Files.newInputStream(entry, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", (Throwable)e);
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> buildResourcePack() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<Object> credits = new ArrayList<Object>();
                credits.add("");
                credits.add("  +-----------+");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |    ###    |");
                credits.add("  |           |");
                credits.add("  |           |");
                credits.add("  +-----------+");
                credits.add("");
                credits.add("Generated with Polymer " + CommonImpl.VERSION);
                credits.add("");
                credits.add("Vanilla assets by Mojang Studios");
                credits.add("");
                credits.add("Contains assets from mods: ");
                for (ModContainer modContainer : this.modsList) {
                    StringBuilder stringBuilder = new StringBuilder(" - ").append(modContainer.getMetadata().getName()).append(" (").append(modContainer.getMetadata().getId()).append(")");
                    if (!modContainer.getMetadata().getLicense().isEmpty()) {
                        stringBuilder.append(" / License: ");
                        Iterator iter = modContainer.getMetadata().getLicense().iterator();
                        while (iter.hasNext()) {
                            stringBuilder.append((String)iter.next());
                            if (!iter.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                    }
                    modContainer.getMetadata().getContact().get("homepage").ifPresent(s -> b.append(" / Website: ").append((String)s));
                    modContainer.getMetadata().getContact().get("source").ifPresent(s -> b.append(" / Source: ").append((String)s));
                    credits.add(stringBuilder.toString());
                }
                credits.add("");
                credits.add("See licenses folder for more information!");
                credits.add("");
                this.buildEvent.invoke(c -> c.accept(credits));
                boolean bool = true;
                for (Map.Entry<String, JsonArray> entry : this.atlasDefinitions.entrySet()) {
                    JsonObject obj = new JsonObject();
                    obj.add("sources", (JsonElement)entry.getValue());
                    this.fileMap.put(entry.getKey(), obj.toString().getBytes(StandardCharsets.UTF_8));
                }
                for (Map.Entry<String, JsonObject> entry : this.objectMergeDefinitions.entrySet()) {
                    this.fileMap.put(entry.getKey(), entry.getValue().toString().getBytes(StandardCharsets.UTF_8));
                }
                this.fileMap.put(AssetPaths.PACK_METADATA, this.packMetadata.build().asString().getBytes(StandardCharsets.UTF_8));
                if (!this.fileMap.containsKey(AssetPaths.PACK_ICON)) {
                    Path path = FabricLoader.getInstance().getGameDir().resolve("server-icon.png");
                    if (path.toFile().exists()) {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(path));
                    } else {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(DefaultRPBuilder.getSelfPath("assets/icon.png")));
                    }
                }
                this.fileMap.put("polymer-credits.txt", String.join((CharSequence)"\n", credits).getBytes(StandardCharsets.UTF_8));
                for (Consumer<ResourcePackBuilder> consumer : this.preFinishTask) {
                    consumer.accept(this);
                }
                return bool &= this.writeSingleZip();
            }
            catch (Exception e) {
                CommonImpl.LOGGER.error("Something went wrong while creating resource pack!", (Throwable)e);
                return false;
            }
        });
    }

    @Override
    public PackMcMeta.Builder getPackMcMetaBuilder() {
        return this.packMetadata;
    }

    private boolean writeSingleZip() {
        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(this.outputPath.toFile()));){
            for (String path : this.fileMap.keySet().toArray(new String[0])) {
                ArrayList<String> split = new ArrayList<String>(List.of(path.split("/")));
                while (split.size() > 1) {
                    split.removeLast();
                    this.fileMap.put(String.join((CharSequence)"/", split) + "/", null);
                }
            }
            ArrayList<Map.Entry<String, byte[]>> sorted = new ArrayList<Map.Entry<String, byte[]>>(this.fileMap.entrySet());
            sorted.sort(Map.Entry.comparingByKey());
            for (Map.Entry<String, byte[]> entry : sorted) {
                String path;
                path = entry.getKey();
                byte[] outByte = entry.getValue();
                if (outByte != null) {
                    BiFunction<String, byte[], byte[]> conv;
                    Iterator<BiFunction<String, byte[], byte[]>> iterator = this.converters.iterator();
                    while (iterator.hasNext() && (outByte = (conv = iterator.next()).apply(path, outByte)) != null) {
                    }
                    if (outByte == null) continue;
                }
                ZipEntry zipEntry = new ZipEntry(path);
                zipEntry.setTime(0L);
                outputStream.putNextEntry(zipEntry);
                if (outByte != null) {
                    outputStream.write(outByte);
                }
                outputStream.closeEntry();
            }
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Failed to write the zip file!", e);
            return false;
        }
        return true;
    }

    private class_2960 vId(String path) {
        return class_2960.method_60654((String)path);
    }

    public static enum OverridePlace {
        BEFORE_EXISTING,
        EXISTING,
        WITH_CUSTOM_MODEL_DATA,
        END;

    }
}

