/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl.compat.polymc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import io.github.theepicblock.polymc.PolyMc;
import io.github.theepicblock.polymc.api.resource.PolyMcResourcePack;
import io.github.theepicblock.polymc.impl.misc.logging.SimpleLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PolyMcHelpers {
    public static void importPolyMcResources(ResourcePackBuilder builder) {
        PolyMcResourcePack pack = PolyMc.getMapForResourceGen().generateResourcePack(new SimpleLogger(){

            public void error(String string) {
                PolyMc.LOGGER.error(string);
            }

            public void warn(String string) {
                PolyMc.LOGGER.warn(string);
            }

            public void info(String string) {
            }
        });
        if (pack == null) {
            return;
        }
        pack.forEachAsset((namespace, path, asset) -> {
            try {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                asset.writeToStream((OutputStream)data, pack.getGson());
                builder.addData(String.format("assets/%s/%s", namespace, path), data.toByteArray());
                asset.writeMetaToStream(() -> new PolymerRPOutputStream(String.format("assets/%s/%s.mcmeta", namespace, path), builder), pack.getGson());
            }
            catch (IOException e) {
                CommonImpl.LOGGER.error("Error importing " + namespace + ":" + path + " from PolyMc");
                e.printStackTrace();
            }
        });
    }

    public static void overrideCommand(MinecraftServer server) {
        CommandDispatcher dispatcher = server.method_3734().method_9235();
        ArgumentBuilder generateNode = dispatcher.findNode(List.of("polymc", "generate")).createBuilder();
        dispatcher.register((LiteralArgumentBuilder)dispatcher.findNode(List.of("polymc")).createBuilder().then(generateNode.then(class_2170.method_9247((String)"resources").executes(PolymerResourcePackMod::generateResources))));
    }

    public static class PolymerRPOutputStream
    extends ByteArrayOutputStream {
        private final String path;
        private final ResourcePackBuilder builder;

        public PolymerRPOutputStream(String path, ResourcePackBuilder builder) {
            this.path = path;
            this.builder = builder;
        }

        @Override
        public void close() throws IOException {
            this.builder.addData(this.path, this.toByteArray());
            super.close();
        }
    }
}

