/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl;

import com.google.gson.annotations.SerializedName;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;

public class PolymerResourcePackImpl {
    public static final boolean FORCE_REQUIRE;
    public static final UUID MAIN_UUID;
    public static final Path DEFAULT_PATH;
    public static final String FILE_NAME;
    public static final boolean IGNORE_PACK_VERSION;

    public static Config loadConfig() {
        return (Config)CommonImpl.loadConfig((String)"resource-pack", Config.class);
    }

    static {
        Config config = PolymerResourcePackImpl.loadConfig();
        DEFAULT_PATH = FabricLoader.getInstance().getGameDir().resolve(config.resourcePackPath);
        FILE_NAME = config.resourcePackPath;
        MAIN_UUID = config.mainUuid;
        IGNORE_PACK_VERSION = config.ignorePackVersion;
        FORCE_REQUIRE = config.markResourcePackAsRequiredByDefault || CompatStatus.POLYMC;
    }

    public static class Config {
        public String _c0 = "UUID of default/main resource pack.";
        @SerializedName(value="main_uuid")
        public UUID mainUuid = UUID.randomUUID();
        public String _c1 = "Marks resource pack as required, only effects clients and mods using api to check it";
        public boolean markResourcePackAsRequiredByDefault = false;
        public String _c5 = "Included resource packs from mods!";
        @SerializedName(value="include_mod_assets")
        public List<String> includeModAssets = new ArrayList<String>();
        public String _c6 = "Included resource packs from zips!";
        @SerializedName(value="include_zips")
        public List<String> includeZips = List.of("world/resources.zip");
        public String _c7 = "Path used for creation of default resourcepack!";
        @SerializedName(value="resource_pack_location")
        public String resourcePackPath = "polymer/resource_pack.zip";
        public String _c8 = "Prevents selected paths from being added to resource pack, if they start with provided text.";
        @SerializedName(value="prevent_path_with")
        public List<String> preventedPaths = List.of();
        public String _c9 = "Removes the incompatibility warning on the default pack, by marking it as compatible with everything.";
        @SerializedName(value="ignore_pack_version")
        public boolean ignorePackVersion = false;
    }
}

