/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.message.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;

public final class ServerMessageEvents {
    public static final Event<AllowChatMessage> ALLOW_CHAT_MESSAGE = EventFactory.createArrayBacked(AllowChatMessage.class, handlers -> (message, sender, params) -> {
        for (AllowChatMessage handler : handlers) {
            if (handler.allowChatMessage(message, sender, params)) continue;
            return false;
        }
        return true;
    });
    public static final Event<AllowGameMessage> ALLOW_GAME_MESSAGE = EventFactory.createArrayBacked(AllowGameMessage.class, handlers -> (server, message, overlay) -> {
        for (AllowGameMessage handler : handlers) {
            if (handler.allowGameMessage(server, message, overlay)) continue;
            return false;
        }
        return true;
    });
    public static final Event<AllowCommandMessage> ALLOW_COMMAND_MESSAGE = EventFactory.createArrayBacked(AllowCommandMessage.class, handlers -> (message, source, params) -> {
        for (AllowCommandMessage handler : handlers) {
            if (handler.allowCommandMessage(message, source, params)) continue;
            return false;
        }
        return true;
    });
    public static final Event<ChatMessage> CHAT_MESSAGE = EventFactory.createArrayBacked(ChatMessage.class, handlers -> (message, sender, params) -> {
        for (ChatMessage handler : handlers) {
            handler.onChatMessage(message, sender, params);
        }
    });
    public static final Event<GameMessage> GAME_MESSAGE = EventFactory.createArrayBacked(GameMessage.class, handlers -> (server, message, overlay) -> {
        for (GameMessage handler : handlers) {
            handler.onGameMessage(server, message, overlay);
        }
    });
    public static final Event<CommandMessage> COMMAND_MESSAGE = EventFactory.createArrayBacked(CommandMessage.class, handlers -> (message, source, params) -> {
        for (CommandMessage handler : handlers) {
            handler.onCommandMessage(message, source, params);
        }
    });

    private ServerMessageEvents() {
    }

    @FunctionalInterface
    public static interface CommandMessage {
        public void onCommandMessage(class_7471 var1, class_2168 var2, class_2556.class_7602 var3);
    }

    @FunctionalInterface
    public static interface GameMessage {
        public void onGameMessage(MinecraftServer var1, class_2561 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface ChatMessage {
        public void onChatMessage(class_7471 var1, class_3222 var2, class_2556.class_7602 var3);
    }

    @FunctionalInterface
    public static interface AllowCommandMessage {
        public boolean allowCommandMessage(class_7471 var1, class_2168 var2, class_2556.class_7602 var3);
    }

    @FunctionalInterface
    public static interface AllowGameMessage {
        public boolean allowGameMessage(MinecraftServer var1, class_2561 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AllowChatMessage {
        public boolean allowChatMessage(class_7471 var1, class_3222 var2, class_2556.class_7602 var3);
    }
}

