/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.server.translations.impl;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nucleoid.server.translations.api.LocalizationTarget;
import xyz.nucleoid.server.translations.api.language.ServerLanguage;
import xyz.nucleoid.server.translations.api.language.ServerLanguageDefinition;
import xyz.nucleoid.server.translations.impl.language.LanguageReader;
import xyz.nucleoid.server.translations.impl.language.ServerLanguageDefinitionReaders;
import xyz.nucleoid.server.translations.impl.language.TranslationMap;
import xyz.nucleoid.server.translations.impl.language.TranslationStore;
import xyz.nucleoid.server.translations.impl.language.TranslationsReloadListener;

public final class ServerTranslations
implements IdentifiableResourceReloadListener,
ModInitializer,
ServerLifecycleEvents.ServerStopped {
    public static final String ID = "server_translations_api";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ServerTranslations INSTANCE = new ServerTranslations();
    public static final ThreadLocal<ServerLanguage> TRANSLATION_CONTEXT = ThreadLocal.withInitial(() -> null);
    private final SortedMap<String, ServerLanguageDefinition> supportedLanguages = new Object2ObjectRBTreeMap();
    private final TranslationStore translations = new TranslationStore();
    private final Map<String, ServerLanguage> serverLanguages = new Object2ObjectOpenHashMap();
    public final LocalizationTarget systemTarget = () -> this.getSystemLanguage().definition().code();
    private ServerLanguage defaultLanguage;
    private ServerLanguage systemLanguage;
    private final List<TranslationsReloadListener> reloadListeners = new ArrayList<TranslationsReloadListener>();
    private final Map<String, String> CODE_ALIAS = new HashMap<String, String>();

    private ServerTranslations() {
        this.loadSupportedLanguages();
        this.reload();
    }

    private void loadSupportedLanguages() {
        try {
            class_3545<List<ServerLanguageDefinition>, Map<String, String>> pair = ServerLanguageDefinitionReaders.loadLanguageDefinitions();
            List definitions = (List)pair.method_15442();
            for (ServerLanguageDefinition language : definitions) {
                this.supportedLanguages.put(language.code(), language);
            }
            this.CODE_ALIAS.putAll((Map)pair.method_15441());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load server language definitions", (Throwable)e);
        }
    }

    private void reload() {
        this.translations.clear();
        this.serverLanguages.clear();
        this.defaultLanguage = this.createLanguage(ServerLanguageDefinition.DEFAULT);
        if (this.systemLanguage != null) {
            this.setSystemLanguage(this.systemLanguage.definition());
        } else {
            this.setSystemLanguage(ServerLanguageDefinition.DEFAULT);
        }
        this.reloadListeners.forEach(TranslationsReloadListener::reload);
    }

    public void addTranslations(String code, Supplier<TranslationMap> supplier) {
        this.translations.add(code, supplier);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable LocalizationTarget target) {
        return this.getLanguage(target != null ? target.getLanguageCode() : null);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable String code) {
        if (code == null) {
            return this.defaultLanguage;
        }
        ServerLanguage language = this.serverLanguages.get(code);
        if (language != null) {
            return language;
        }
        ServerLanguageDefinition definition = (ServerLanguageDefinition)this.supportedLanguages.get(code);
        if (definition != null) {
            return this.createLanguage(definition);
        }
        return this.defaultLanguage;
    }

    @NotNull
    public ServerLanguageDefinition getLanguageDefinition(@Nullable String code) {
        if (code == null) {
            return ServerLanguageDefinition.DEFAULT;
        }
        return this.supportedLanguages.getOrDefault(code, ServerLanguageDefinition.DEFAULT);
    }

    private ServerLanguage createLanguage(ServerLanguageDefinition definition) {
        TranslationMap translations = this.translations.get(definition.code());
        TranslationMap defaultTranslations = this.translations.get("en_us");
        ServerLanguage language = new ServerLanguage(definition, translations.union(defaultTranslations));
        this.serverLanguages.put(definition.code(), language);
        return language;
    }

    public void setSystemLanguage(ServerLanguageDefinition definition) {
        this.systemLanguage = Objects.requireNonNull(this.getLanguage(definition.code()));
    }

    @NotNull
    public ServerLanguage getSystemLanguage() {
        return this.systemLanguage;
    }

    @NotNull
    public ServerLanguage getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Iterable<ServerLanguageDefinition> getAllLanguages() {
        return this.supportedLanguages.values();
    }

    public void registerReloadListener(TranslationsReloadListener reloadListener) {
        this.reloadListeners.add(reloadListener);
    }

    private int getTranslationKeyCount() {
        return this.translations.get(this.systemLanguage.definition().code()).size();
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Multimap> future = CompletableFuture.supplyAsync(() -> {
            this.reload();
            return LanguageReader.collectDataPackTranslations(manager);
        });
        return ((CompletableFuture)future.thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(v -> {
            Multimap languageSuppliers = (Multimap)future.join();
            languageSuppliers.forEach(this.translations::add);
            int keyCount = INSTANCE.getTranslationKeyCount();
            LOGGER.info(class_2561.method_43469((String)"text.translated_server.loaded.translation_key", (Object[])new Object[]{String.valueOf(keyCount)}).getString());
        });
    }

    public String method_22322() {
        return super.method_22322();
    }

    public String getCodeAlias(String code) {
        return this.CODE_ALIAS.getOrDefault(code, code);
    }

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        ServerLifecycleEvents.SERVER_STOPPED.register((Object)INSTANCE);
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)ID, (String)"translations");
    }

    public void onServerStopped(MinecraftServer server) {
        this.translations.clear();
        this.serverLanguages.clear();
    }
}

