/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.config;

import com.google.gson.Gson;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.BaseGson;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.data.LegacyConfigData;
import eu.pb4.graves.model.DefaultGraveModels;
import eu.pb4.graves.model.GraveModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7225;

public class ConfigManager {
    public static final int VERSION = 4;
    private static final Path BASE_CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("universal-graves/");
    private static final Path CONFIG_PATH = BASE_CONFIG_PATH.resolve("config.json");
    private static final Path MODELS_PATH = BASE_CONFIG_PATH.resolve("models/");
    private static final Path EXAMPLE_MODELS_PATH = BASE_CONFIG_PATH.resolve("example_models/");
    private static final Path OLD_CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("universal-graves.json");
    private static final Map<String, GraveModel> MODELS = new HashMap<String, GraveModel>();
    private static Config CONFIG = new Config();
    private static boolean ENABLED = false;

    public static Config getConfig() {
        if (CONFIG == null) {
            return Config.DEFAULT;
        }
        return CONFIG;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static boolean loadConfig(class_7225.class_7874 lookup) {
        ENABLED = false;
        CONFIG = null;
        try {
            Gson gson = BaseGson.getGson(lookup);
            MODELS.clear();
            Files.createDirectories(EXAMPLE_MODELS_PATH, new FileAttribute[0]);
            DefaultGraveModels.forEach((name, model) -> {
                try {
                    MODELS.put((String)name, (GraveModel)model);
                    Files.writeString(EXAMPLE_MODELS_PATH.resolve(name + ".json"), (CharSequence)gson.toJson(model), new OpenOption[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            if (Files.exists(MODELS_PATH, new LinkOption[0])) {
                Files.newDirectoryStream(MODELS_PATH).forEach(path -> {
                    try {
                        String name = MODELS_PATH.relativize((Path)path).toString();
                        MODELS.put(name.substring(0, name.length() - 5), (GraveModel)gson.fromJson(Files.readString(path), GraveModel.class));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            } else {
                Files.createDirectories(MODELS_PATH, new FileAttribute[0]);
            }
            Config config = Files.exists(CONFIG_PATH, new LinkOption[0]) ? (Config)gson.fromJson(Files.readString(CONFIG_PATH), Config.class) : (Files.exists(OLD_CONFIG_PATH, new LinkOption[0]) ? ((LegacyConfigData)gson.fromJson(Files.readString(OLD_CONFIG_PATH), LegacyConfigData.class)).convert() : new Config());
            config.version = 4;
            config.fillMissing();
            ConfigManager.overrideConfig(config, lookup);
            CONFIG = config;
            ENABLED = true;
        }
        catch (Throwable exception) {
            ENABLED = false;
            GravesMod.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static void overrideConfig(Config configData, class_7225.class_7874 lookup) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)BaseGson.getGson(lookup).toJson((Object)configData), new OpenOption[0]);
            CONFIG = configData;
        }
        catch (Exception e) {
            GravesMod.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }

    public static GraveModel getModel(String model) {
        if (GravesMod.DEV && model.equals("debug")) {
            return DefaultGraveModels.debug();
        }
        return MODELS.getOrDefault(model, DefaultGraveModels.FALLBACK);
    }

    public static void clearConfig() {
        CONFIG = null;
    }
}

