/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.networking;

import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerBlockPosStorage;
import eu.pb4.polymer.core.impl.interfaces.PolymerIdList;
import eu.pb4.polymer.core.impl.interfaces.RegistryExtension;
import eu.pb4.polymer.core.impl.networking.S2CPackets;
import eu.pb4.polymer.core.impl.networking.entry.DebugBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.entry.IdValueEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerBlockEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerEntityEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerItemEntry;
import eu.pb4.polymer.core.impl.networking.entry.PolymerTagEntry;
import eu.pb4.polymer.core.impl.networking.payloads.PolymerGenericListPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerBlockUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerEntityS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupApplyUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupContentAddS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupContentClearS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupDefineS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerItemGroupRemoveS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSectionUpdateS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncClearS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncFinishedS2CPayload;
import eu.pb4.polymer.core.impl.networking.payloads.s2c.PolymerSyncStartedS2CPayload;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4076;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import xyz.nucleoid.packettweaker.PacketContext;

@ApiStatus.Internal
public class PolymerServerProtocol {
    public static void sendBlockUpdate(class_3244 player, class_2338 pos, class_2680 state) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)S2CPackets.WORLD_SET_BLOCK_UPDATE);
        if (PolymerImplUtils.POLYMER_STATES.contains(state) && version > -1) {
            player.method_14364((class_2596)new class_2658((class_8710)new PolymerBlockUpdateS2CPayload(pos, class_2248.field_10651.method_10206((Object)state))));
        }
    }

    public static void sendMultiBlockUpdate(class_3244 player, class_4076 chunkPos, short[] positions, class_2680[] blockStates) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)S2CPackets.WORLD_CHUNK_SECTION_UPDATE);
        if (version > -1) {
            IntArrayList blocks = new IntArrayList();
            ShortArrayList pos = new ShortArrayList();
            for (int i = 0; i < blockStates.length; ++i) {
                if (!PolymerImplUtils.POLYMER_STATES.contains(blockStates[i])) continue;
                blocks.add(class_2248.field_10651.method_10206((Object)blockStates[i]));
                pos.add(positions[i]);
            }
            if (!blocks.isEmpty()) {
                player.method_14364((class_2596)new class_2658((class_8710)new PolymerSectionUpdateS2CPayload(chunkPos, pos.toShortArray(), blocks.toIntArray())));
            }
        }
    }

    public static void sendSectionUpdate(class_3244 player, class_2818 chunk) {
        PolymerBlockPosStorage wci;
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)S2CPackets.WORLD_CHUNK_SECTION_UPDATE);
        if (version > -1 && (wci = (PolymerBlockPosStorage)chunk).polymer$hasAny()) {
            class_2826[] sections = chunk.method_12006();
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                PolymerBlockPosStorage storage = (PolymerBlockPosStorage)section;
                if (section == null || !storage.polymer$hasAny()) continue;
                ShortSet set = storage.polymer$getBackendSet();
                IntArrayList blocks = new IntArrayList();
                assert (set != null);
                for (Short pos : set) {
                    int x = class_4076.method_30551((short)pos);
                    int y = class_4076.method_30552((short)pos);
                    int z = class_4076.method_30553((short)pos);
                    class_2680 state = section.method_12254(x, y, z);
                    blocks.add(class_2248.field_10651.method_10206((Object)state));
                }
                player.method_14364((class_2596)new class_2658((class_8710)new PolymerSectionUpdateS2CPayload(class_4076.method_18681((class_1923)chunk.method_12004(), (int)chunk.method_31604(i)), set.toShortArray(), blocks.toIntArray())));
            }
        }
    }

    public static void sendSyncPackets(class_3244 handler, boolean fullSync) {
        if (PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.SYNC_STARTED) == -1) {
            return;
        }
        long startTime = System.nanoTime();
        handler.method_14364((class_2596)new class_2658((class_8710)new PolymerSyncStartedS2CPayload()));
        PolymerSyncUtils.ON_SYNC_STARTED.invoke(c -> c.accept(handler));
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.SYNC_CLEAR);
        if (version != -1) {
            handler.method_14364((class_2596)new class_2658((class_8710)new PolymerSyncClearS2CPayload()));
        }
        PolymerSyncUtils.BEFORE_ITEM_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_ITEM_ID, PolymerServerProtocol.getServerSideEntries(class_7923.field_41178), false, PolymerItemEntry::of);
        PolymerSyncUtils.AFTER_ITEM_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        if (fullSync) {
            PolymerSyncUtils.BEFORE_ITEM_GROUP_SYNC.invoke(listener -> listener.accept(handler, true));
            PolymerServerProtocol.sendCreativeSyncPackets(handler);
            PolymerSyncUtils.AFTER_ITEM_GROUP_SYNC.invoke(listener -> listener.accept(handler, true));
        }
        PolymerSyncUtils.BEFORE_BLOCK_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_BLOCK_ID, PolymerServerProtocol.getServerSideEntries(class_7923.field_41175), false, PolymerBlockEntry::of);
        PolymerSyncUtils.AFTER_BLOCK_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerSyncUtils.BEFORE_BLOCK_STATE_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_BLOCKSTATE_ID, PolymerServerProtocol.getServerSideEntries(class_2248.field_10651), false, PolymerBlockStateEntry::of);
        PolymerSyncUtils.AFTER_BLOCK_STATE_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerSyncUtils.BEFORE_ENTITY_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_ENTITY_ID, PolymerServerProtocol.getServerSideEntries(class_7923.field_41177), false, PolymerEntityEntry::of);
        PolymerSyncUtils.AFTER_ENTITY_SYNC.invoke(listener -> listener.accept(handler, fullSync));
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_VILLAGER_PROFESSION_ID, (class_2378)class_7923.field_41195);
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_STATUS_EFFECT_ID, class_7923.field_41174);
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_BLOCK_ENTITY_ID, class_7923.field_41181);
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_FLUID_ID, (class_2378)class_7923.field_41173);
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_DATA_COMPONENT_TYPE_ID, class_7923.field_49658);
        PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_ENCHANTMENT_COMPONENT_TYPE_ID, class_7923.field_51832);
        if (fullSync) {
            PolymerServerProtocol.sendSync(handler, S2CPackets.SYNC_TAGS_ID, class_7923.field_41167, true, PolymerTagEntry::of);
        }
        PolymerSyncUtils.ON_SYNC_CUSTOM.invoke(c -> c.accept(handler, fullSync));
        PolymerSyncUtils.ON_SYNC_FINISHED.invoke(c -> c.accept(handler));
        handler.method_14364((class_2596)new class_2658((class_8710)new PolymerSyncFinishedS2CPayload()));
        if (PolymerImpl.LOG_SYNC_TIME) {
            PolymerImpl.LOGGER.info((fullSync ? "Full" : "Partial") + " sync for {} took {} ms", (Object)handler.field_14140.method_7334().getName(), (Object)((double)((System.nanoTime() - startTime) / 10000L) / 100.0));
        }
    }

    private static <T> Collection<T> getServerSideEntries(class_2359<T> registry) {
        if (registry instanceof class_2378) {
            class_2378 registry1 = (class_2378)registry;
            return RegistryExtension.getPolymerEntries(registry1);
        }
        if (registry instanceof PolymerIdList) {
            return ((PolymerIdList)registry).polymer$getPolymerEntries();
        }
        return List.of();
    }

    private static void sendSync(class_3244 handler, class_8710.class_9154<PolymerGenericListPayload<IdValueEntry>> packetId, class_2378 registry) {
        PolymerServerProtocol.sendSync(handler, packetId, PolymerServerProtocol.getServerSideEntries(registry), false, (T type) -> new IdValueEntry(registry.method_10206(type), registry.method_10221(type)));
    }

    public static void sendCreativeSyncPackets(class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.SYNC_ITEM_GROUP_DEFINE);
        if (version != -1) {
            for (class_1761 group : PolymerItemGroupUtils.getItemGroups(handler.method_32311())) {
                PolymerServerProtocol.syncItemGroup(group, handler);
            }
            handler.method_14364((class_2596)new class_2658((class_8710)new PolymerItemGroupApplyUpdateS2CPayload()));
        }
    }

    public static void syncItemGroup(class_1761 group, class_3244 handler) {
        if (PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC || PolymerItemGroupUtils.isPolymerItemGroup(group)) {
            PolymerServerProtocol.removeItemGroup(group, handler);
            PolymerServerProtocol.syncItemGroupDefinition(group, handler);
        }
        PolymerServerProtocol.syncItemGroupContents(group, handler);
    }

    public static void syncItemGroupContents(class_1761 group, class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.SYNC_ITEM_GROUP_CONTENTS_ADD);
        if (version != -1) {
            class_2960 id = PolymerItemGroupUtils.getId(group);
            if (id == null) {
                return;
            }
            handler.method_14364((class_2596)new class_2658((class_8710)new PolymerItemGroupContentClearS2CPayload(id)));
            try {
                PolymerItemGroupContentAddS2CPayload entry = PolymerItemGroupContentAddS2CPayload.of(version, group, handler);
                if (entry.isNonEmpty()) {
                    handler.method_14364((class_2596)new class_2658((class_8710)entry));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void syncItemGroupDefinition(class_1761 group, class_3244 handler) {
        class_2960 id;
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.SYNC_ITEM_GROUP_DEFINE);
        if (version > -1 && (PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC || PolymerItemGroupUtils.isPolymerItemGroup(group)) && (id = PolymerItemGroupUtils.getId(group)) != null) {
            handler.method_14364((class_2596)new class_2658((class_8710)new PolymerItemGroupDefineS2CPayload(id, group.method_7737(), group.method_7747())));
        }
    }

    public static void removeItemGroup(class_1761 group, class_3244 player) {
        class_2960 x;
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)S2CPackets.SYNC_ITEM_GROUP_REMOVE);
        if (version > -1 && PolymerItemGroupUtils.isPolymerItemGroup(group) && (x = PolymerItemGroupUtils.REGISTRY.getId(group)) != null) {
            player.method_14364((class_2596)new class_2658((class_8710)new PolymerItemGroupRemoveS2CPayload(x)));
        }
    }

    public static void sendEntityInfo(class_3244 player, class_1297 entity) {
        PolymerServerProtocol.sendEntityInfo(player, entity.method_5628(), entity.method_5864());
    }

    public static void sendEntityInfo(class_3244 player, int id, class_1299<?> type) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)player, (class_2960)S2CPackets.WORLD_ENTITY);
        if (version != -1) {
            player.method_14364((class_2596)new class_2658((class_8710)new PolymerEntityS2CPayload(id, class_7923.field_41177.method_10221(type))));
        }
    }

    private static <T> void sendSync(class_3244 handler, class_8710.class_9154<PolymerGenericListPayload<T>> id, List<T> entries) {
        handler.method_14364((class_2596)new class_2658(new PolymerGenericListPayload<T>(id, List.copyOf(entries))));
        entries.clear();
    }

    private static <T, A> void sendSync(class_3244 handler, class_8710.class_9154<PolymerGenericListPayload<A>> packetId, Iterable<T> iterable, boolean bypassPolymerCheck, Function<T, A> writableFunction) {
        PolymerServerProtocol.sendSync(handler, packetId, iterable, bypassPolymerCheck, (T a, class_3244 b, int c) -> writableFunction.apply(a));
    }

    private static <T, A> void sendSync(class_3244 handler, class_8710.class_9154<PolymerGenericListPayload<A>> packetId, Iterable<T> iterable, boolean bypassPolymerCheck, BufferWritableCreator<T, A> writableFunction) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)packetId.comp_2242());
        class_2378 registry = null;
        if (iterable instanceof RegistryExtension && !bypassPolymerCheck) {
            iterable = ((RegistryExtension)((Object)iterable)).polymer$getEntries();
            registry = (class_2378)iterable;
        }
        if (version != -1) {
            ArrayList<A> entries = new ArrayList<A>();
            PacketContext.NotNullWithPlayer ctx = PacketContext.create((class_3244)handler);
            for (T entry : iterable) {
                if (bypassPolymerCheck && !PolymerSyncedObject.canSynchronizeToPolymerClient(registry, entry, ctx)) continue;
                A val = writableFunction.serialize(entry, handler, version);
                if (val != null) {
                    entries.add(val);
                }
                if (entries.size() <= 100) continue;
                PolymerServerProtocol.sendSync(handler, packetId, entries);
            }
            if (!entries.isEmpty()) {
                PolymerServerProtocol.sendSync(handler, packetId, entries);
            }
        }
    }

    public static void sendDebugValidateStatesPackets(class_3244 handler) {
        int version = PolymerServerNetworking.getSupportedVersion((class_3244)handler, (class_2960)S2CPackets.DEBUG_VALIDATE_STATES);
        if (version != -1) {
            PolymerServerProtocol.sendSync(handler, S2CPackets.DEBUG_VALIDATE_STATES_ID, class_2248.field_10651, true, DebugBlockStateEntry::of);
        }
    }

    public static interface BufferWritableCreator<T, A> {
        public A serialize(T var1, class_3244 var2, int var3);
    }
}

