/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl;

import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.InternalServerRegistry;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.compat.ServerTranslationUtils;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerIdList;
import eu.pb4.polymer.core.impl.interfaces.PolymerPlayNetworkHandlerExtension;
import eu.pb4.polymer.core.impl.other.ImplPolymerRegistry;
import eu.pb4.polymer.core.impl.other.PolymerTooltipType;
import eu.pb4.polymer.rsm.impl.RegistrySyncExtension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class PolymerImplUtils {
    public static final ThreadLocal<class_3902> IS_RELOADING_WORLD = new ThreadLocal();
    public static final ThreadLocal<class_3902> IGNORE_PLAY_SOUND_EXCLUSION = new ThreadLocal();
    public static final Collection<class_2680> POLYMER_STATES = ((PolymerIdList)class_2248.field_10651).polymer$getPolymerEntries();
    public static final class_7225.class_7874 FALLBACK_LOOKUP = class_5455.method_40302((class_2378)class_7923.field_41167);

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"polymer", (String)path);
    }

    public static String getAsString(class_2680 state) {
        StringBuilder builder = new StringBuilder();
        builder.append(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (!state.method_11656().isEmpty()) {
            builder.append("[");
            Iterator iterator = state.method_11656().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                builder.append(((class_2769)entry.getKey()).method_11899());
                builder.append("=");
                builder.append(((class_2769)entry.getKey()).method_11901((Comparable)entry.getValue()));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Nullable
    public static String dumpRegistry() {
        BufferedWriter writer = null;
        try {
            Object entry;
            Object entry2;
            String path = "./polymer-dump-" + FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ROOT) + ".txt";
            BufferedWriter finalWriter = writer = new BufferedWriter(new FileWriter(path));
            Consumer<String> msg = str -> {
                try {
                    finalWriter.write((String)str);
                    finalWriter.newLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            msg.accept("== Vanilla Registries");
            for (Object reg : class_7923.field_41167) {
                Object regEx;
                msg.accept("");
                msg.accept("== Registry: " + class_7923.field_41167.method_10221(reg).toString());
                msg.accept("");
                if (reg instanceof RegistrySyncExtension) {
                    regEx = (RegistrySyncExtension)reg;
                    msg.accept("= Status: " + regEx.polymer_registry_sync$getStatus().name());
                    msg.accept("");
                }
                if (CompatStatus.FABRIC_SYNC) {
                    msg.accept("= Synced: " + RegistryAttributeHolder.get((class_2378)reg).hasAttribute(RegistryAttribute.SYNCED));
                    msg.accept("");
                }
                regEx = reg.iterator();
                while (regEx.hasNext()) {
                    entry2 = regEx.next();
                    msg.accept(reg.method_10206(entry2) + " | " + reg.method_10221(entry2).toString() + " | Polymer? " + PolymerUtils.isServerOnly(reg, entry2));
                }
            }
            msg.accept("");
            msg.accept("== BlockStates");
            msg.accept("");
            msg.accept("= Polymer Starts: " + PolymerImplUtils.getBlockStateOffset());
            msg.accept("");
            msg.accept("= All States: " + class_2248.field_10651.method_10204());
            PolymerIdList pl = (PolymerIdList)class_2248.field_10651;
            msg.accept("= Polymer States: " + pl.polymer$getPolymerEntries().size());
            msg.accept("= Server Bits: " + class_3532.method_15342((int)class_2248.field_10651.method_10204()));
            msg.accept("= Vanilla Bits: " + pl.polymer$getVanillaBitCount());
            msg.accept("= NonPolymer Bits: " + pl.polymer$getNonPolymerBitCount());
            msg.accept("");
            for (class_2680 state : class_2248.field_10651) {
                msg.accept(class_2248.field_10651.method_10206((Object)state) + " | " + PolymerImplUtils.getAsString(state) + " | Polymer? " + String.valueOf(PolymerSyncedObject.getSyncedObject(class_7923.field_41175, state.method_26204())));
            }
            msg.accept("");
            msg.accept("== Server/Local Polymer Item Groups");
            msg.accept("");
            Iterator<Object> iterator = InternalServerRegistry.ITEM_GROUPS.iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                msg.accept(InternalServerRegistry.ITEM_GROUPS.getId((class_1761)entry).toString());
            }
            msg.accept("");
            msg.accept("== Polymer Registries");
            msg.accept("");
            if (PolymerImpl.IS_CLIENT) {
                for (ImplPolymerRegistry reg2 : (Collection)InternalClientRegistry.REGISTRIES) {
                    msg.accept("");
                    msg.accept("== Registry: " + reg2.getName() + " (Client)");
                    msg.accept("");
                    Iterator<Object> iterator2 = reg2.iterator();
                    while (iterator2.hasNext()) {
                        entry2 = iterator2.next();
                        msg.accept(reg2.method_10206(entry2) + " | " + String.valueOf(reg2.getId(entry2)));
                    }
                    msg.accept("");
                    msg.accept("=== Tags:");
                    msg.accept("");
                    for (class_2960 tag : reg2.getTags()) {
                        msg.accept(String.valueOf(tag) + " | :");
                        for (Object entry3 : reg2.getTag(tag)) {
                            msg.accept("  " + String.valueOf(reg2.getId(entry3)));
                        }
                    }
                }
                msg.accept("");
                msg.accept("== Registry: BlockState (Client)");
                msg.accept("");
                iterator = InternalClientRegistry.BLOCK_STATES.iterator();
                while (iterator.hasNext()) {
                    entry = (ClientPolymerBlock.State)iterator.next();
                    msg.accept(InternalClientRegistry.BLOCK_STATES.method_10206(entry) + " | " + String.valueOf(((ClientPolymerBlock.State)entry).block().identifier()));
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static int getBlockStateOffset() {
        return ((PolymerIdList)class_2248.field_10651).polymer$getOffset();
    }

    public static void setStateIdsLock(boolean value) {
        ((PolymerIdList)class_2248.field_10651).polymer$setReorderLock(value);
    }

    public static boolean getStateIdsLock(boolean value) {
        return ((PolymerIdList)class_2248.field_10651).polymer$getReorderLock();
    }

    public static boolean shouldSkipStateInitialization(Stream<StackWalker.StackFrame> s) {
        if (CompatStatus.QUILT_REGISTRY) {
            Optional<StackWalker.StackFrame> x = s.skip(3L).findFirst();
            return x.isPresent() && x.get().getMethodName().contains("lambda$onInit");
        }
        return false;
    }

    public static boolean shouldLogStateRebuild(StackTraceElement[] trace) {
        return trace.length <= 4 || !trace[4].getClassName().startsWith("org.quiltmc.qsl.registry.impl.sync");
    }

    public static boolean removeFromItemGroup(class_1799 stack) {
        if (stack == null) {
            return true;
        }
        return PolymerImplUtils.isPolymerControlled(stack);
    }

    public static boolean isPolymerControlled(class_1799 stack) {
        return PolymerItemUtils.isPolymerServerItem(stack) || PolymerItemUtils.getServerIdentifier(stack) != null;
    }

    public static PolymerTooltipType getTooltipContext(class_3222 player) {
        PolymerPlayNetworkHandlerExtension h;
        class_3244 class_32442;
        return player != null && (class_32442 = player.field_13987) instanceof PolymerPlayNetworkHandlerExtension && (h = (PolymerPlayNetworkHandlerExtension)class_32442).polymer$advancedTooltip() ? PolymerTooltipType.ADVANCED : PolymerTooltipType.BASIC;
    }

    public static boolean isServerSideSyncableEntry(class_2378 reg, Object obj) {
        return PolymerUtils.isServerOnly(reg, obj) || PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC && PolyMcUtils.isServerSide(reg, obj);
    }

    public static class_1799 convertStack(class_1799 representation, class_3222 player) {
        return PolymerImplUtils.convertStack(representation, player, PolymerUtils.getTooltipType(player));
    }

    public static class_1799 convertStack(class_1799 representation, class_3222 player, class_1836 context) {
        return ServerTranslationUtils.parseFor(player.field_13987, PolyMcUtils.toVanilla(PolymerItemUtils.getPolymerItemStack(representation, context, (PacketContext)PacketContext.create((class_3222)player)), player));
    }

    public static void callItemGroupEvents(class_2960 id, class_1761 itemGroup, List<class_1799> parentTabStacks, List<class_1799> searchTabStacks, class_1761.class_8128 context) {
        block3: {
            if (CompatStatus.FABRIC_ITEM_GROUP) {
                try {
                    FabricItemGroupEntries fabricCollector = new FabricItemGroupEntries(context, parentTabStacks, searchTabStacks);
                    ((ItemGroupEvents.ModifyEntries)ItemGroupEvents.modifyEntriesEvent((class_5321)class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)id)).invoker()).modifyEntries(fabricCollector);
                    ((ItemGroupEvents.ModifyEntriesAll)ItemGroupEvents.MODIFY_ENTRIES_ALL.invoker()).modifyEntries(itemGroup, fabricCollector);
                }
                catch (Throwable e) {
                    if (!PolymerImpl.LOG_MORE_ERRORS) break block3;
                    PolymerImpl.LOGGER.warn("Failed to execute Fabric Item Group event!", e);
                }
            }
        }
    }
}

