/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.impl.ServerConfig;
import eu.pb4.polymer.core.impl.client.ClientConfig;
import org.slf4j.Logger;

public final class PolymerImpl {
    public static final Logger LOGGER = CommonImpl.LOGGER;
    public static final boolean DEV_ENV = CommonImpl.DEV_ENV;
    public static final boolean IS_CLIENT = CommonImpl.IS_CLIENT;
    public static final boolean DISPLAY_DEBUG_INFO_CLIENT;
    public static final boolean ADD_NON_POLYMER_CREATIVE_TABS;
    public static final boolean RESEND_BLOCKS_AROUND_CLICK;
    public static final boolean LOG_SYNC_TIME;
    public static final boolean LOG_SYNC_TIME_CLIENT;
    public static final boolean LOG_BLOCKSTATE_REBUILDS;
    public static final boolean LOG_INVALID_SERVER_IDS_CLIENT;
    public static final boolean CHANGING_QOL_CLIENT;
    public static final boolean USE_UNSAFE_ITEMS_CLIENT;
    public static final boolean SYNC_MODDED_ENTRIES_POLYMC;
    public static final boolean USE_FULL_REI_COMPAT_CLIENT = true;
    public static final boolean LOG_MORE_ERRORS;
    public static final int LIGHT_UPDATE_TICK_DELAY;
    public static final boolean FIX_STONECUTER;
    public static final int SPLIT_RECIPE_PACKETS;
    public static final boolean OVERRIDE_POLYMC_MINING;

    static {
        ServerConfig serverConfig = (ServerConfig)CommonImpl.loadConfig((String)"server", ServerConfig.class);
        ADD_NON_POLYMER_CREATIVE_TABS = serverConfig.displayNonPolymerCreativeTabs;
        RESEND_BLOCKS_AROUND_CLICK = serverConfig.sendBlocksAroundClicked;
        LOG_SYNC_TIME = CommonImpl.DEVELOPER_MODE || serverConfig.logHandshakeTime;
        LOG_BLOCKSTATE_REBUILDS = serverConfig.logBlockStateRebuilds;
        LOG_MORE_ERRORS = CommonImpl.LOG_MORE_ERRORS;
        SYNC_MODDED_ENTRIES_POLYMC = serverConfig.polyMcSyncModdedEntries && CompatStatus.POLYMC;
        LIGHT_UPDATE_TICK_DELAY = serverConfig.lightUpdateTickDelay;
        OVERRIDE_POLYMC_MINING = serverConfig.overridePolyMcMining;
        SPLIT_RECIPE_PACKETS = serverConfig.splitRecipeBookPacket;
        FIX_STONECUTER = serverConfig.stonecutterFix;
        if (IS_CLIENT) {
            ClientConfig clientConfig = (ClientConfig)CommonImpl.loadConfig((String)"client", ClientConfig.class);
            DISPLAY_DEBUG_INFO_CLIENT = clientConfig.displayF3Info;
            LOG_INVALID_SERVER_IDS_CLIENT = clientConfig.logInvalidServerEntryIds;
            CHANGING_QOL_CLIENT = !clientConfig.disableNonVisualQualityOfLifeChanges;
            USE_UNSAFE_ITEMS_CLIENT = clientConfig.experimentalModdedContainerSupport;
            LOG_SYNC_TIME_CLIENT = clientConfig.logHandshakeTime;
        } else {
            DISPLAY_DEBUG_INFO_CLIENT = false;
            LOG_INVALID_SERVER_IDS_CLIENT = false;
            CHANGING_QOL_CLIENT = false;
            USE_UNSAFE_ITEMS_CLIENT = false;
            LOG_SYNC_TIME_CLIENT = false;
        }
    }
}

