/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.BytecodeFormat;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.RegisteredFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;
import org.squiddev.cobalt.lib.StringFormat;
import org.squiddev.cobalt.lib.StringMatch;
import org.squiddev.cobalt.lib.StringPacker;

public final class StringLib {
    static final int L_ESC = 37;
    private static final int MAX_LEN = Integer.MAX_VALUE;

    private StringLib() {
    }

    public static void add(LuaState state) throws LuaError {
        LuaTable t = RegisteredFunction.bind(new RegisteredFunction[]{RegisteredFunction.of("len", StringLib::len), RegisteredFunction.of("lower", StringLib::lower), RegisteredFunction.of("reverse", StringLib::reverse), RegisteredFunction.of("upper", StringLib::upper), RegisteredFunction.of("packsize", StringLib::packsize), RegisteredFunction.of("dump", StringLib::dump), RegisteredFunction.ofV("byte", StringLib::byte$), RegisteredFunction.ofV("char", StringLib::char$), RegisteredFunction.ofV("find", StringMatch::find), RegisteredFunction.ofV("gmatch", StringMatch::gmatch), RegisteredFunction.ofV("match", StringMatch::match), RegisteredFunction.ofV("rep", StringLib::rep), RegisteredFunction.ofV("sub", StringLib::sub), RegisteredFunction.ofV("pack", (s, args) -> StringPacker.pack(args)), RegisteredFunction.ofV("unpack", (s, args) -> StringPacker.unpack(args)), RegisteredFunction.ofFactory("gsub", GSub::new), RegisteredFunction.ofFactory("format", Format::new)});
        t.rawset("gfind", t.rawget("gmatch"));
        LibFunction.setGlobalLibrary(state, "string", t);
        state.stringMetatable = ValueFactory.tableOf(Constants.INDEX, t);
    }

    private static LuaValue len(LuaState state, LuaValue arg) throws LuaError {
        return ValueFactory.valueOf(arg.checkLuaString().length());
    }

    private static LuaValue lower(LuaState state, LuaValue arg) throws LuaError {
        byte b;
        int i;
        LuaString string = arg.checkLuaString();
        int len = string.length();
        for (i = 0; i < len && ((b = string.byteAt(i)) < 65 || b > 90); ++i) {
        }
        if (i == len) {
            return string;
        }
        byte[] value = new byte[len];
        string.copyTo(value, 0);
        while (i < value.length) {
            byte c = value[i];
            if (c >= 65 && c <= 90) {
                value[i] = (byte)(c | 0x20);
            }
            ++i;
        }
        return ValueFactory.valueOf(value);
    }

    private static LuaValue reverse(LuaState state, LuaValue arg) throws LuaError {
        LuaString s = arg.checkLuaString();
        int n = s.length();
        byte[] b = new byte[n];
        int i = 0;
        int j = n - 1;
        while (i < n) {
            b[j] = s.byteAt(i);
            ++i;
            --j;
        }
        return LuaString.valueOf(b);
    }

    private static LuaValue upper(LuaState state, LuaValue arg) throws LuaError {
        byte b;
        int i;
        LuaString string = arg.checkLuaString();
        int len = string.length();
        for (i = 0; i < len && ((b = string.byteAt(i)) < 97 || b > 122); ++i) {
        }
        if (i == len) {
            return string;
        }
        byte[] value = new byte[string.length()];
        string.copyTo(value, 0);
        for (i = 0; i < value.length; ++i) {
            byte c = value[i];
            if (c < 97 || c > 122) continue;
            value[i] = (byte)(c & 0xFFFFFFDF);
        }
        return ValueFactory.valueOf(value);
    }

    private static LuaValue packsize(LuaState state, LuaValue arg) throws LuaError {
        return LuaInteger.valueOf(StringPacker.packsize(arg.checkLuaString()));
    }

    private static Varargs byte$(LuaState state, Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int l = s.length();
        int posi = StringLib.posRelative(args.arg(2).optInteger(1), l);
        int pose = StringLib.posRelative(args.arg(3).optInteger(posi), l);
        if (posi <= 0) {
            posi = 1;
        }
        if (pose > l) {
            pose = l;
        }
        if (posi == pose) {
            return ValueFactory.valueOf(s.charAt(posi - 1));
        }
        if (posi > pose) {
            return Constants.NONE;
        }
        int n = pose - posi + 1;
        if (posi + n <= pose) {
            throw new LuaError("string slice too long");
        }
        LuaValue[] v = new LuaValue[n];
        for (int i = 0; i < n; ++i) {
            v[i] = ValueFactory.valueOf(s.charAt(posi + i - 1));
        }
        return ValueFactory.varargsOf(v);
    }

    private static LuaValue char$(LuaState state, Varargs args) throws LuaError {
        int n = args.count();
        byte[] bytes = new byte[n];
        int i = 0;
        int a = 1;
        while (i < n) {
            int c = args.arg(a).checkInteger();
            if (c < 0 || c >= 256) {
                throw ErrorFactory.argError(a, "invalid value");
            }
            bytes[i] = (byte)c;
            ++i;
            ++a;
        }
        return LuaString.valueOf(bytes);
    }

    static LuaValue dump(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        LuaClosure closure;
        BytecodeFormat bytecode;
        boolean strip;
        block5: {
            block4: {
                LuaFunction f = arg1.checkFunction();
                strip = arg2.optBoolean(false);
                bytecode = state.getBytecodeFormat();
                if (!(f instanceof LuaClosure)) break block4;
                closure = (LuaClosure)f;
                if (bytecode != null) break block5;
            }
            throw new LuaError("unable to dump given function");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            bytecode.writeFunction(baos, closure.getPrototype(), strip);
        }
        catch (IOException e) {
            throw new LuaError(e.getMessage());
        }
        return LuaString.valueOf(baos.toByteArray());
    }

    private static Varargs rep(LuaState state, Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int len = s.length();
        int n = args.arg(2).checkInteger();
        LuaString sep = args.arg(3).optLuaString(Constants.EMPTYSTRING);
        if (n <= 0) {
            return Constants.EMPTYSTRING;
        }
        if (n == 1) {
            return s;
        }
        long newLen = (long)len * (long)n + (long)sep.length() * (long)(n - 1);
        if (newLen > Integer.MAX_VALUE) {
            throw new LuaError("resulting string too large");
        }
        byte[] bytes = new byte[(int)newLen];
        s.copyTo(bytes, 0);
        sep.copyTo(bytes, len);
        int sliceLength = len + sep.length();
        long endIndex = newLen - (long)len;
        for (long i = (long)sliceLength; i != 0L && i < endIndex; i <<= 1) {
            System.arraycopy(bytes, 0, bytes, (int)i, (int)(Math.min(i << 1, endIndex) - i));
        }
        s.copyTo(bytes, (int)endIndex);
        return LuaString.valueOf(bytes);
    }

    private static Varargs sub(LuaState state, Varargs args) throws LuaError {
        LuaString s = args.arg(1).checkLuaString();
        int l = s.length();
        int start = StringLib.posRelative(args.arg(2).checkInteger(), l);
        int defval = -1;
        int end = StringLib.posRelative(args.arg(3).optInteger(defval), l);
        if (start < 1) {
            start = 1;
        }
        if (end > l) {
            end = l;
        }
        if (start <= end) {
            return s.substringOfEnd(start - 1, end);
        }
        return Constants.EMPTYSTRING;
    }

    static int posRelative(int pos, int len) {
        if (pos >= 0) {
            return pos;
        }
        if (-pos > len) {
            return 0;
        }
        return len + pos + 1;
    }

    public static boolean isWhitespace(byte b) {
        return StringMatch.isWhitespace(b);
    }

    private static final class Format
    extends ResumableVarArgFunction<StringFormat.FormatState> {
        private Format() {
        }

        @Override
        public Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            LuaString src = args.arg(1).checkLuaString();
            StringFormat.FormatState format = new StringFormat.FormatState(src, new Buffer(src.length()), args);
            di.state = format;
            return StringFormat.format(state, format);
        }

        @Override
        public Varargs resume(LuaState state, StringFormat.FormatState formatState, Varargs value) throws LuaError, UnwindThrowable {
            LuaString s = OperationHelper.checkToString(value.first());
            formatState.current.format(formatState.buffer, s);
            return StringFormat.format(state, formatState);
        }
    }

    private static final class GSub
    extends ResumableVarArgFunction<StringMatch.GSubState> {
        private GSub() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            LuaString src = args.arg(1).checkLuaString();
            LuaString p = args.arg(2).checkLuaString();
            LuaValue replace = args.arg(3);
            int maxS = args.arg(4).optInteger(src.length() + 1);
            StringMatch.GSubState gsub = new StringMatch.GSubState(state, src, p, replace, maxS);
            di.state = gsub;
            return StringMatch.gsubRun(state, gsub, null);
        }

        @Override
        public Varargs resume(LuaState state, StringMatch.GSubState subState, Varargs value) throws LuaError, UnwindThrowable {
            return StringMatch.gsubRun(state, subState, value.first());
        }
    }
}

