/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import cc.tweaked.cobalt.internal.LegacyEnv;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHelpers;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.debug.FunctionDebugHook;
import org.squiddev.cobalt.debug.ObjectName;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.LocalVariable;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.RegisteredFunction;

public final class DebugLib {
    private static final LuaString MAIN = ValueFactory.valueOf("main");
    private static final LuaString LUA = ValueFactory.valueOf("Lua");
    private static final LuaString C = ValueFactory.valueOf("C");
    private static final LuaString C_SHORT_SOURCE = ValueFactory.valueOf("[C]");
    private static final LuaString C_SOURCE = ValueFactory.valueOf("=[C]");
    public static final LuaString QMARK = ValueFactory.valueOf("?");
    private static final LuaString EXTERNAL_HOOK = ValueFactory.valueOf("external hook");
    private static final LuaString FUNC = ValueFactory.valueOf("func");
    private static final LuaString NUPS = ValueFactory.valueOf("nups");
    private static final LuaString NAME = ValueFactory.valueOf("name");
    private static final LuaString NAMEWHAT = ValueFactory.valueOf("namewhat");
    private static final LuaString WHAT = ValueFactory.valueOf("what");
    private static final LuaString SOURCE = ValueFactory.valueOf("source");
    private static final LuaString SHORT_SRC = ValueFactory.valueOf("short_src");
    private static final LuaString LINEDEFINED = ValueFactory.valueOf("linedefined");
    private static final LuaString LASTLINEDEFINED = ValueFactory.valueOf("lastlinedefined");
    private static final LuaString CURRENTLINE = ValueFactory.valueOf("currentline");
    private static final LuaString CURRENTCOLUMN = ValueFactory.valueOf("currentcolumn");
    private static final LuaString ACTIVELINES = ValueFactory.valueOf("activelines");
    private static final LuaString NPARAMS = ValueFactory.valueOf("nparams");
    private static final LuaString ISVARARG = ValueFactory.valueOf("isvararg");
    private static final LuaString ISTAILCALL = ValueFactory.valueOf("istailcall");

    private DebugLib() {
    }

    public static void add(LuaState state) throws LuaError {
        LibFunction.setGlobalLibrary(state, "debug", RegisteredFunction.bind(new RegisteredFunction[]{RegisteredFunction.ofV("debug", DebugLib::debug), RegisteredFunction.ofV("getfenv", DebugLib::getfenv), RegisteredFunction.ofV("gethook", DebugLib::gethook), RegisteredFunction.ofV("getinfo", DebugLib::getinfo), RegisteredFunction.ofV("getlocal", DebugLib::getlocal), RegisteredFunction.ofV("getmetatable", DebugLib::getmetatable), RegisteredFunction.ofV("getregistry", DebugLib::getregistry), RegisteredFunction.ofV("getupvalue", DebugLib::getupvalue), RegisteredFunction.ofV("setfenv", DebugLib::setfenv), RegisteredFunction.ofV("sethook", DebugLib::sethook), RegisteredFunction.ofV("setlocal", DebugLib::setlocal), RegisteredFunction.ofV("setmetatable", DebugLib::setmetatable), RegisteredFunction.ofV("setupvalue", DebugLib::varargs), RegisteredFunction.ofV("traceback", DebugLib::traceback), RegisteredFunction.ofV("upvalueid", DebugLib::upvalueId), RegisteredFunction.ofV("upvaluejoin", DebugLib::upvalueJoin)}));
    }

    private static Varargs debug(LuaState state, Varargs args) {
        return Constants.NONE;
    }

    private static Varargs gethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        DebugState ds = thread.getDebugState();
        LuaValue hook = ds.getHook() == null ? Constants.NIL : (ds.getHook() instanceof FunctionDebugHook ? ((FunctionDebugHook)ds.getHook()).function() : EXTERNAL_HOOK);
        return ValueFactory.varargsOf(hook, (LuaValue)ValueFactory.valueOf((ds.hasCallHook() ? "c" : "") + (ds.hasReturnHook() ? "r" : "") + (ds.hasLineHook() ? "l" : "")), (Varargs)ValueFactory.valueOf(ds.hookCount));
    }

    private static Varargs sethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        int i1 = a++;
        LuaFunction func = args.arg(i1).optFunction(null);
        int i3 = a++;
        LuaString str = args.arg(i3).optLuaString(Constants.EMPTYSTRING);
        int i2 = a++;
        int count = args.arg(i2).optInteger(0);
        boolean call = false;
        boolean line = false;
        boolean rtrn = false;
        if (func != null) {
            block5: for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case 99: {
                        call = true;
                        continue block5;
                    }
                    case 108: {
                        line = true;
                        continue block5;
                    }
                    case 114: {
                        rtrn = true;
                    }
                }
            }
        } else {
            count = 0;
        }
        thread.getDebugState().setHook(func == null ? null : new FunctionDebugHook(func), call, line, rtrn, count);
        return Constants.NONE;
    }

    private static Varargs getfenv(LuaState state, Varargs args) {
        LuaValue object = args.first();
        LuaTable env = LegacyEnv.getEnv(object);
        return env != null ? env : Constants.NIL;
    }

    private static Varargs setfenv(LuaState state, Varargs args) throws LuaError {
        LuaTable env;
        LuaValue object = args.first();
        if (!LegacyEnv.setEnv(object, env = args.arg(2).checkTable())) {
            throw new LuaError("'setfenv' cannot change environment of given object");
        }
        return object;
    }

    private static Varargs getinfo(LuaState state, Varargs args) throws LuaError {
        LuaClosure c;
        LuaFunction function;
        DebugFrame callInfo;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        LuaValue funcArg = args.arg(arg);
        String what = args.arg(arg + 1).optString("flnStu");
        DebugState ds = thread.getDebugState();
        if (funcArg.isNumber()) {
            callInfo = ds.getFrame(funcArg.checkInteger());
            if (callInfo == null) {
                return Constants.NIL;
            }
            function = callInfo.func;
        } else {
            callInfo = null;
            function = funcArg.checkFunction();
        }
        LuaTable info = new LuaTable();
        LuaClosure closure = function instanceof LuaClosure ? (c = (LuaClosure)function) : null;
        int j = what.length();
        block9: for (int i = 0; i < j; ++i) {
            switch (what.charAt(i)) {
                case 'S': {
                    Prototype p;
                    if (closure != null) {
                        p = closure.getPrototype();
                        info.rawset(WHAT, (LuaValue)(p.lineDefined == 0 ? MAIN : LUA));
                        info.rawset(SOURCE, (LuaValue)p.source);
                        info.rawset(SHORT_SRC, (LuaValue)p.shortSource());
                        info.rawset(LINEDEFINED, (LuaValue)ValueFactory.valueOf(p.lineDefined));
                        info.rawset(LASTLINEDEFINED, (LuaValue)ValueFactory.valueOf(p.lastLineDefined));
                        continue block9;
                    }
                    info.rawset(WHAT, (LuaValue)C);
                    info.rawset(SOURCE, (LuaValue)C_SOURCE);
                    info.rawset(SHORT_SRC, (LuaValue)C_SHORT_SOURCE);
                    info.rawset(LINEDEFINED, (LuaValue)Constants.MINUSONE);
                    info.rawset(LASTLINEDEFINED, (LuaValue)Constants.MINUSONE);
                    continue block9;
                }
                case 'l': {
                    if (callInfo == null || closure == null) {
                        info.rawset(CURRENTLINE, (LuaValue)ValueFactory.valueOf(-1));
                        continue block9;
                    }
                    Prototype p = closure.getPrototype();
                    int line = p.lineAt(callInfo.pc);
                    int column = p.columnAt(callInfo.pc);
                    info.rawset(CURRENTLINE, (LuaValue)ValueFactory.valueOf(line));
                    if (column <= 0) continue block9;
                    info.rawset(CURRENTCOLUMN, (LuaValue)ValueFactory.valueOf(column));
                    continue block9;
                }
                case 'u': {
                    info.rawset(NUPS, (LuaValue)ValueFactory.valueOf(closure != null ? closure.getPrototype().upvalues() : 0));
                    info.rawset(NPARAMS, (LuaValue)ValueFactory.valueOf(closure != null ? closure.getPrototype().parameters : 0));
                    info.rawset(ISVARARG, (LuaValue)ValueFactory.valueOf(closure == null || closure.getPrototype().isVarArg));
                    continue block9;
                }
                case 'n': {
                    ObjectName kind = callInfo != null ? callInfo.getFuncKind() : null;
                    info.rawset(NAME, kind != null ? kind.name() : Constants.NIL);
                    info.rawset(NAMEWHAT, (LuaValue)(kind != null ? kind.what() : Constants.EMPTYSTRING));
                    continue block9;
                }
                case 'f': {
                    info.rawset(FUNC, function == null ? Constants.NIL : function);
                    continue block9;
                }
                case 'L': {
                    if (closure == null) continue block9;
                    LuaTable lines = new LuaTable();
                    info.rawset(ACTIVELINES, (LuaValue)lines);
                    int[] lineInfo = closure.getPrototype().lineInfo;
                    if (lineInfo == null) continue block9;
                    for (int line : lineInfo) {
                        lines.rawset(line, (LuaValue)Constants.TRUE);
                    }
                    continue block9;
                }
                case 't': {
                    info.rawset(ISTAILCALL, (LuaValue)ValueFactory.valueOf(callInfo != null && (callInfo.flags & 4) != 0));
                    continue block9;
                }
                default: {
                    throw ErrorFactory.argError(arg + 1, "invalid option");
                }
            }
        }
        return info;
    }

    private static Varargs getlocal(LuaState state, Varargs args) throws LuaError {
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int local = args.arg(arg + 1).checkInteger();
        LuaValue luaValue = args.arg(arg);
        if (luaValue instanceof LuaFunction) {
            LuaFunction function = (LuaFunction)luaValue;
            if (!(function instanceof LuaClosure)) {
                return Constants.NIL;
            }
            LuaClosure closure = (LuaClosure)function;
            Prototype proto = closure.getPrototype();
            LocalVariable[] variables = proto.locals;
            return variables != null && local > 0 && local <= variables.length && local <= proto.parameters ? variables[local - 1].name : Constants.NIL;
        }
        int level = args.arg(arg).checkInteger();
        DebugFrame di = thread.getDebugState().getFrame(level);
        if (di == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        LuaValue value = di.stack[local - 1];
        return ValueFactory.varargsOf((LuaValue)name, (Varargs)value);
    }

    private static Varargs setlocal(LuaState state, Varargs args) throws LuaError {
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int level = args.arg(arg).checkInteger();
        int local = args.arg(arg + 1).checkInteger();
        LuaValue value = args.arg(arg + 2);
        DebugFrame di = thread.getDebugState().getFrame(level);
        if (di == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        di.stack[local - 1] = value;
        return name;
    }

    private static Varargs getmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        LuaTable mt = object.getMetatable(state);
        return mt != null ? mt : Constants.NIL;
    }

    private static Varargs setmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        try {
            LuaTable mt = args.arg(2).optTable(null);
            switch (object.type()) {
                case 0: {
                    state.nilMetatable = mt;
                    break;
                }
                case 3: {
                    state.numberMetatable = mt;
                    break;
                }
                case 1: {
                    state.booleanMetatable = mt;
                    break;
                }
                case 4: {
                    state.stringMetatable = mt;
                    break;
                }
                case 6: {
                    state.functionMetatable = mt;
                    break;
                }
                case 8: {
                    state.threadMetatable = mt;
                    break;
                }
                default: {
                    object.setMetatable(state, mt);
                }
            }
            return Constants.TRUE;
        }
        catch (LuaError e) {
            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)ValueFactory.valueOf(e.toString()));
        }
    }

    private static Varargs getregistry(LuaState state, Varargs args) {
        return state.registry().get();
    }

    private static LuaString findupvalue(LuaClosure c, int up) {
        Prototype p = c.getPrototype();
        return p.getUpvalueName(up - 1);
    }

    private static Varargs getupvalue(LuaState state, Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            return ValueFactory.varargsOf((LuaValue)name, (Varargs)c.getUpvalue(up - 1).getValue());
        }
        return Constants.NIL;
    }

    private static Varargs varargs(LuaState state, Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        LuaValue value = args.arg(3);
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            c.getUpvalue(up - 1).setValue(value);
            return name;
        }
        return Constants.NIL;
    }

    private static Varargs traceback(LuaState state, Varargs args) throws LuaError {
        LuaValue messageValue;
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        if ((messageValue = args.arg(a++)) != Constants.NIL && !messageValue.isString()) {
            return messageValue;
        }
        LuaString message = messageValue.optLuaString(null);
        int level = args.arg(a).optInteger(thread == state.getCurrentThread() ? 1 : 0);
        Buffer sb = new Buffer();
        if (message != null) {
            sb.append(message).append('\n');
        }
        return ValueFactory.valueOf(DebugHelpers.traceback(sb, thread, level).toString());
    }

    private static LuaClosure getClosureForUpvalue(Varargs args, int offset, int upvalue) throws LuaError {
        LuaFunction function = args.arg(offset).checkFunction();
        if (function instanceof LuaClosure) {
            LuaClosure closure = (LuaClosure)function;
            if (upvalue >= 0 && upvalue < closure.getPrototype().upvalues()) {
                return closure;
            }
        }
        throw ErrorFactory.argError(offset, "invalid upvalue index");
    }

    private static Varargs upvalueId(LuaState state, Varargs args) throws LuaError {
        int upvalue = args.arg(2).checkInteger() - 1;
        LuaClosure closure = DebugLib.getClosureForUpvalue(args, 1, upvalue);
        return new LuaUserdata(closure.getUpvalue(upvalue));
    }

    private static Varargs upvalueJoin(LuaState state, Varargs args) throws LuaError {
        int upvalue1 = args.arg(2).checkInteger() - 1;
        LuaClosure closure1 = DebugLib.getClosureForUpvalue(args, 1, upvalue1);
        int upvalue2 = args.arg(4).checkInteger() - 1;
        LuaClosure closure2 = DebugLib.getClosureForUpvalue(args, 3, upvalue2);
        closure1.setUpvalue(upvalue1, closure2.getUpvalue(upvalue2));
        return Constants.NONE;
    }
}

