/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.RegisteredFunction;

public final class Bit32Lib {
    private Bit32Lib() {
    }

    public static void add(LuaState state) throws LuaError {
        LibFunction.setGlobalLibrary(state, "bit32", RegisteredFunction.bind(new RegisteredFunction[]{RegisteredFunction.ofV("band", Bit32Lib::band), RegisteredFunction.of("bnot", Bit32Lib::bnot), RegisteredFunction.ofV("bor", Bit32Lib::bor), RegisteredFunction.ofV("btest", Bit32Lib::btest), RegisteredFunction.ofV("bxor", Bit32Lib::bxor), RegisteredFunction.of("extract", Bit32Lib::extract), RegisteredFunction.ofV("replace", Bit32Lib::replace), RegisteredFunction.of("arshift", Bit32Lib::arshift), RegisteredFunction.of("lrotate", Bit32Lib::lrotate), RegisteredFunction.of("lshift", Bit32Lib::lshift), RegisteredFunction.of("rrotate", Bit32Lib::rrotate), RegisteredFunction.of("rshift", Bit32Lib::rshift)}));
    }

    private static LuaValue band(LuaState state, Varargs args) throws LuaError {
        int result = -1;
        for (int i = 1; i <= args.count(); ++i) {
            result &= args.arg(i).checkInteger();
        }
        return Bit32Lib.bitsToValue(result);
    }

    private static LuaValue bnot(LuaState state, LuaValue arg) throws LuaError {
        return Bit32Lib.bitsToValue(~arg.checkInteger());
    }

    private static LuaValue bor(LuaState state, Varargs args) throws LuaError {
        int result = 0;
        for (int i = 1; i <= args.count(); ++i) {
            result |= args.arg(i).checkInteger();
        }
        return Bit32Lib.bitsToValue(result);
    }

    private static LuaValue btest(LuaState state, Varargs args) throws LuaError {
        int bits = -1;
        for (int i = 1; i <= args.count(); ++i) {
            bits &= args.arg(i).checkInteger();
        }
        return ValueFactory.valueOf(bits != 0);
    }

    private static LuaValue bxor(LuaState state, Varargs args) throws LuaError {
        int result = 0;
        for (int i = 1; i <= args.count(); ++i) {
            result ^= args.arg(i).checkInteger();
        }
        return Bit32Lib.bitsToValue(result);
    }

    private static LuaValue extract(LuaState state, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError {
        int field = arg2.checkInteger();
        int width = arg3.optInteger(1);
        if (field < 0) {
            throw ErrorFactory.argError(2, "field cannot be negative");
        }
        if (width <= 0) {
            throw ErrorFactory.argError(3, "width must be postive");
        }
        if (field + width > 32) {
            throw new LuaError("trying to access non-existent bits");
        }
        return Bit32Lib.bitsToValue(arg1.checkInteger() >>> field & -1 >>> 32 - width);
    }

    private static LuaValue replace(LuaState state, Varargs args) throws LuaError {
        int n = args.arg(1).checkInteger();
        int v = args.arg(2).checkInteger();
        int field = args.arg(3).checkInteger();
        int width = args.arg(4).optInteger(1);
        if (field < 0) {
            throw ErrorFactory.argError(3, "field cannot be negative");
        }
        if (width <= 0) {
            throw ErrorFactory.argError(4, "width must be postive");
        }
        if (field + width > 32) {
            throw new LuaError("trying to access non-existent bits");
        }
        int mask = -1 >>> 32 - width << field;
        n = n & ~mask | v << field & mask;
        return Bit32Lib.bitsToValue(n);
    }

    private static LuaValue arshift(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        int x = arg1.checkInteger();
        int disp = arg2.checkInteger();
        return Bit32Lib.bitsToValue(disp >= 0 ? x >> disp : x << -disp);
    }

    private static LuaValue lrotate(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        return Bit32Lib.bitsToValue(Bit32Lib.rotate(arg1.checkInteger(), arg2.checkInteger()));
    }

    private static LuaValue rrotate(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        return Bit32Lib.bitsToValue(Bit32Lib.rotate(arg1.checkInteger(), -arg2.checkInteger()));
    }

    private static LuaValue lshift(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        return Bit32Lib.bitsToValue(Bit32Lib.shift(arg1.checkInteger(), arg2.checkInteger()));
    }

    private static LuaValue rshift(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        return Bit32Lib.bitsToValue(Bit32Lib.shift(arg1.checkInteger(), -arg2.checkInteger()));
    }

    private static int rotate(int x, int disp) {
        if (disp < 0) {
            disp = -disp & 0x1F;
            return x >>> disp | x << 32 - disp;
        }
        return x << (disp &= 0x1F) | x >>> 32 - disp;
    }

    private static int shift(int x, int disp) {
        if (disp >= 32 || disp <= -32) {
            return 0;
        }
        if (disp >= 0) {
            return x << disp;
        }
        return x >>> -disp;
    }

    private static LuaValue bitsToValue(int x) {
        return x < 0 ? ValueFactory.valueOf((long)x & 0xFFFFFFFFL) : LuaInteger.valueOf(x);
    }
}

