/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.Resumable;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.debug.Upvalue;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaInterpreter;

public final class LuaInterpretedFunction
extends LuaClosure
implements Resumable<Object> {
    private static final Upvalue[] NO_UPVALUES = new Upvalue[0];
    final Prototype p;
    public final Upvalue[] upvalues;

    public LuaInterpretedFunction(Prototype p) {
        this.p = p;
        this.upvalues = p.upvalues() > 0 ? new Upvalue[p.upvalues()] : NO_UPVALUES;
    }

    public void nilUpvalues() {
        int nups = this.p.upvalues();
        if (nups > 0) {
            Upvalue[] upvalues = this.upvalues;
            for (int i = 0; i < nups; ++i) {
                upvalues[i] = new Upvalue(Constants.NIL);
            }
        }
    }

    @Override
    public Upvalue getUpvalue(int i) {
        return this.upvalues[i];
    }

    @Override
    public void setUpvalue(int i, Upvalue upvalue) {
        this.upvalues[i] = upvalue;
    }

    @Override
    public Prototype getPrototype() {
        return this.p;
    }

    @Override
    public Varargs resume(LuaState state, Object object, Varargs value) throws LuaError, UnwindThrowable {
        DebugState ds = DebugState.get(state);
        DebugFrame frame = ds.getStackUnsafe();
        if ((frame.flags & 0x3C40) != 0) {
            assert (ds.inhook || (frame.flags & 0x40) != 0);
            if ((frame.flags & 0x40) != 0) {
                frame.flags &= 0xFFFFFFBF;
            } else if ((frame.flags & 0x3000) == 0) {
                throw new AssertionError((Object)"Incorrect debug flag set");
            }
        } else {
            LuaInterpreter.resume(state, frame, this, value);
        }
        return LuaInterpreter.execute(state, frame, this);
    }
}

