/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.debug.ObjectName;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.lib.DebugLib;

public final class DebugHelpers {
    private static final LuaString GLOBAL = ValueFactory.valueOf("global");
    private static final LuaString LOCAL = ValueFactory.valueOf("local");
    private static final LuaString METHOD = ValueFactory.valueOf("method");
    private static final LuaString UPVALUE = ValueFactory.valueOf("upvalue");
    private static final LuaString FIELD = ValueFactory.valueOf("field");
    private static final LuaString QUESTION = ValueFactory.valueOf("?");
    private static final LuaString HOOK = ValueFactory.valueOf("hook");
    private static final LuaString METAMETHOD = ValueFactory.valueOf("metamethod");
    private static final LuaString FUNCTION = ValueFactory.valueOf("function");
    private static final LuaString C = ValueFactory.valueOf("[C]");
    private static final int LEVELS1 = 10;
    private static final int LEVELS2 = 11;

    private DebugHelpers() {
    }

    public static String traceback(LuaThread thread, int level) {
        return DebugHelpers.traceback(new Buffer(), thread, level).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static Buffer traceback(Buffer sb, LuaThread thread, int level) {
        sb.append("stack traceback:");
        state = thread.getDebugState();
        v0 = n1 = state.top - level > 21 ? 10 : -1;
        while ((di = state.getFrame(level++)) != null) {
            block8: {
                block7: {
                    if (n1-- == 0) {
                        sb.append("\n\t...");
                        level = state.top - 11 + 1;
                        continue;
                    }
                    sb.append("\n\t");
                    sb.append(di.closure == null ? DebugHelpers.C : di.closure.getPrototype().shortSource());
                    sb.append(':');
                    if (di.currentLine() > 0) {
                        sb.append(Integer.toString(di.currentLine())).append(":");
                    }
                    sb.append(" in ");
                    kind = di.getFuncKind();
                    if (kind == null) break block7;
                    sb.append(kind.what() == DebugHelpers.GLOBAL ? DebugHelpers.FUNCTION : kind.what()).append(" '").append(kind.name()).append('\'');
                    break block8;
                }
                var8_8 = di.func;
                if (!(var8_8 instanceof LuaClosure)) ** GOTO lbl-1000
                closure = (LuaClosure)var8_8;
                if (closure.getPrototype().lineDefined == 0) {
                    sb.append("main chunk");
                } else if (di.func instanceof LuaClosure) {
                    sb.append("function <").append(di.func.debugName()).append(">");
                } else {
                    sb.append('?');
                }
            }
            if ((di.flags & 4) == 0) continue;
            sb.append("\n\t(...tail calls...)");
        }
        return sb;
    }

    public static String fileLine(LuaThread thread) {
        DebugState ds = thread.getDebugState();
        int n = ds.top;
        for (int i = 0; i <= n; ++i) {
            DebugFrame di = ds.getFrame(i);
            if (di == null || di.closure == null) continue;
            return di.sourceLine();
        }
        return DebugHelpers.fileLine(thread, 0);
    }

    public static @Nullable String fileLine(LuaThread thread, int level) {
        DebugState ds = thread.getDebugState();
        DebugFrame di = ds.getFrame(level);
        return di != null ? di.sourceLine() : null;
    }

    private static ObjectName fromMetamethod(String name) {
        return new ObjectName(ValueFactory.valueOf("__" + name), METAMETHOD);
    }

    public static @Nullable ObjectName getFuncName(DebugFrame di, int stackpos) {
        if (di.closure == null) {
            return null;
        }
        if ((di.flags & 0x3C00) != 0) {
            return new ObjectName(QUESTION, HOOK);
        }
        Prototype p = di.closure.getPrototype();
        int pc = di.pc;
        int i = p.code[pc];
        return switch (Lua.GET_OPCODE(i)) {
            case 29, 30 -> DebugHelpers.getObjectName(di, Lua.GETARG_A(i));
            case 7, 12 -> DebugHelpers.fromMetamethod("index");
            case 10 -> DebugHelpers.fromMetamethod("newindex");
            case 13 -> DebugHelpers.fromMetamethod("add");
            case 14 -> DebugHelpers.fromMetamethod("sub");
            case 15 -> DebugHelpers.fromMetamethod("mul");
            case 16 -> DebugHelpers.fromMetamethod("div");
            case 18 -> DebugHelpers.fromMetamethod("pow");
            case 17 -> DebugHelpers.fromMetamethod("mod");
            case 19 -> DebugHelpers.fromMetamethod("unm");
            case 24 -> DebugHelpers.fromMetamethod("eq");
            case 26 -> DebugHelpers.fromMetamethod("le");
            case 25 -> DebugHelpers.fromMetamethod("lt");
            case 21 -> DebugHelpers.fromMetamethod("len");
            case 22 -> DebugHelpers.fromMetamethod("concat");
            default -> null;
        };
    }

    public static @Nullable ObjectName getObjectName(DebugFrame di, int stackpos) {
        int pc;
        if (di.closure == null) {
            return null;
        }
        if ((di.flags & 0x3C00) != 0) {
            return new ObjectName(QUESTION, HOOK);
        }
        Prototype p = di.closure.getPrototype();
        LuaString name = p.getLocalName(stackpos + 1, pc = di.pc);
        if (name != null) {
            return new ObjectName(name, LOCAL);
        }
        if ((pc = DebugHelpers.findSetReg(p, pc, stackpos)) == -1) {
            return null;
        }
        int i = p.code[pc];
        switch (Lua.GET_OPCODE(i)) {
            case 0: {
                int a = Lua.GETARG_A(i);
                int b = Lua.GETARG_B(i);
                if (b >= a) break;
                return DebugHelpers.getObjectName(di, b);
            }
            case 6: 
            case 7: {
                int t = Lua.GETARG_B(i);
                LuaString table = Lua.GET_OPCODE(i) == 6 ? p.getUpvalueName(t) : p.getLocalName(t + 1, pc);
                int c = Lua.GETARG_C(i);
                return new ObjectName(DebugHelpers.constantName(p, c), Objects.equals(table, Constants.ENV) ? GLOBAL : FIELD);
            }
            case 5: {
                int u = Lua.GETARG_B(i);
                return new ObjectName(Objects.requireNonNullElse(p.getUpvalueName(u), DebugLib.QMARK), UPVALUE);
            }
            case 12: {
                int k = Lua.GETARG_C(i);
                return new ObjectName(DebugHelpers.constantName(p, k), METHOD);
            }
        }
        return null;
    }

    private static int filterPc(int pc, int jumpTarget) {
        return pc < jumpTarget ? -1 : pc;
    }

    private static int findSetReg(Prototype pt, int lastpc, int reg) {
        int setreg = -1;
        int jumpTarget = 0;
        block6: for (int pc = 0; pc < lastpc; ++pc) {
            int i = pt.code[pc];
            int op = Lua.GET_OPCODE(i);
            int a = Lua.GETARG_A(i);
            switch (op) {
                case 4: {
                    int b = Lua.GETARG_B(i);
                    if (a > reg || reg > a + b) continue block6;
                    setreg = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 34: {
                    if (a < a + 2) continue block6;
                    setreg = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 29: 
                case 30: {
                    if (reg < a) continue block6;
                    setreg = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 23: {
                    int dest = pc + 1 + Lua.GETARG_sBx(i);
                    if (pc >= dest || dest > lastpc || dest <= jumpTarget) continue block6;
                    jumpTarget = dest;
                    continue block6;
                }
                default: {
                    if (!Lua.testAMode(op) || reg != a) continue block6;
                    setreg = DebugHelpers.filterPc(pc, jumpTarget);
                }
            }
        }
        return setreg;
    }

    private static LuaString constantName(Prototype proto, int index) {
        if (Lua.ISK(index) && proto.constants[Lua.INDEXK(index)].isString()) {
            return (LuaString)proto.constants[Lua.INDEXK(index)].toLuaString();
        }
        return DebugLib.QMARK;
    }
}

