/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import cc.tweaked.cobalt.internal.string.CharProperties;
import cc.tweaked.cobalt.internal.string.NumberParser;
import cc.tweaked.cobalt.internal.unwind.AutoUnwind;
import cc.tweaked.cobalt.internal.unwind.Pause;
import cc.tweaked.cobalt.internal.unwind.UnwindState;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L0O4;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O0;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O4;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.InputReader;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.lib.Utf8Lib;

@AutoUnwind
final class Lex {
    private static final int EOZ = -1;
    static final int MAX_INT = 0x7FFFFFFD;
    private static final int POSITION_SHIFT = 32;
    private static final long POSITION_MASK = 0xFFFFFFFFL;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_GOTO = 266;
    static final int TK_IF = 267;
    static final int TK_IN = 268;
    static final int TK_LOCAL = 269;
    static final int TK_NIL = 270;
    static final int TK_NOT = 271;
    static final int TK_OR = 272;
    static final int TK_REPEAT = 273;
    static final int TK_RETURN = 274;
    static final int TK_THEN = 275;
    static final int TK_TRUE = 276;
    static final int TK_UNTIL = 277;
    static final int TK_WHILE = 278;
    static final int TK_CONCAT = 279;
    static final int TK_DOTS = 280;
    static final int TK_EQ = 281;
    static final int TK_GE = 282;
    static final int TK_LE = 283;
    static final int TK_NE = 284;
    static final int TK_DBCOLON = 285;
    static final int TK_EOS = 286;
    static final int TK_NUMBER = 287;
    static final int TK_NAME = 288;
    static final int TK_STRING = 289;
    private static final String[] tokenNames = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "goto", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "::", "<eof>", "<number>", "<name>", "<string>"};
    private static final int FIRST_RESERVED = 257;
    private static final int NUM_RESERVED = 22;
    private static final Map<ByteBuffer, Integer> RESERVED;
    private int current;
    final LuaString source;
    final LuaString shortSource;
    private final InputReader z;
    private int lineNumber = 1;
    private int columnNumber = 1;
    private long lastPosition = 0x100000001L;
    private final HashMap<ByteBuffer, LuaString> strings = new HashMap();
    final Token token = new Token();
    private final Token lookahead = new Token();
    private byte[] buff = new byte[32];
    private int bufferSize;

    static boolean isReserved(LuaString name) {
        return RESERVED.containsKey(name.toBuffer());
    }

    Lex(LuaString source, LuaString shortSource, InputReader z, int current) {
        this.source = source;
        this.shortSource = shortSource;
        this.z = z;
        this.current = current;
        this.token.token = 0;
        this.lookahead.token = 286;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void next(Object object) throws CompileException, LuaError, Pause {
        int n;
        if (object == null) {
            v0 = this;
            n = this.z.read();
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            v0 = this;
            ((UnwindState)object).resumeArgs = null;
            n = this.z.resume(((UnwindState)object).resumeArgs);
        }
        v0.current = n;
        ++this.columnNumber;
        return;
        catch (UnwindThrowable unwindThrowable) {
            object = UnwindState.getOrCreate(object);
            ((UnwindState)object).state = 0;
            throw new Pause(unwindThrowable, (UnwindState)object);
        }
    }

    private void save(int toSave) {
        if (this.buff == null || this.bufferSize + 1 > this.buff.length) {
            this.buff = LuaC.realloc(this.buff, this.bufferSize * 2 + 1);
        }
        this.buff[this.bufferSize++] = (byte)toSave;
    }

    private boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAndNext(Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            this.save(this.current);
            lex = this;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.next(object2);
            return;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    static String token2str(int token) {
        if (token < 257) {
            if (token >= 32 && token <= 126) {
                return "'" + (char)token + "'";
            }
            return "<\\" + token + ">'";
        }
        String name = tokenNames[token - 257];
        return token < 286 ? "'" + name + "'" : name;
    }

    Buffer createErrorMessage(int line) {
        return new Buffer().append(this.shortSource).append(":").append(Integer.toString(line)).append(": ");
    }

    CompileException lexError(String msg, int token) {
        Buffer buffer = this.createErrorMessage(this.lineNumber).append(msg);
        if (token != 0) {
            buffer.append(" near ");
            switch (token) {
                case 287: 
                case 288: 
                case 289: {
                    buffer.append("'").append(this.buff, 0, this.bufferSize).append("'");
                    break;
                }
                default: {
                    buffer.append(Lex.token2str(token));
                }
            }
        }
        return new CompileException(buffer.toString());
    }

    CompileException syntaxError(String msg) {
        return this.lexError(msg, this.token.token());
    }

    LuaString newString(byte[] bytes, int offset, int len) {
        LuaString interned = this.strings.get(ByteBuffer.wrap(bytes, offset, len));
        if (interned == null) {
            byte[] slice = new byte[len];
            System.arraycopy(bytes, offset, slice, 0, len);
            interned = LuaString.valueOf(slice);
            this.strings.put(ByteBuffer.wrap(slice), interned);
        }
        return interned;
    }

    LuaString newString(String value) {
        byte[] contents = new byte[value.length()];
        LuaString.encode(value, contents, 0);
        ByteBuffer buffer = ByteBuffer.wrap(contents);
        LuaString interned = this.strings.get(buffer);
        if (interned == null) {
            interned = LuaString.valueOf(contents);
            this.strings.put(buffer, interned);
        }
        return interned;
    }

    /*
     * Unable to fully structure code
     */
    private void inclineNumber(Object var1_1) throws CompileException, LuaError, Pause {
        block12: {
            if (var1_1 != null) break block12;
            old = this.current;
            if (!Lex.$assertionsDisabled && !this.currIsNewline()) {
                throw new AssertionError();
            }
            v0 = this;
            v1 = null;
lbl7:
            // 2 sources

            while (true) {
                v0.next(v1);
                if (!this.currIsNewline() || this.current == old) ** GOTO lbl16
                v2 = this;
                v3 = null;
lbl13:
                // 2 sources

                while (true) {
                    v2.next(v3);
lbl16:
                    // 2 sources

                    if (++this.lineNumber >= 0x7FFFFFFD) {
                        throw this.lexError("chunk has too many lines", 0);
                    }
                    this.columnNumber = 1;
                    return;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O0)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                v0 = this;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        v2 = this;
        v3 = var1_1.child;
        ** while (true)
        catch (Pause v4) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v4.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            throw v4;
        }
        catch (Pause v5) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            throw v5;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkNext(char c, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            void character;
            if (this.current != character) {
                return false;
            }
            lex = this;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.next(object2);
            return true;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkNext(char c, char c2, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            void c22;
            void c1;
            if (this.current != c1 && this.current != c22) {
                return false;
            }
            lex = this;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            lex = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            lex.saveAndNext(object2);
            return true;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LuaNumber readNumeral(Object var1_1) throws CompileException, LuaError, Pause {
        block28: {
            block29: {
                block27: {
                    block24: {
                        block25: {
                            block26: {
                                if (var1_1 != null) break block26;
                                if (!Lex.$assertionsDisabled && !CharProperties.isDigit(this.current)) {
                                    throw new AssertionError();
                                }
                                first = this.current;
                                v0 = this;
                                v1 = null;
lbl7:
                                // 2 sources

                                while (true) {
                                    block23: {
                                        v0.saveAndNext(v1);
                                        exp1 = 69;
                                        exp2 = 101;
                                        if (first != 48) break block23;
                                        v2 = this;
                                        v3 = 'x';
                                        v4 = 'X';
                                        v5 = null;
                                        ** GOTO lbl42
                                    }
lbl19:
                                    // 4 sources

                                    while (true) {
                                        v6 = this;
                                        v7 = exp1;
                                        v8 = exp2;
                                        v9 = null;
lbl24:
                                        // 2 sources

                                        while (true) {
                                            if (!v6.checkNext((char)v7, (char)v8, v9)) break block24;
                                            v10 = this;
                                            v11 = 43;
                                            v12 = 45;
                                            v13 = null;
                                            break block25;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            var1_1 = (UnwindState$L4O0)var1_1;
                            switch (var1_1.state) {
                                default: {
                                    throw new IllegalStateException("Resuming into unknown state");
                                }
                                case 0: {
                                    var2_2 = (int)var1_1.l0;
                                    v0 = this;
                                    v1 = var1_1.child;
                                    ** continue;
                                }
lbl42:
                                // 2 sources

                                while (true) {
                                    try {}
                                    catch (Pause v14) {
                                        var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                        v14.pushState((UnwindState)var1_1);
                                        var1_1.state = 1;
                                        var1_1.l0 = var3_3;
                                        var1_1.l1 = var4_4;
                                        throw v14;
                                    }
                                    ** GOTO lbl58
                                    break;
                                }
                                catch (Pause v15) {
                                    var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                    v15.pushState((UnwindState)var1_1);
                                    var1_1.state = 0;
                                    var1_1.l0 = var2_2;
                                    throw v15;
                                }
lbl58:
                                // 1 sources

                                if (!v2.checkNext(v3, v4, v5)) ** GOTO lbl19
                                exp1 = 80;
                                exp2 = 112;
                                ** GOTO lbl19
                                case 1: {
                                    var3_3 = (int)var1_1.l0;
                                    var4_4 = (int)var1_1.l1;
                                    v2 = this;
                                    v3 = '\u0000';
                                    v4 = '\u0000';
                                    v5 = var1_1.child;
                                    ** continue;
                                }
                                case 2: {
                                    var3_3 = (int)var1_1.l0;
                                    var4_4 = (int)var1_1.l1;
                                    v6 = this;
                                    v7 = 0;
                                    v8 = 0;
                                    v9 = var1_1.child;
                                    ** continue;
                                }
                                case 3: {
                                    var3_3 = (int)var1_1.l0;
                                    var4_4 = (int)var1_1.l1;
                                    v10 = this;
                                    v11 = 0;
                                    v12 = 0;
                                    v13 = var1_1.child;
                                    break;
                                }
                                case 4: {
                                    var3_3 = (int)var1_1.l0;
                                    var4_4 = (int)var1_1.l1;
                                    v16 = this;
                                    v17 = var1_1.child;
                                    break block27;
                                }
                            }
                        }
                        try {
                            v10.checkNext((char)v11, (char)v12, v13);
                        }
                        catch (Pause v18) {
                            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                            v18.pushState((UnwindState)var1_1);
                            var1_1.state = 3;
                            var1_1.l0 = var3_3;
                            var1_1.l1 = var4_4;
                            throw v18;
                        }
                    }
                    if (!CharProperties.isHex(this.current) && this.current != 46) break block28;
                    v16 = this;
                    v17 = null;
                }
                try {}
                catch (Pause v19) {
                    var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                    v19.pushState((UnwindState)var1_1);
                    var1_1.state = 4;
                    var1_1.l0 = var3_3;
                    var1_1.l1 = var4_4;
                    throw v19;
                }
                break block29;
                catch (Pause v20) {
                    var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                    v20.pushState((UnwindState)var1_1);
                    var1_1.state = 2;
                    var1_1.l0 = var3_3;
                    var1_1.l1 = var4_4;
                    throw v20;
                }
            }
            v16.saveAndNext(v17);
            ** while (true)
        }
        value = NumberParser.parse(this.buff, 0, this.bufferSize, 10);
        if (Double.isNaN(value)) {
            throw this.lexError("malformed number", 287);
        }
        return ValueFactory.valueOf(value);
    }

    /*
     * Unable to fully structure code
     */
    private int skipSep(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            count = 0;
            s = this.current;
            if (!Lex.$assertionsDisabled && s != 91 && s != 93) {
                throw new AssertionError();
            }
            v0 = this;
            v1 = null;
lbl8:
            // 2 sources

            while (true) {
                v0.saveAndNext(v1);
                block9: while (this.current == 61) {
                    v2 = this;
                    v3 = null;
lbl14:
                    // 2 sources

                    while (true) {
                        v2.saveAndNext(v3);
                        ++count;
                        continue block9;
                        break;
                    }
                }
                if (this.current == s) {
                    return count + 2;
                }
                return count == 0 ? 1 : 0;
            }
        }
        var1_1 = (UnwindState$L4O0)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (int)var1_1.l1;
                v0 = this;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        var2_2 = (int)var1_1.l0;
        var3_3 = (int)var1_1.l1;
        v2 = this;
        v3 = var1_1.child;
        ** while (true)
        catch (Pause v4) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v4.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            var1_1.l1 = var3_3;
            throw v4;
        }
        catch (Pause v5) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.l1 = var3_3;
            throw v5;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readLongString(Token var1_1, int var2_2, Object var3_3) throws CompileException, LuaError, Pause {
        block47: {
            if (var3_3 != null) break block47;
            line = this.lineNumber;
            v0 = this;
            v1 = null;
lbl5:
            // 2 sources

            while (true) {
                v0.saveAndNext(v1);
                if (!this.currIsNewline()) ** GOTO lbl14
                v2 = this;
                v3 = null;
lbl11:
                // 2 sources

                while (true) {
                    v2.inclineNumber(v3);
lbl14:
                    // 2 sources

                    block37: while (true) {
                        switch (this.current) {
                            case -1: {
                                throw this.lexError("unfinished long " + (token != null ? "string" : "comment") + " (started at line " + line + ")", 286);
                            }
                            case 91: {
                                v4 = this;
                                v5 = null;
lbl21:
                                // 2 sources

                                while (true) {
                                    if (v4.skipSep(v5) != sep) continue block37;
                                    v6 = this;
                                    v7 = null;
lbl26:
                                    // 2 sources

                                    while (true) {
                                        v6.saveAndNext(v7);
                                        if (sep != 2) continue block37;
                                        throw this.lexError("nesting of [[...]] is deprecated", 91);
                                    }
                                    break;
                                }
                            }
                            case 93: {
                                v8 = this;
                                v9 = null;
lbl34:
                                // 2 sources

                                while (true) {
                                    if (v8.skipSep(v9) != sep) continue block37;
                                    v10 = this;
                                    v11 = null;
lbl39:
                                    // 2 sources

                                    while (true) {
                                        v10.saveAndNext(v11);
                                        if (token != null) {
                                            token.value = this.newString(this.buff, (int)sep, this.bufferSize - 2 * sep);
                                        }
                                        return;
                                        break;
                                    }
                                    break;
                                }
                            }
                            case 10: 
                            case 13: {
                                this.save(10);
                                v12 = this;
                                v13 = null;
lbl49:
                                // 2 sources

                                while (true) {
                                    v12.inclineNumber(v13);
                                    if (token != null) continue block37;
                                    this.bufferSize = 0;
                                    continue block37;
                                    break;
                                }
                            }
                        }
                        if (token != null) {
                            v14 = this;
                            v15 = null;
lbl58:
                            // 2 sources

                            while (true) {
                                v14.saveAndNext(v15);
                                continue block37;
                                break;
                            }
                        }
                        v16 = this;
                        v17 = null;
lbl64:
                        // 2 sources

                        while (true) {
                            v16.next(v17);
                            continue block37;
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            }
        }
        var3_3 = (UnwindState$L4O4)var3_3;
        switch (var3_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v0 = this;
                v1 = var3_3.child;
                ** continue;
            }
            case 1: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v2 = this;
                v3 = var3_3.child;
                ** continue;
            }
            case 2: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v4 = this;
                v5 = var3_3.child;
                ** continue;
            }
            case 3: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v6 = this;
                v7 = var3_3.child;
                ** continue;
            }
            case 4: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v8 = this;
                v9 = var3_3.child;
                ** continue;
            }
            case 5: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v10 = this;
                v11 = var3_3.child;
                ** continue;
            }
            case 6: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v12 = this;
                v13 = var3_3.child;
                ** continue;
            }
            case 7: {
                var1_1 = (Token)var3_3.o0;
                var2_2 = (int)var3_3.l0;
                var4_4 = (int)var3_3.l1;
                v14 = this;
                v15 = var3_3.child;
                ** continue;
            }
            case 8: 
        }
        var1_1 = (Token)var3_3.o0;
        var2_2 = (int)var3_3.l0;
        var4_4 = (int)var3_3.l1;
        v16 = this;
        v17 = var3_3.child;
        ** while (true)
        catch (Pause v18) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v18.pushState((UnwindState)var3_3);
            var3_3.state = 0;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v18;
        }
        catch (Pause v19) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v19.pushState((UnwindState)var3_3);
            var3_3.state = 1;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v19;
        }
        catch (Pause v20) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v20.pushState((UnwindState)var3_3);
            var3_3.state = 2;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v20;
        }
        catch (Pause v21) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v21.pushState((UnwindState)var3_3);
            var3_3.state = 3;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v21;
        }
        catch (Pause v22) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v22.pushState((UnwindState)var3_3);
            var3_3.state = 4;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v22;
        }
        catch (Pause v23) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v23.pushState((UnwindState)var3_3);
            var3_3.state = 5;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v23;
        }
        catch (Pause v24) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v24.pushState((UnwindState)var3_3);
            var3_3.state = 6;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v24;
        }
        catch (Pause v25) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v25.pushState((UnwindState)var3_3);
            var3_3.state = 7;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v25;
        }
        catch (Pause v26) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            v26.pushState((UnwindState)var3_3);
            var3_3.state = 8;
            var3_3.o0 = var1_1;
            var3_3.l0 = var2_2;
            var3_3.l1 = var4_4;
            throw v26;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompileException escapeError(String string, Object object) throws CompileException, LuaError, Pause {
        void message;
        block4: {
            Object object2;
            Lex lex;
            block5: {
                block3: {
                    if (object != null) break block3;
                    if (this.current == -1) break block4;
                    lex = this;
                    object2 = null;
                    break block5;
                }
                object = (UnwindState$L0O4)object;
                if (((UnwindState$L0O4)object).state != 0) {
                    throw new IllegalStateException("Resuming into unknown state");
                }
                string = (String)((UnwindState$L0O4)object).o0;
                lex = this;
                object2 = ((UnwindState)object).child;
            }
            try {
                lex.saveAndNext(object2);
            }
            catch (Pause pause) {
                object = UnwindState$L0O4.getOrCreate(object);
                pause.pushState((UnwindState)object);
                ((UnwindState)object).state = 0;
                ((UnwindState$L0O4)object).o0 = string;
                throw pause;
            }
        }
        return this.lexError((String)message, 289);
    }

    /*
     * Unable to fully structure code
     */
    private int readHex(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            v0 = this;
            v1 = null;
lbl4:
            // 2 sources

            while (true) {
                v0.saveAndNext(v1);
                if (!CharProperties.isHex(this.current)) {
                    v2 = this;
                    v3 = "hexadecimal digit expected";
                    v4 = null;
lbl11:
                    // 2 sources

                    while (true) {
                        throw v2.escapeError(v3, v4);
                        break;
                    }
                }
                return CharProperties.hexValue(this.current);
            }
        }
        var1_1 = (UnwindState)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                v0 = this;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        v2 = this;
        v3 = null;
        v4 = var1_1.child;
        ** while (true)
        catch (Pause v5) {
            var1_1 = UnwindState.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            throw v5;
        }
        catch (Pause v6) {
            var1_1 = UnwindState.getOrCreate(var1_1);
            v6.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            throw v6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int readHexEsc(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            v0 = this;
            v1 = null;
lbl4:
            // 2 sources

            while (true) {
                left = v0.readHex(v1);
                v2 = this;
                v3 = null;
lbl9:
                // 2 sources

                while (true) {
                    right = v2.readHex(v3);
                    this.bufferSize -= 2;
                    return left << 4 | right;
                    break;
                }
                break;
            }
        }
        var1_1 = (UnwindState$L4O0)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                v0 = this;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        var2_2 = (int)var1_1.l0;
        v2 = this;
        v3 = var1_1.child;
        ** while (true)
        catch (Pause v4) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v4.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            throw v4;
        }
        catch (Pause v5) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            throw v5;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readUtf8Esc(Object var1_1) throws CompileException, LuaError, Pause {
        block38: {
            block34: {
                block36: {
                    block33: {
                        block37: {
                            block32: {
                                block35: {
                                    block30: {
                                        block31: {
                                            if (var1_1 != null) break block31;
                                            v0 = this;
                                            v1 = null;
lbl4:
                                            // 2 sources

                                            while (true) {
                                                v0.saveAndNext(v1);
                                                if (this.current == 123) ** GOTO lbl24
                                                v2 = this;
                                                v3 = "missing '{'";
                                                v4 = null;
                                                ** GOTO lbl21
                                                break;
                                            }
                                        }
                                        var1_1 = (UnwindState$L4O0)var1_1;
                                        switch (var1_1.state) {
                                            default: {
                                                throw new IllegalStateException("Resuming into unknown state");
                                            }
                                            case 0: {
                                                v0 = this;
                                                v1 = var1_1.child;
                                                ** continue;
                                            }
lbl21:
                                            // 2 sources

                                            while (true) {
                                                throw v2.escapeError(v3, v4);
                                                break;
                                            }
lbl24:
                                            // 1 sources

                                            i = 4;
                                            v5 = this;
                                            v6 = null;
lbl27:
                                            // 2 sources

                                            while (true) {
                                                try {}
                                                catch (Pause v7) {
                                                    var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                                    v7.pushState((UnwindState)var1_1);
                                                    var1_1.state = 2;
                                                    var1_1.l0 = var2_2;
                                                    throw v7;
                                                }
                                                ** GOTO lbl46
                                                break;
                                            }
                                            catch (Pause v8) {
                                                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                                v8.pushState((UnwindState)var1_1);
                                                var1_1.state = 1;
                                                throw v8;
                                            }
                                            catch (Pause v9) {
                                                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                                v9.pushState((UnwindState)var1_1);
                                                var1_1.state = 0;
                                                throw v9;
                                            }
lbl46:
                                            // 1 sources

                                            codepoint = v5.readHex(v6);
lbl47:
                                            // 2 sources

                                            while (true) {
                                                v10 = this;
                                                v11 = null;
lbl50:
                                                // 2 sources

                                                while (true) {
                                                    v10.saveAndNext(v11);
                                                    break block30;
                                                    break;
                                                }
                                                break;
                                            }
                                            case 1: {
                                                v2 = this;
                                                v3 = null;
                                                v4 = var1_1.child;
                                                ** continue;
                                            }
                                            case 2: {
                                                var2_2 = (int)var1_1.l0;
                                                v5 = this;
                                                v6 = var1_1.child;
                                                ** continue;
                                            }
                                            case 3: {
                                                var2_2 = (int)var1_1.l0;
                                                var3_3 = var1_1.l1;
                                                v10 = this;
                                                v11 = var1_1.child;
                                                ** continue;
                                            }
                                            case 4: {
                                                var2_2 = (int)var1_1.l0;
                                                var3_3 = var1_1.l1;
                                                v12 = this;
                                                v13 = null;
                                                v14 = var1_1.child;
                                                break block32;
                                            }
                                            case 5: {
                                                var2_2 = (int)var1_1.l0;
                                                var3_3 = var1_1.l1;
                                                v15 = this;
                                                v16 = null;
                                                v17 = var1_1.child;
                                                break block33;
                                            }
                                            case 6: {
                                                var2_2 = (int)var1_1.l0;
                                                var3_3 = var1_1.l1;
                                                v18 = this;
                                                v19 = var1_1.child;
                                                break;
                                            }
                                        }
                                        break block34;
                                    }
                                    if (CharProperties.isHex(this.current)) break block35;
                                    if (this.current == 125) break block36;
                                    break block37;
                                }
                                ++i;
                                ** while ((codepoint = codepoint << 4 | (long)CharProperties.hexValue((int)this.current)) <= 0x10FFFFL)
lbl98:
                                // 1 sources

                                v12 = this;
                                v13 = "UTF-8 value too large";
                                v14 = null;
                            }
                            try {
                                throw v12.escapeError(v13, v14);
                            }
                            catch (Pause v20) {
                                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                                v20.pushState((UnwindState)var1_1);
                                var1_1.state = 4;
                                var1_1.l0 = var2_2;
                                var1_1.l1 = var3_3;
                                throw v20;
                            }
                        }
                        v15 = this;
                        v16 = "missing '}'";
                        v17 = null;
                    }
                    try {
                        throw v15.escapeError(v16, v17);
                    }
                    catch (Pause v21) {
                        var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                        v21.pushState((UnwindState)var1_1);
                        var1_1.state = 5;
                        var1_1.l0 = var2_2;
                        var1_1.l1 = var3_3;
                        throw v21;
                    }
                }
                v18 = this;
                v19 = null;
            }
            try {}
            catch (Pause v22) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v22.pushState((UnwindState)var1_1);
                var1_1.state = 6;
                var1_1.l0 = var2_2;
                var1_1.l1 = var3_3;
                throw v22;
            }
            break block38;
            catch (Pause v23) {
                var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
                v23.pushState((UnwindState)var1_1);
                var1_1.state = 3;
                var1_1.l0 = var2_2;
                var1_1.l1 = var3_3;
                throw v23;
            }
        }
        v18.next(v19);
        this.bufferSize -= i;
        if (codepoint < 128L) {
            this.save((int)codepoint);
            return;
        }
        buffer = new byte[8];
        j = Utf8Lib.buildCharacter(buffer, codepoint);
        while (j > 0) {
            this.save(buffer[8 - j]);
            --j;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int readDecEsc(Object var1_1) throws CompileException, LuaError, Pause {
        if (var1_1 == null) {
            result = 0;
            block8: for (i = 0; i < 3 && CharProperties.isDigit(this.current); ++i) {
                result = 10 * result + this.current - 48;
                v0 = this;
                v1 = null;
lbl7:
                // 2 sources

                while (true) {
                    v0.saveAndNext(v1);
                    continue block8;
                    break;
                }
            }
            if (result > 255) {
                v2 = this;
                v3 = "escape sequence too large";
                v4 = null;
lbl15:
                // 2 sources

                while (true) {
                    throw v2.escapeError(v3, v4);
                    break;
                }
            }
            this.bufferSize -= i;
            return result;
        }
        var1_1 = (UnwindState$L4O0)var1_1;
        switch (var1_1.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var2_2 = (int)var1_1.l0;
                var3_3 = (int)var1_1.l1;
                v0 = this;
                v1 = var1_1.child;
                ** continue;
            }
            case 1: 
        }
        var2_2 = (int)var1_1.l0;
        var3_3 = (int)var1_1.l1;
        v2 = this;
        v3 = null;
        v4 = var1_1.child;
        ** while (true)
        catch (Pause v5) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v5.pushState((UnwindState)var1_1);
            var1_1.state = 0;
            var1_1.l0 = var2_2;
            var1_1.l1 = var3_3;
            throw v5;
        }
        catch (Pause v6) {
            var1_1 = UnwindState$L4O0.getOrCreate(var1_1);
            v6.pushState((UnwindState)var1_1);
            var1_1.state = 1;
            var1_1.l0 = var2_2;
            var1_1.l1 = var3_3;
            throw v6;
        }
    }

    /*
     * Exception decompiling
     */
    private LuaString readString(int var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[CASE], 94[UNCONDITIONALDOLOOP]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveEscape(int n, Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Lex lex;
        if (object == null) {
            lex = this;
            object2 = null;
        } else {
            object = (UnwindState$L4O0)object;
            if (((UnwindState$L4O0)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            n = (int)((UnwindState$L4O0)object).l0;
            lex = this;
            object2 = ((UnwindState)object).child;
        }
        try {
            void character;
            lex.next(object2);
            --this.bufferSize;
            this.save((int)character);
            return;
        }
        catch (Pause pause) {
            object = UnwindState$L4O0.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            ((UnwindState$L4O0)object).l0 = n;
            throw pause;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int lexToken(Token var1_1, Object var2_2) throws CompileException, LuaError, Pause {
        block120: {
            block117: {
                block119: {
                    block116: {
                        block118: {
                            block115: {
                                if (var2_2 != null) ** GOTO lbl13
                                this.bufferSize = 0;
lbl3:
                                // 2 sources

                                block96: while (true) {
                                    token.position = Lex.packPosition(this.lineNumber, this.columnNumber);
                                    switch (this.current) {
                                        case 10: 
                                        case 13: {
                                            v0 = this;
                                            v1 = null;
lbl9:
                                            // 2 sources

                                            while (true) {
                                                v0.inclineNumber(v1);
                                                continue block96;
                                                break;
                                            }
                                        }
lbl13:
                                        // 1 sources

                                        var2_2 = (UnwindState$L4O4)var2_2;
                                        switch (var2_2.state) {
                                            default: {
                                                throw new IllegalStateException("Resuming into unknown state");
                                            }
                                            case 0: {
                                                var1_1 = (Token)var2_2.o0;
                                                v0 = this;
                                                v1 = var2_2.child;
                                                ** continue;
                                            }
                                            case 1: {
                                                var1_1 = (Token)var2_2.o0;
                                                v2 = this;
                                                v3 = var2_2.child;
                                                ** GOTO lbl203
                                            }
                                            case 2: {
                                                var1_1 = (Token)var2_2.o0;
                                                v4 = this;
                                                v5 = var2_2.child;
                                                ** GOTO lbl209
                                            }
                                            case 3: {
                                                var1_1 = (Token)var2_2.o0;
                                                v6 = this;
                                                v7 = var2_2.child;
                                                ** GOTO lbl214
                                            }
                                            case 4: {
                                                var1_1 = (Token)var2_2.o0;
                                                v8 = this;
                                                v9 = null;
                                                v10 = 0;
                                                v11 = var2_2.child;
                                                ** GOTO lbl223
                                            }
                                            case 5: {
                                                var1_1 = (Token)var2_2.o0;
                                                v12 = this;
                                                v13 = var2_2.child;
                                                block98: while (true) {
                                                    v12.next(v13);
lbl51:
                                                    // 3 sources

                                                    while (true) {
                                                        if (this.currIsNewline() || this.current == -1) continue block96;
                                                        v12 = this;
                                                        v13 = null;
                                                        continue block98;
                                                        break;
                                                    }
                                                    break;
                                                }
                                            }
                                            case 6: {
                                                var1_1 = (Token)var2_2.o0;
                                                v14 = this;
                                                v15 = var2_2.child;
                                                ** GOTO lbl230
                                            }
                                            case 7: {
                                                var1_1 = (Token)var2_2.o0;
                                                var3_3 = (int)var2_2.l0;
                                                v16 = this;
                                                v17 = null;
                                                v18 = 0;
                                                v19 = var2_2.child;
                                                ** GOTO lbl237
                                            }
                                            case 8: {
                                                var1_1 = (Token)var2_2.o0;
                                                v20 = this;
                                                v21 = var2_2.child;
                                                ** GOTO lbl245
                                            }
                                            case 9: {
                                                var1_1 = (Token)var2_2.o0;
                                                v22 = this;
                                                v23 = 0;
                                                v24 = var2_2.child;
                                                ** GOTO lbl250
                                            }
                                            case 10: {
                                                var1_1 = (Token)var2_2.o0;
                                                v25 = this;
                                                v26 = var2_2.child;
                                                ** GOTO lbl256
                                            }
                                            case 11: {
                                                var1_1 = (Token)var2_2.o0;
                                                v27 = this;
                                                v28 = 0;
                                                v29 = var2_2.child;
                                                ** GOTO lbl261
                                            }
                                            case 12: {
                                                var1_1 = (Token)var2_2.o0;
                                                v30 = this;
                                                v31 = var2_2.child;
                                                ** GOTO lbl267
                                            }
                                            case 13: {
                                                var1_1 = (Token)var2_2.o0;
                                                v32 = this;
                                                v33 = 0;
                                                v34 = var2_2.child;
                                                ** GOTO lbl272
                                            }
                                            case 14: {
                                                var1_1 = (Token)var2_2.o0;
                                                v35 = this;
                                                v36 = var2_2.child;
                                                ** GOTO lbl278
                                            }
                                            case 15: {
                                                var1_1 = (Token)var2_2.o0;
                                                v37 = this;
                                                v38 = 0;
                                                v39 = var2_2.child;
                                                ** GOTO lbl283
                                            }
                                            case 16: {
                                                var1_1 = (Token)var2_2.o0;
                                                v40 = this;
                                                v41 = var2_2.child;
                                                ** GOTO lbl289
                                            }
                                            case 17: {
                                                var1_1 = (Token)var2_2.o0;
                                                v42 = this;
                                                v43 = 0;
                                                v44 = var2_2.child;
                                                ** GOTO lbl294
                                            }
                                            case 18: {
                                                v45 = var1_1 = (Token)var2_2.o0;
                                                v46 = this;
                                                v47 = 0;
                                                v48 = var2_2.child;
                                                ** GOTO lbl302
                                            }
                                            case 19: {
                                                var1_1 = (Token)var2_2.o0;
                                                v49 = this;
                                                v50 = var2_2.child;
                                                ** GOTO lbl308
                                            }
                                            case 20: {
                                                var1_1 = (Token)var2_2.o0;
                                                v51 = this;
                                                v52 = 0;
                                                v53 = var2_2.child;
                                                ** GOTO lbl313
                                            }
                                            case 21: {
                                                var1_1 = (Token)var2_2.o0;
                                                v54 = this;
                                                v55 = 0;
                                                v56 = var2_2.child;
                                                ** GOTO lbl318
                                            }
                                            case 22: {
                                                v57 = var1_1 = (Token)var2_2.o0;
                                                v58 = this;
                                                v59 = var2_2.child;
                                                ** GOTO lbl326
                                            }
                                            case 23: {
                                                var1_1 = (Token)var2_2.o0;
                                                v60 = this;
                                                v61 = var2_2.child;
                                                break block115;
                                            }
                                            case 24: {
                                                v62 = var1_1 = (Token)var2_2.o0;
                                                v63 = this;
                                                v64 = var2_2.child;
                                                break block116;
                                            }
                                            case 25: {
                                                var1_1 = (Token)var2_2.o0;
                                                v65 = this;
                                                v66 = var2_2.child;
lbl166:
                                                // 2 sources

                                                while (true) {
                                                    v65.saveAndNext(v66);
                                                    break;
                                                }
                                            }
                                            case 26: {
                                                var3_3 = (int)var2_2.l0;
                                                v67 = this;
                                                v68 = var2_2.child;
                                                break;
                                            }
                                        }
                                        break block117;
                                        catch (Pause v69) {
                                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                            v69.pushState((UnwindState)var2_2);
                                            var2_2.state = 5;
                                            var2_2.o0 = var1_1;
                                            throw v69;
                                        }
                                        catch (Pause v70) {
                                            var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                            v70.pushState((UnwindState)var2_2);
                                            var2_2.state = 25;
                                            var2_2.o0 = var1_1;
                                            throw v70;
                                        }
                                        if (!CharProperties.isAlphaNum(this.current) && this.current != 95) {
                                            reservedIdx = Lex.RESERVED.get(ByteBuffer.wrap(this.buff, 0, this.bufferSize));
                                            if (reservedIdx != null) {
                                                return reservedIdx;
                                            }
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            while (true) {
                                                v65 = this;
                                                v66 = null;
                                                ** continue;
                                                break;
                                            }
                                        }
                                        token.value = this.newString(this.buff, 0, this.bufferSize);
                                        return 288;
                                        case 45: {
                                            v2 = this;
                                            v3 = null;
lbl203:
                                            // 3 sources

                                            v2.next(v3);
                                            if (this.current != 45) {
                                                return 45;
                                            }
                                            v4 = this;
                                            v5 = null;
lbl209:
                                            // 3 sources

                                            v4.next(v5);
                                            if (this.current != 91) ** GOTO lbl51
                                            v6 = this;
                                            v7 = null;
lbl214:
                                            // 3 sources

                                            sep = v6.skipSep(v7);
                                            this.bufferSize = 0;
                                            if (sep >= 2) ** break;
                                            ** continue;
                                            v8 = this;
                                            v9 = null;
                                            v10 = sep;
                                            v11 = null;
lbl223:
                                            // 3 sources

                                            v8.readLongString(v9, v10, v11);
                                            this.bufferSize = 0;
                                            continue block96;
                                        }
                                        case 91: {
                                            v14 = this;
                                            v15 = null;
lbl230:
                                            // 3 sources

                                            sep = v14.skipSep(v15);
                                            if (sep < 2) ** GOTO lbl239
                                            v16 = this;
                                            v17 = token;
                                            v18 = sep;
                                            v19 = null;
lbl237:
                                            // 3 sources

                                            v16.readLongString(v17, v18, v19);
                                            return 289;
lbl239:
                                            // 1 sources

                                            if (sep != 0) return 91;
                                            throw this.lexError("invalid long string delimiter", 289);
                                        }
                                        case 61: {
                                            v20 = this;
                                            v21 = null;
lbl245:
                                            // 3 sources

                                            v20.next(v21);
                                            v22 = this;
                                            v23 = 61;
                                            v24 = null;
lbl250:
                                            // 3 sources

                                            if (v22.checkNext((char)v23, v24) == false) return 61;
                                            return 281;
                                        }
                                        case 60: {
                                            v25 = this;
                                            v26 = null;
lbl256:
                                            // 3 sources

                                            v25.next(v26);
                                            v27 = this;
                                            v28 = 61;
                                            v29 = null;
lbl261:
                                            // 3 sources

                                            if (v27.checkNext((char)v28, v29) == false) return 60;
                                            return 283;
                                        }
                                        case 62: {
                                            v30 = this;
                                            v31 = null;
lbl267:
                                            // 3 sources

                                            v30.next(v31);
                                            v32 = this;
                                            v33 = 61;
                                            v34 = null;
lbl272:
                                            // 3 sources

                                            if (v32.checkNext((char)v33, v34) == false) return 62;
                                            return 282;
                                        }
                                        case 126: {
                                            v35 = this;
                                            v36 = null;
lbl278:
                                            // 3 sources

                                            v35.next(v36);
                                            v37 = this;
                                            v38 = 61;
                                            v39 = null;
lbl283:
                                            // 3 sources

                                            if (v37.checkNext((char)v38, v39) == false) return 126;
                                            return 284;
                                        }
                                        case 58: {
                                            v40 = this;
                                            v41 = null;
lbl289:
                                            // 3 sources

                                            v40.next(v41);
                                            v42 = this;
                                            v43 = 58;
                                            v44 = null;
lbl294:
                                            // 3 sources

                                            if (v42.checkNext((char)v43, v44) == false) return 58;
                                            return 285;
                                        }
                                        case 34: 
                                        case 39: {
                                            v45 = token;
                                            v46 = this;
                                            v47 = this.current;
                                            v48 = null;
lbl302:
                                            // 3 sources

                                            v45.value = v46.readString(v47, v48);
                                            return 289;
                                        }
                                        case 46: {
                                            v49 = this;
                                            v50 = null;
lbl308:
                                            // 3 sources

                                            v49.saveAndNext(v50);
                                            v51 = this;
                                            v52 = 46;
                                            v53 = null;
lbl313:
                                            // 3 sources

                                            if (!v51.checkNext((char)v52, v53)) ** GOTO lbl320
                                            v54 = this;
                                            v55 = 46;
                                            v56 = null;
lbl318:
                                            // 3 sources

                                            if (v54.checkNext((char)v55, v56) == false) return 279;
                                            return 280;
lbl320:
                                            // 1 sources

                                            if (!CharProperties.isDigit(this.current)) {
                                                return 46;
                                            }
                                            v57 = token;
                                            v58 = this;
                                            v59 = null;
lbl326:
                                            // 3 sources

                                            v57.value = v58.readNumeral(v59);
                                            return 287;
                                        }
                                        case -1: {
                                            return 286;
                                        }
                                    }
                                    break;
                                }
                                if (!CharProperties.isSpace(this.current)) break block118;
                                v60 = this;
                                v61 = null;
                            }
                            try {
                                v60.next(v61);
                                ** continue;
                            }
                            catch (Pause v71) {
                                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                                v71.pushState((UnwindState)var2_2);
                                var2_2.state = 23;
                                var2_2.o0 = var1_1;
                                throw v71;
                            }
                        }
                        if (!CharProperties.isDigit(this.current)) break block119;
                        v62 = token;
                        v63 = this;
                        v64 = null;
                    }
                    try {
                        v62.value = v63.readNumeral(v64);
                        return 287;
                    }
                    catch (Pause v72) {
                        var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                        v72.pushState((UnwindState)var2_2);
                        var2_2.state = 24;
                        var2_2.o0 = var1_1;
                        throw v72;
                    }
                }
                ** while (CharProperties.isAlpha((int)this.current) || this.current == 95)
lbl360:
                // 1 sources

                c = this.current;
                v67 = this;
                v68 = null;
            }
            try {}
            catch (Pause v73) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v73.pushState((UnwindState)var2_2);
                var2_2.state = 26;
                var2_2.l0 = var3_3;
                throw v73;
            }
            break block120;
            catch (Pause v74) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v74.pushState((UnwindState)var2_2);
                var2_2.state = 22;
                var2_2.o0 = var1_1;
                throw v74;
            }
            catch (Pause v75) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v75.pushState((UnwindState)var2_2);
                var2_2.state = 21;
                var2_2.o0 = var1_1;
                throw v75;
            }
            catch (Pause v76) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v76.pushState((UnwindState)var2_2);
                var2_2.state = 20;
                var2_2.o0 = var1_1;
                throw v76;
            }
            catch (Pause v77) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v77.pushState((UnwindState)var2_2);
                var2_2.state = 19;
                var2_2.o0 = var1_1;
                throw v77;
            }
            catch (Pause v78) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v78.pushState((UnwindState)var2_2);
                var2_2.state = 18;
                var2_2.o0 = var1_1;
                throw v78;
            }
            catch (Pause v79) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v79.pushState((UnwindState)var2_2);
                var2_2.state = 17;
                var2_2.o0 = var1_1;
                throw v79;
            }
            catch (Pause v80) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v80.pushState((UnwindState)var2_2);
                var2_2.state = 16;
                var2_2.o0 = var1_1;
                throw v80;
            }
            catch (Pause v81) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v81.pushState((UnwindState)var2_2);
                var2_2.state = 15;
                var2_2.o0 = var1_1;
                throw v81;
            }
            catch (Pause v82) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v82.pushState((UnwindState)var2_2);
                var2_2.state = 14;
                var2_2.o0 = var1_1;
                throw v82;
            }
            catch (Pause v83) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v83.pushState((UnwindState)var2_2);
                var2_2.state = 13;
                var2_2.o0 = var1_1;
                throw v83;
            }
            catch (Pause v84) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v84.pushState((UnwindState)var2_2);
                var2_2.state = 12;
                var2_2.o0 = var1_1;
                throw v84;
            }
            catch (Pause v85) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v85.pushState((UnwindState)var2_2);
                var2_2.state = 11;
                var2_2.o0 = var1_1;
                throw v85;
            }
            catch (Pause v86) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v86.pushState((UnwindState)var2_2);
                var2_2.state = 10;
                var2_2.o0 = var1_1;
                throw v86;
            }
            catch (Pause v87) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v87.pushState((UnwindState)var2_2);
                var2_2.state = 9;
                var2_2.o0 = var1_1;
                throw v87;
            }
            catch (Pause v88) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v88.pushState((UnwindState)var2_2);
                var2_2.state = 8;
                var2_2.o0 = var1_1;
                throw v88;
            }
            catch (Pause v89) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v89.pushState((UnwindState)var2_2);
                var2_2.state = 7;
                var2_2.o0 = var1_1;
                var2_2.l0 = var3_3;
                throw v89;
            }
            catch (Pause v90) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v90.pushState((UnwindState)var2_2);
                var2_2.state = 6;
                var2_2.o0 = var1_1;
                throw v90;
            }
            catch (Pause v91) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v91.pushState((UnwindState)var2_2);
                var2_2.state = 4;
                var2_2.o0 = var1_1;
                throw v91;
            }
            catch (Pause v92) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v92.pushState((UnwindState)var2_2);
                var2_2.state = 3;
                var2_2.o0 = var1_1;
                throw v92;
            }
            catch (Pause v93) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v93.pushState((UnwindState)var2_2);
                var2_2.state = 2;
                var2_2.o0 = var1_1;
                throw v93;
            }
            catch (Pause v94) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v94.pushState((UnwindState)var2_2);
                var2_2.state = 1;
                var2_2.o0 = var1_1;
                throw v94;
            }
            catch (Pause v95) {
                var2_2 = UnwindState$L4O4.getOrCreate(var2_2);
                v95.pushState((UnwindState)var2_2);
                var2_2.state = 0;
                var2_2.o0 = var1_1;
                throw v95;
            }
        }
        v67.next(v68);
        return c;
    }

    long lastPosition() {
        return this.lastPosition;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    void skipShebang(Object var1_1) throws CompileException, LuaError, Pause {
        block4: {
            if (var1_1 == null) break block4;
            var1_1 = (UnwindState)var1_1;
            if (var1_1.state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            v0 = this;
            v1 = var1_1.child;
            ** GOTO lbl14
        }
        if (this.current != 35) return;
        while (this.currIsNewline() == false) {
            if (this.current == -1) return;
            v0 = this;
            v1 = null;
lbl14:
            // 2 sources

            try {
                v0.next(v1);
            }
            catch (Pause v2) {
                var1_1 = UnwindState.getOrCreate(var1_1);
                v2.pushState((UnwindState)var1_1);
                var1_1.state = 0;
                throw v2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void nextToken(Object object) throws CompileException, LuaError, Pause {
        Object object2;
        Token token;
        Lex lex;
        if (object == null) {
            this.lastPosition = Lex.packPosition(this.lineNumber, this.columnNumber);
            if (this.lookahead.token != 286) {
                this.token.set(this.lookahead);
                this.lookahead.token = 286;
                return;
            }
            v0 = this.token;
            lex = this;
            token = this.token;
            object2 = null;
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            v0 = this.token;
            lex = this;
            token = null;
            object2 = ((UnwindState)object).child;
        }
        try {
            v0.token = lex.lexToken(token, object2);
            return;
        }
        catch (Pause pause) {
            object = UnwindState.getOrCreate(object);
            pause.pushState((UnwindState)object);
            ((UnwindState)object).state = 0;
            throw pause;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Token lookahead(Object object) throws CompileException, LuaError, Pause {
        block4: {
            Object object2;
            Token token;
            Lex lex;
            block5: {
                Token token2;
                block3: {
                    if (object != null) break block3;
                    if (this.lookahead.token != 286) break block4;
                    token2 = this.lookahead;
                    lex = this;
                    token = this.lookahead;
                    object2 = null;
                    break block5;
                }
                object = (UnwindState)object;
                if (((UnwindState)object).state != 0) {
                    throw new IllegalStateException("Resuming into unknown state");
                }
                token2 = this.lookahead;
                lex = this;
                token = null;
                object2 = ((UnwindState)object).child;
            }
            try {
                token2.token = lex.lexToken(token, object2);
            }
            catch (Pause pause) {
                object = UnwindState.getOrCreate(object);
                pause.pushState((UnwindState)object);
                ((UnwindState)object).state = 0;
                throw pause;
            }
        }
        return this.lookahead;
    }

    static long packPosition(int line, int column) {
        return (long)line | (long)column << 32;
    }

    static int unpackLine(long position) {
        return (int)(position & 0xFFFFFFFFL);
    }

    static int unpackColumn(long position) {
        return (int)(position >> 32 & 0xFFFFFFFFL);
    }

    static {
        HashMap<ByteBuffer, Integer> reserved = new HashMap<ByteBuffer, Integer>();
        for (int i = 0; i < 22; ++i) {
            if (257 + i == 266) continue;
            reserved.put(ValueFactory.valueOf(tokenNames[i]).toBuffer(), 257 + i);
        }
        RESERVED = Collections.unmodifiableMap(reserved);
    }

    static class Token {
        private int token;
        private LuaValue value;
        private long position;

        Token() {
        }

        private void set(Token other) {
            this.token = other.token;
            this.value = other.value;
            this.position = other.position;
        }

        int token() {
            return this.token;
        }

        int line() {
            return (int)(this.position & 0xFFFFFFFFL);
        }

        long position() {
            return this.position;
        }

        LuaString stringContents() {
            return (LuaString)this.value;
        }

        LuaNumber numberContents() {
            return (LuaNumber)this.value;
        }
    }
}

