/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.BinOpr;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.ExpKind;
import org.squiddev.cobalt.compiler.IntPtr;
import org.squiddev.cobalt.compiler.Lex;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.compiler.Parser;
import org.squiddev.cobalt.compiler.UnOpr;
import org.squiddev.cobalt.function.LocalVariable;

final class FuncState {
    final FuncState prev;
    final Lex lexer;
    final List<LuaValue> constants = new ArrayList<LuaValue>(0);
    private final Map<LuaValue, Integer> constantLookup = new HashMap<LuaValue, Integer>();
    final List<LocalVariable> locals = new ArrayList<LocalVariable>(0);
    final List<Prototype> children = new ArrayList<Prototype>(0);
    final List<Prototype.UpvalueInfo> upvalues = new ArrayList<Prototype.UpvalueInfo>(0);
    int pc;
    int[] code;
    private int[] lineInfo;
    private int[] columnInfo;
    int lineDefined;
    int lastLineDefined;
    int numParams;
    boolean isVararg;
    int maxStackSize = 2;
    BlockCnt block;
    int lastTarget = 0;
    final IntPtr jpc = new IntPtr(-1);
    int freeReg;
    short activeVariableCount;
    final int firstLocal;
    final int firstLabel;

    FuncState(Lex lexer, FuncState prev, int firstLocal, int firstLabel) {
        this.lexer = lexer;
        this.prev = prev;
        this.firstLocal = firstLocal;
        this.firstLabel = firstLabel;
    }

    Prototype toPrototype() {
        return new Prototype(this.lexer.source, this.lexer.shortSource, this.constants.toArray(new LuaValue[0]), LuaC.realloc(this.code, this.pc), this.children.toArray(new Prototype[0]), this.numParams, this.isVararg, this.maxStackSize, (Prototype.UpvalueInfo[])this.upvalues.toArray(Prototype.UpvalueInfo[]::new), this.lineDefined, this.lastLineDefined, LuaC.realloc(this.lineInfo, this.pc), LuaC.realloc(this.columnInfo, this.pc), this.locals.toArray(new LocalVariable[0]));
    }

    void setMultiRet(Parser.ExpDesc e) throws CompileException {
        this.setReturns(e, -1);
    }

    void nil(int from, int n) throws CompileException {
        int previous;
        int to = from + n - 1;
        if (this.pc > this.lastTarget && Lua.GET_OPCODE(previous = this.code[this.pc - 1]) == 4) {
            int pFrom = Lua.GETARG_A(previous);
            int pTo = pFrom + Lua.GETARG_B(previous);
            if (pFrom <= from && from <= pTo + 1 || from <= pFrom && pFrom <= to + 1) {
                if (pFrom <= from) {
                    from = pFrom;
                }
                if (pTo > to) {
                    to = pTo;
                }
                previous = LuaC.SETARG_A(previous, from);
                this.code[this.pc - 1] = previous = LuaC.SETARG_B(previous, to - from);
                return;
            }
        }
        this.codeABC(4, from, n - 1, 0);
    }

    private int getJump(int pc) {
        int offset = Lua.GETARG_sBx(this.code[pc]);
        if (offset == -1) {
            return -1;
        }
        return pc + 1 + offset;
    }

    private void fixJump(int pc, int dest) throws CompileException {
        int offset = dest - (pc + 1);
        assert (dest != -1);
        if (Math.abs(offset) > 131071) {
            throw this.lexer.syntaxError("control structure too long");
        }
        this.code[pc] = LuaC.SETARG_sBx(this.code[pc], offset);
    }

    void concat(IntPtr l1, int l2) throws CompileException {
        if (l2 == -1) {
            return;
        }
        if (l1.value == -1) {
            l1.value = l2;
        } else {
            int next;
            int list = l1.value;
            while ((next = this.getJump(list)) != -1) {
                list = next;
            }
            this.fixJump(list, l2);
        }
    }

    int jump() throws CompileException {
        int jpc = this.jpc.value;
        this.jpc.value = -1;
        IntPtr j = new IntPtr(this.codeAsBx(23, 0, -1));
        this.concat(j, jpc);
        return j.value;
    }

    void ret(int first, int nret) throws CompileException {
        this.codeABC(31, first, nret + 1, 0);
    }

    private int condJump(int op, int A, int B, int C, long position) throws CompileException {
        this.codeABCAt(op, A, B, C, position);
        return this.jump();
    }

    int getLabel() {
        this.lastTarget = this.pc;
        return this.pc;
    }

    private int getJumpControl(int pc) {
        if (pc >= 1 && Lua.testTMode(Lua.GET_OPCODE(this.code[pc - 1]))) {
            return pc - 1;
        }
        return pc;
    }

    private boolean patchTestReg(int node, int reg) {
        int jumpControlPc = this.getJumpControl(node);
        int op = this.code[jumpControlPc];
        if (Lua.GET_OPCODE(op) != 28) {
            return false;
        }
        this.code[jumpControlPc] = reg != 255 && reg != Lua.GETARG_B(op) ? LuaC.SETARG_A(op, reg) : LuaC.CREATE_ABC(27, Lua.GETARG_B(op), 0, Lua.GETARG_C(op));
        return true;
    }

    private void removeValues(int list) {
        while (list != -1) {
            this.patchTestReg(list, 255);
            list = this.getJump(list);
        }
    }

    private void patchListAux(int list, int vtarget, int reg, int dtarget) throws CompileException {
        while (list != -1) {
            int next = this.getJump(list);
            if (this.patchTestReg(list, reg)) {
                this.fixJump(list, vtarget);
            } else {
                this.fixJump(list, dtarget);
            }
            list = next;
        }
    }

    private void dischargeJumpPc() throws CompileException {
        this.patchListAux(this.jpc.value, this.pc, 255, this.pc);
        this.jpc.value = -1;
    }

    void patchToHere(int list) throws CompileException {
        this.getLabel();
        this.concat(this.jpc, list);
    }

    void patchList(int list, int target) throws CompileException {
        if (target == this.pc) {
            this.patchToHere(list);
        } else {
            assert (target < this.pc);
            this.patchListAux(list, target, 255, target);
        }
    }

    void patchClose(int list, int level) {
        ++level;
        while (list != -1) {
            assert (Lua.GET_OPCODE(this.code[list]) == 23 && (Lua.GETARG_A(this.code[list]) == 0 || Lua.GETARG_A(this.code[list]) >= level));
            this.code[list] = LuaC.SETARG_A(this.code[list], level);
            list = this.getJump(list);
        }
    }

    private int code(int instruction, long position) throws CompileException {
        assert (position > 0L);
        this.dischargeJumpPc();
        if (this.code == null || this.pc + 1 > this.code.length) {
            this.code = LuaC.realloc(this.code, this.pc * 2 + 1);
        }
        this.code[this.pc] = instruction;
        if (this.lineInfo == null || this.pc + 1 > this.lineInfo.length) {
            this.lineInfo = LuaC.realloc(this.lineInfo, this.pc * 2 + 1);
            this.columnInfo = LuaC.realloc(this.columnInfo, this.pc * 2 + 1);
        }
        this.lineInfo[this.pc] = Lex.unpackLine(position);
        this.columnInfo[this.pc] = Lex.unpackColumn(position);
        return this.pc++;
    }

    int codeABCAt(int o, int a, int b, int c, long position) throws CompileException {
        assert (Lua.getOpMode(o) == 0);
        assert (Lua.getBMode(o) != 0 || b == 0);
        assert (Lua.getCMode(o) != 0 || c == 0);
        return this.code(LuaC.CREATE_ABC(o, a, b, c), position);
    }

    int codeABC(int o, int a, int b, int c) throws CompileException {
        return this.codeABCAt(o, a, b, c, this.lexer.lastPosition());
    }

    int codeABxAt(int o, int a, int bc, long position) throws CompileException {
        assert (Lua.getOpMode(o) == 1 || Lua.getOpMode(o) == 2);
        assert (Lua.getCMode(o) == 0);
        assert (position > 0L);
        return this.code(LuaC.CREATE_ABx(o, a, bc), position);
    }

    int codeABx(int o, int a, int bc) throws CompileException {
        return this.codeABxAt(o, a, bc, this.lexer.lastPosition());
    }

    int codeAsBxAt(int o, int A, int sBx, long position) throws CompileException {
        return this.codeABxAt(o, A, sBx + 131071, position);
    }

    int codeAsBx(int o, int A, int sBx) throws CompileException {
        return this.codeABx(o, A, sBx + 131071);
    }

    int codeK(int reg, int k) throws CompileException {
        if (k <= 262143) {
            return this.codeABx(1, reg, k);
        }
        int p = this.codeABx(2, reg, 0);
        this.code(LuaC.CREATE_Ax(39, k), this.lexer.lastPosition());
        return p;
    }

    void checkStack(int n) throws CompileException {
        int newStack = this.freeReg + n;
        if (newStack > this.maxStackSize) {
            if (newStack >= 250) {
                throw this.lexer.syntaxError("function or expression too complex");
            }
            this.maxStackSize = newStack;
        }
    }

    void reserveRegs(int n) throws CompileException {
        this.checkStack(n);
        this.freeReg += n;
    }

    private void freeReg(int reg) {
        if (!Lua.ISK(reg) && reg >= this.activeVariableCount) {
            --this.freeReg;
            assert (reg == this.freeReg);
        }
    }

    private void freeExp(Parser.ExpDesc e) {
        if (e.kind == ExpKind.VNONRELOC) {
            this.freeReg(e.info);
        }
    }

    private void freeExp(Parser.ExpDesc e1, Parser.ExpDesc e2) {
        int r2;
        int r1 = e1.kind == ExpKind.VNONRELOC ? e1.info : -1;
        int n = r2 = e2.kind == ExpKind.VNONRELOC ? e2.info : -1;
        if (r1 > r2) {
            this.freeReg(r1);
            this.freeReg(r2);
        } else {
            this.freeReg(r2);
            this.freeReg(r1);
        }
    }

    private int addConstant(LuaValue v) {
        Integer existing = this.constantLookup.get(v);
        if (existing != null) {
            return existing;
        }
        int idx = this.constants.size();
        this.constantLookup.put(v, idx);
        this.constants.add(v);
        return idx;
    }

    int stringK(LuaString s) {
        return this.addConstant(s);
    }

    int numberK(LuaNumber r) {
        int i;
        double d;
        if (r instanceof LuaDouble && (d = r.toDouble()) == (double)(i = (int)d)) {
            r = LuaInteger.valueOf(i);
        }
        return this.addConstant(r);
    }

    private int boolK(boolean b) {
        return this.addConstant(b ? Constants.TRUE : Constants.FALSE);
    }

    private int nilK() {
        return this.addConstant(Constants.NIL);
    }

    void setReturns(Parser.ExpDesc e, int nresults) throws CompileException {
        if (e.kind == ExpKind.VCALL) {
            this.code[e.info] = LuaC.SETARG_C(this.code[e.info], nresults + 1);
        } else if (e.kind == ExpKind.VVARARG) {
            int op = LuaC.SETARG_B(this.code[e.info], nresults + 1);
            this.code[e.info] = LuaC.SETARG_A(op, this.freeReg);
            this.reserveRegs(1);
        } else assert (nresults == -1);
    }

    void setOneRet(Parser.ExpDesc e) {
        if (e.kind == ExpKind.VCALL) {
            e.kind = ExpKind.VNONRELOC;
            e.info = Lua.GETARG_A(this.code[e.info]);
        } else if (e.kind == ExpKind.VVARARG) {
            this.code[e.info] = LuaC.SETARG_B(this.code[e.info], 2);
            e.kind = ExpKind.VRELOCABLE;
        }
    }

    void dischargeVars(Parser.ExpDesc e) throws CompileException {
        switch (e.kind) {
            case VLOCAL: {
                e.kind = ExpKind.VNONRELOC;
                break;
            }
            case VUPVAL: {
                e.info = this.codeABCAt(5, 0, e.info, 0, e.position);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            case VINDEXED: {
                int op;
                this.freeReg(e.aux);
                if (e.tableType == ExpKind.VLOCAL) {
                    this.freeReg(e.info);
                    op = 7;
                } else {
                    assert (e.tableType == ExpKind.VUPVAL);
                    op = 6;
                }
                e.info = this.codeABCAt(op, 0, e.info, e.aux, e.position);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            case VVARARG: 
            case VCALL: {
                this.setOneRet(e);
                break;
            }
        }
    }

    private void discharge2Reg(Parser.ExpDesc e, int reg) throws CompileException {
        this.dischargeVars(e);
        switch (e.kind) {
            case VNIL: {
                this.nil(reg, 1);
                break;
            }
            case VFALSE: 
            case VTRUE: {
                this.codeABC(3, reg, e.kind == ExpKind.VTRUE ? 1 : 0, 0);
                break;
            }
            case VK: {
                this.codeK(reg, e.info);
                break;
            }
            case VKNUM: {
                this.codeK(reg, this.numberK(e.nval()));
                break;
            }
            case VRELOCABLE: {
                this.code[e.info] = LuaC.SETARG_A(this.code[e.info], reg);
                break;
            }
            case VNONRELOC: {
                if (reg == e.info) break;
                this.codeABC(0, reg, e.info, 0);
                break;
            }
            default: {
                assert (e.kind == ExpKind.VJMP);
                return;
            }
        }
        e.info = reg;
        e.kind = ExpKind.VNONRELOC;
    }

    private void discharge2AnyReg(Parser.ExpDesc e) throws CompileException {
        if (e.kind != ExpKind.VNONRELOC) {
            this.reserveRegs(1);
            this.discharge2Reg(e, this.freeReg - 1);
        }
    }

    private int codeLoadBool(int A, int b, int jump) throws CompileException {
        this.getLabel();
        return this.codeABC(3, A, b, jump);
    }

    private boolean needValue(int list) {
        while (list != -1) {
            if (Lua.GET_OPCODE(this.code[this.getJumpControl(list)]) != 28) {
                return true;
            }
            list = this.getJump(list);
        }
        return false;
    }

    private void exp2reg(Parser.ExpDesc e, int reg) throws CompileException {
        this.discharge2Reg(e, reg);
        if (e.kind == ExpKind.VJMP) {
            this.concat(e.t, e.info);
        }
        if (e.hasjumps()) {
            int pcFalse = -1;
            int psTrue = -1;
            if (this.needValue(e.t.value) || this.needValue(e.f.value)) {
                int fj = e.kind == ExpKind.VJMP ? -1 : this.jump();
                pcFalse = this.codeLoadBool(reg, 0, 1);
                psTrue = this.codeLoadBool(reg, 1, 0);
                this.patchToHere(fj);
            }
            int end = this.getLabel();
            this.patchListAux(e.f.value, end, reg, pcFalse);
            this.patchListAux(e.t.value, end, reg, psTrue);
        }
        e.t.value = -1;
        e.f.value = -1;
        e.info = reg;
        e.kind = ExpKind.VNONRELOC;
    }

    void exp2NextReg(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        this.freeExp(e);
        this.reserveRegs(1);
        this.exp2reg(e, this.freeReg - 1);
    }

    int exp2AnyReg(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        if (e.kind == ExpKind.VNONRELOC) {
            if (!e.hasjumps()) {
                return e.info;
            }
            if (e.info >= this.activeVariableCount) {
                this.exp2reg(e, e.info);
                return e.info;
            }
        }
        this.exp2NextReg(e);
        return e.info;
    }

    void exp2AnyRegUp(Parser.ExpDesc e) throws CompileException {
        if (e.kind != ExpKind.VUPVAL || e.hasjumps()) {
            this.exp2AnyReg(e);
        }
    }

    void exp2Val(Parser.ExpDesc e) throws CompileException {
        if (e.hasjumps()) {
            this.exp2AnyReg(e);
        } else {
            this.dischargeVars(e);
        }
    }

    int exp2RK(Parser.ExpDesc e) throws CompileException {
        this.exp2Val(e);
        switch (e.kind) {
            case VNIL: {
                e.setConstant(this.nilK());
                break;
            }
            case VTRUE: {
                e.setConstant(this.boolK(true));
                break;
            }
            case VFALSE: {
                e.setConstant(this.boolK(false));
                break;
            }
            case VKNUM: {
                e.setConstant(this.numberK(e.nval()));
            }
        }
        if (e.kind == ExpKind.VK && e.info <= 255) {
            return Lua.RKASK(e.info);
        }
        return this.exp2AnyReg(e);
    }

    void storeVar(Parser.ExpDesc var, Parser.ExpDesc ex) throws CompileException {
        switch (var.kind) {
            case VLOCAL: {
                this.freeExp(ex);
                this.exp2reg(ex, var.info);
                return;
            }
            case VUPVAL: {
                int e = this.exp2AnyReg(ex);
                this.codeABCAt(9, e, var.info, 0, var.position);
                break;
            }
            case VINDEXED: {
                int opcode = var.tableType == ExpKind.VLOCAL ? 10 : 8;
                int e = this.exp2RK(ex);
                this.codeABCAt(opcode, var.info, var.aux, e, var.position);
                break;
            }
            default: {
                throw new AssertionError((Object)"invalid var kind to store");
            }
        }
        this.freeExp(ex);
    }

    void self(Parser.ExpDesc e, Parser.ExpDesc key) throws CompileException {
        this.exp2AnyReg(e);
        int eReg = e.info;
        this.freeExp(e);
        e.info = this.freeReg;
        e.kind = ExpKind.VNONRELOC;
        this.reserveRegs(2);
        this.codeABC(12, e.info, eReg, this.exp2RK(key));
        this.freeExp(key);
    }

    private void negateCondition(Parser.ExpDesc e) {
        int pc = this.getJumpControl(e.info);
        int i = this.code[pc];
        assert (Lua.testTMode(Lua.GET_OPCODE(i)) && Lua.GET_OPCODE(i) != 28 && Lua.GET_OPCODE(i) != 27);
        this.code[pc] = LuaC.SETARG_A(i, Lua.GETARG_A(i) != 0 ? 0 : 1);
    }

    private int jumpOnCond(Parser.ExpDesc e, int cond) throws CompileException {
        int ie;
        if (e.kind == ExpKind.VRELOCABLE && Lua.GET_OPCODE(ie = this.code[e.info]) == 20) {
            --this.pc;
            return this.condJump(27, Lua.GETARG_B(ie), 0, cond != 0 ? 0 : 1, this.lexer.lastPosition());
        }
        this.discharge2AnyReg(e);
        this.freeExp(e);
        return this.condJump(28, 255, e.info, cond, this.lexer.lastPosition());
    }

    void goIfTrue(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        int pc = switch (e.kind) {
            case ExpKind.VTRUE, ExpKind.VK, ExpKind.VKNUM -> -1;
            case ExpKind.VJMP -> {
                this.negateCondition(e);
                yield e.info;
            }
            default -> this.jumpOnCond(e, 0);
        };
        this.concat(e.f, pc);
        this.patchToHere(e.t.value);
        e.t.value = -1;
    }

    void goIfFalse(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        int pc = switch (e.kind) {
            case ExpKind.VNIL, ExpKind.VFALSE -> -1;
            case ExpKind.VJMP -> e.info;
            default -> this.jumpOnCond(e, 1);
        };
        this.concat(e.t, pc);
        this.patchToHere(e.f.value);
        e.f.value = -1;
    }

    private void codeNot(Parser.ExpDesc e) throws CompileException {
        this.dischargeVars(e);
        switch (e.kind) {
            case VNIL: 
            case VFALSE: {
                e.kind = ExpKind.VTRUE;
                break;
            }
            case VTRUE: 
            case VK: 
            case VKNUM: {
                e.kind = ExpKind.VFALSE;
                break;
            }
            case VJMP: {
                this.negateCondition(e);
                break;
            }
            case VRELOCABLE: 
            case VNONRELOC: {
                this.discharge2AnyReg(e);
                this.freeExp(e);
                e.info = this.codeABC(20, 0, e.info, 0);
                e.kind = ExpKind.VRELOCABLE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int temp = e.f.value;
        e.f.value = e.t.value;
        e.t.value = temp;
        this.removeValues(e.f.value);
        this.removeValues(e.t.value);
    }

    void indexed(Parser.ExpDesc t, Parser.ExpDesc k, long pos) throws CompileException {
        assert (!t.hasjumps() && (t.kind.isInRegister() || t.kind == ExpKind.VUPVAL));
        t.aux = this.exp2RK(k);
        t.tableType = t.kind == ExpKind.VUPVAL ? ExpKind.VUPVAL : ExpKind.VLOCAL;
        t.kind = ExpKind.VINDEXED;
        t.position = pos;
    }

    private static boolean constFolding(int op, Parser.ExpDesc e1, Parser.ExpDesc e2) {
        double r;
        if (!e1.isnumeral() || !e2.isnumeral()) {
            return false;
        }
        double v1 = e1.nval().toDouble();
        double v2 = e2.nval().toDouble();
        switch (op) {
            case 13: {
                r = v1 + v2;
                break;
            }
            case 14: {
                r = v1 - v2;
                break;
            }
            case 15: {
                r = v1 * v2;
                break;
            }
            case 16: {
                if (v2 == 0.0) {
                    return false;
                }
                r = v1 / v2;
                break;
            }
            case 17: {
                if (v2 == 0.0) {
                    return false;
                }
                r = OperationHelper.mod(v1, v2);
                break;
            }
            case 18: {
                r = Math.pow(v1, v2);
                break;
            }
            case 19: {
                r = -v1;
                break;
            }
            case 21: {
                return false;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (Double.isNaN(r)) {
            return false;
        }
        e1.setNval(ValueFactory.valueOf(r));
        return true;
    }

    private void codeUnaryExpression(int opcode, Parser.ExpDesc e, long position) throws CompileException {
        int r = this.exp2AnyReg(e);
        this.freeExp(e);
        e.info = this.codeABCAt(opcode, 0, r, 0, position);
        e.kind = ExpKind.VRELOCABLE;
    }

    private void codeBinaryExpression(int opcode, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        int rk2 = this.exp2RK(e2);
        int rk1 = this.exp2RK(e1);
        this.freeExp(e1, e2);
        e1.info = this.codeABCAt(opcode, 0, rk1, rk2, position);
        e1.kind = ExpKind.VRELOCABLE;
    }

    private void codeArith(int op, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        if (!FuncState.constFolding(op, e1, e2)) {
            this.codeBinaryExpression(op, e1, e2, position);
        }
    }

    private void codeComparison(BinOpr op, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        int rk1 = switch (e1.kind) {
            case ExpKind.VK -> Lua.RKASK(e1.info);
            case ExpKind.VNONRELOC -> e1.info;
            default -> throw new AssertionError();
        };
        int rk2 = this.exp2RK(e2);
        this.freeExp(e1, e2);
        e1.info = switch (op) {
            case BinOpr.NE -> this.condJump(24, 0, rk1, rk2, position);
            case BinOpr.GT -> this.condJump(25, 1, rk2, rk1, position);
            case BinOpr.GE -> this.condJump(26, 1, rk2, rk1, position);
            case BinOpr.EQ -> this.condJump(24, 1, rk1, rk2, position);
            case BinOpr.LT -> this.condJump(25, 1, rk1, rk2, position);
            case BinOpr.LE -> this.condJump(26, 1, rk1, rk2, position);
            default -> throw new AssertionError((Object)"not a comparison");
        };
        e1.kind = ExpKind.VJMP;
    }

    void prefix(UnOpr op, Parser.ExpDesc e, long position) throws CompileException {
        switch (op) {
            case MINUS: {
                if (FuncState.constFolding(19, e, e)) break;
                this.codeUnaryExpression(19, e, position);
                break;
            }
            case NOT: {
                this.codeNot(e);
                break;
            }
            case LEN: {
                this.codeUnaryExpression(21, e, position);
            }
        }
    }

    void infix(BinOpr op, Parser.ExpDesc v) throws CompileException {
        switch (op) {
            case AND: {
                this.goIfTrue(v);
                break;
            }
            case OR: {
                this.goIfFalse(v);
                break;
            }
            case CONCAT: {
                this.exp2NextReg(v);
                break;
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case POW: {
                if (v.isnumeral()) break;
                this.exp2RK(v);
                break;
            }
            default: {
                this.exp2RK(v);
            }
        }
    }

    void posfix(BinOpr op, Parser.ExpDesc e1, Parser.ExpDesc e2, long position) throws CompileException {
        switch (op) {
            case AND: {
                assert (e1.t.value == -1);
                this.dischargeVars(e2);
                this.concat(e2.f, e1.f.value);
                e1.setValue(e2);
                break;
            }
            case OR: {
                assert (e1.f.value == -1);
                this.dischargeVars(e2);
                this.concat(e2.t, e1.t.value);
                e1.setValue(e2);
                break;
            }
            case CONCAT: {
                this.exp2Val(e2);
                if (e2.kind == ExpKind.VRELOCABLE && Lua.GET_OPCODE(this.code[e2.info]) == 22) {
                    assert (e1.info == Lua.GETARG_B(this.code[e2.info]) - 1);
                    this.freeExp(e1);
                    this.code[e2.info] = LuaC.SETARG_B(this.code[e2.info], e1.info);
                    e1.kind = ExpKind.VRELOCABLE;
                    e1.info = e2.info;
                    break;
                }
                this.exp2NextReg(e2);
                this.codeBinaryExpression(22, e1, e2, position);
                break;
            }
            case ADD: {
                this.codeArith(13, e1, e2, position);
                break;
            }
            case SUB: {
                this.codeArith(14, e1, e2, position);
                break;
            }
            case MUL: {
                this.codeArith(15, e1, e2, position);
                break;
            }
            case DIV: {
                this.codeArith(16, e1, e2, position);
                break;
            }
            case MOD: {
                this.codeArith(17, e1, e2, position);
                break;
            }
            case POW: {
                this.codeArith(18, e1, e2, position);
                break;
            }
            case NE: 
            case GT: 
            case GE: 
            case EQ: 
            case LT: 
            case LE: {
                this.codeComparison(op, e1, e2, position);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown op " + String.valueOf((Object)op)));
            }
        }
    }

    void fixPosition(long position) {
        this.lineInfo[this.pc - 1] = Lex.unpackLine(position);
        this.columnInfo[this.pc - 1] = Lex.unpackColumn(position);
    }

    void setList(int base, int nelems, int tostore) throws CompileException {
        int b;
        int c = (nelems - 1) / 50 + 1;
        int n = b = tostore == -1 ? 0 : tostore;
        assert (tostore != 0);
        if (c <= 511) {
            this.codeABC(36, base, b, c);
        } else {
            this.codeABC(36, base, b, 0);
            this.code(LuaC.CREATE_Ax(39, c), this.lexer.lastPosition());
        }
        this.freeReg = base + 1;
    }

    static class BlockCnt {
        BlockCnt previous;
        short firstLabel;
        short firstGoto;
        short activeVariableCount;
        boolean upval;
        boolean isLoop;

        BlockCnt() {
        }
    }
}

