/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.compiler.LuaBytecodeFormat;
import org.squiddev.cobalt.function.LocalVariable;

class BytecodeDumper {
    private static final boolean IS_LITTLE_ENDIAN = true;
    private static final int NUMBER_FORMAT = 0;
    private static final int SIZEOF_LUA_NUMBER = 8;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_SIZET = 4;
    private static final int SIZEOF_INSTRUCTION = 4;
    private final DataOutputStream writer;
    private final boolean strip;

    private BytecodeDumper(OutputStream w, boolean strip) {
        this.writer = new DataOutputStream(w);
        this.strip = strip;
    }

    private void dumpChar(int b) throws IOException {
        this.writer.write(b);
    }

    private void dumpInt(int x) throws IOException {
        this.writer.writeByte(x & 0xFF);
        this.writer.writeByte(x >> 8 & 0xFF);
        this.writer.writeByte(x >> 16 & 0xFF);
        this.writer.writeByte(x >> 24 & 0xFF);
    }

    private void dumpNullableString(@Nullable LuaString s) throws IOException {
        if (s == null) {
            this.dumpInt(0);
        } else {
            this.dumpString(s);
        }
    }

    private void dumpString(LuaString s) throws IOException {
        int len = s.length();
        this.dumpInt(len + 1);
        s.write(this.writer);
        this.writer.write(0);
    }

    private void dumpDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.dumpInt((int)l);
        this.dumpInt((int)(l >> 32));
    }

    private void dumpCode(Prototype f) throws IOException {
        int[] code = f.code;
        int n = code.length;
        this.dumpInt(n);
        for (int aCode : code) {
            this.dumpInt(aCode);
        }
    }

    private void dumpConstants(Prototype f) throws IOException {
        LuaValue[] k = f.constants;
        int n = k.length;
        this.dumpInt(n);
        block6: for (int i = 0; i < n; ++i) {
            LuaValue o = k[i];
            switch (o.type()) {
                case 0: {
                    this.writer.write(0);
                    continue block6;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar(o.toBoolean() ? 1 : 0);
                    continue block6;
                }
                case 3: {
                    this.writer.write(3);
                    this.dumpDouble(o.toDouble());
                    continue block6;
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString((LuaString)o);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("bad type for " + o);
                }
            }
        }
    }

    private void dumpDebug(Prototype f) throws IOException {
        int i;
        if (f.source == null || this.strip) {
            this.dumpInt(0);
        } else {
            this.dumpString(f.source);
        }
        int n = this.strip ? 0 : f.lineInfo.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpInt(f.lineInfo[i]);
        }
        n = this.strip ? 0 : f.locals.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            LocalVariable lvi = f.locals[i];
            this.dumpString(lvi.name);
            this.dumpInt(lvi.startpc);
            this.dumpInt(lvi.endpc);
        }
        n = this.strip ? 0 : f.upvalues();
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpNullableString(f.getUpvalueName(i));
        }
    }

    private void dumpFunction(Prototype f) throws IOException {
        this.dumpInt(f.lineDefined);
        this.dumpInt(f.lastLineDefined);
        this.dumpChar(f.parameters);
        this.dumpChar(f.isVarArg ? 1 : 0);
        this.dumpChar(f.maxStackSize);
        this.dumpCode(f);
        this.dumpConstants(f);
        this.dumpFunctions(f);
        this.dumpUpvalues(f);
        this.dumpDebug(f);
    }

    private void dumpUpvalues(Prototype f) throws IOException {
        int n = f.upvalues();
        this.dumpInt(n);
        for (int i = 0; i < n; ++i) {
            Prototype.UpvalueInfo info = f.getUpvalue(i);
            this.writer.writeBoolean(info.fromLocal());
            this.writer.writeByte(info.byteIndex());
        }
    }

    private void dumpFunctions(Prototype f) throws IOException {
        int n = f.children.length;
        this.dumpInt(n);
        for (int i = 0; i < n; ++i) {
            this.dumpFunction(f.children[i]);
        }
    }

    private void dumpHeader() throws IOException {
        this.writer.write(LuaBytecodeFormat.LUA_SIGNATURE);
        this.writer.write(82);
        this.writer.write(0);
        this.writer.write(1);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(8);
        this.writer.write(0);
        this.writer.write(LuaBytecodeFormat.LUAC_TAIL);
    }

    public static void dump(Prototype f, OutputStream w, boolean strip) throws IOException {
        BytecodeDumper D = new BytecodeDumper(w, strip);
        D.dumpHeader();
        D.dumpFunction(f);
    }
}

