/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.Arrays;
import java.util.List;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaBoolean;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Varargs;

public final class ValueFactory {
    private static final int MAX_DEPTH = 5;

    private ValueFactory() {
    }

    public static LuaBoolean valueOf(boolean b) {
        return b ? Constants.TRUE : Constants.FALSE;
    }

    public static LuaInteger valueOf(int i) {
        return LuaInteger.valueOf(i);
    }

    public static LuaNumber valueOf(double d) {
        return LuaDouble.valueOf(d);
    }

    public static LuaString valueOf(String s) {
        return LuaString.valueOf(s);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len) {
        return LuaString.valueOf(bytes, off, len);
    }

    public static LuaTable tableOf() {
        return new LuaTable();
    }

    public static LuaTable listOf(LuaValue ... values) {
        LuaTable table = new LuaTable(values.length, 0);
        for (int i = 0; i < values.length; ++i) {
            table.rawset(i + 1, values[i]);
        }
        return table;
    }

    public static LuaTable tableOf(LuaValue ... items) throws LuaError {
        LuaTable table = new LuaTable(0, items.length >> 1);
        for (int i = 0; i < items.length; i += 2) {
            if (items[i + 1].isNil()) continue;
            table.rawset(items[i], items[i + 1]);
        }
        return table;
    }

    public static LuaUserdata userdataOf(Object o) {
        return new LuaUserdata(o);
    }

    public static LuaUserdata userdataOf(Object o, LuaTable metatable) {
        return new LuaUserdata(o, metatable);
    }

    @Deprecated
    public static Varargs varargsOf(LuaValue v) {
        return v;
    }

    public static Varargs varargsOf(LuaValue ... v) {
        return switch (v.length) {
            case 0 -> Constants.NONE;
            case 1 -> v[0];
            case 2 -> new LuaValue.PairVarargs(v[0], v[1]);
            default -> new LuaValue.ArrayVarargs(v, Constants.NONE);
        };
    }

    public static Varargs varargsOf(List<LuaValue> v) {
        return switch (v.size()) {
            case 0 -> Constants.NONE;
            case 1 -> v.get(0);
            case 2 -> new LuaValue.PairVarargs(v.get(0), v.get(1));
            default -> new LuaValue.ArrayVarargs(v.toArray(new LuaValue[0]), Constants.NONE);
        };
    }

    public static Varargs varargsOfCopy(LuaValue[] v, int offset, int length) {
        return switch (length) {
            case 0 -> Constants.NONE;
            case 1 -> v[offset];
            case 2 -> new LuaValue.PairVarargs(v[offset + 0], v[offset + 1]);
            default -> new LuaValue.ArrayVarargs(Arrays.copyOfRange(v, offset, offset + length), Constants.NONE);
        };
    }

    public static Varargs varargsOfCopy(LuaValue[] v, int offset, int length, Varargs more) {
        if (length == 0) {
            return more;
        }
        if (Varargs.DepthVarargs.depth(more) > 5) {
            LuaValue[] values = new LuaValue[length + more.count()];
            System.arraycopy(v, offset, values, 0, length);
            more.fill(values, length);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return length == 1 ? new LuaValue.PairVarargs(v[offset], more) : new LuaValue.ArrayVarargs(Arrays.copyOfRange(v, offset, offset + length), more);
    }

    public static Varargs varargsOf(LuaValue v, Varargs r) {
        if (Varargs.DepthVarargs.depth(r) > 5) {
            LuaValue[] values = new LuaValue[1 + r.count()];
            values[0] = v;
            r.fill(values, 1);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return r.count() == 0 ? v : new LuaValue.PairVarargs(v, r);
    }

    public static Varargs varargsOf(LuaValue v1, LuaValue v2, Varargs v3) {
        if (Varargs.DepthVarargs.depth(v3) > 5) {
            LuaValue[] values = new LuaValue[2 + v3.count()];
            values[0] = v1;
            values[1] = v2;
            v3.fill(values, 2);
            return new LuaValue.ArrayVarargs(values, Constants.NONE);
        }
        return v3.count() == 0 ? new LuaValue.PairVarargs(v1, v2) : new LuaValue.ArrayVarargs(new LuaValue[]{v1, v2}, v3);
    }
}

