/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.function.LocalVariable;

public final class Prototype {
    public final LuaString source;
    public final LuaString shortSource;
    public final LuaValue[] constants;
    public final int[] code;
    public final Prototype[] children;
    private final UpvalueInfo[] upvalues;
    public final int lineDefined;
    public final int lastLineDefined;
    public final int parameters;
    public final boolean isVarArg;
    public final int maxStackSize;
    public final int[] lineInfo;
    public final int[] columnInfo;
    public final LocalVariable[] locals;

    public Prototype(LuaString source, LuaString shortSource, LuaValue[] constants, int[] code, Prototype[] children, int parameters, boolean isVarArg, int maxStackSize, UpvalueInfo[] upvalues, int lineDefined, int lastLineDefined, int[] lineInfo, int[] columnInfo, LocalVariable[] locals) {
        this.source = source;
        this.shortSource = shortSource;
        this.constants = constants;
        this.code = code;
        this.children = children;
        this.parameters = parameters;
        this.isVarArg = isVarArg;
        this.maxStackSize = maxStackSize;
        this.upvalues = upvalues;
        this.lineDefined = lineDefined;
        this.lastLineDefined = lastLineDefined;
        this.lineInfo = lineInfo;
        this.columnInfo = columnInfo;
        this.locals = locals;
    }

    public LuaString shortSource() {
        return this.shortSource;
    }

    public String toString() {
        return this.source + ":" + this.lineDefined + "-" + this.lastLineDefined;
    }

    public @Nullable LuaString getLocalName(int number, int pc) {
        for (int i = 0; i < this.locals.length && this.locals[i].startpc <= pc; ++i) {
            if (pc >= this.locals[i].endpc || --number != 0) continue;
            return this.locals[i].name;
        }
        return null;
    }

    public int upvalues() {
        return this.upvalues.length;
    }

    public UpvalueInfo getUpvalue(int upvalue) {
        return this.upvalues[upvalue];
    }

    public @Nullable LuaString getUpvalueName(int index) {
        return index >= 0 && index < this.upvalues.length ? this.upvalues[index].name() : null;
    }

    public int lineAt(int pc) {
        return pc >= 0 && pc < this.lineInfo.length ? this.lineInfo[pc] : -1;
    }

    public int columnAt(int pc) {
        return pc >= 0 && pc < this.columnInfo.length ? this.columnInfo[pc] : -1;
    }

    public record UpvalueInfo(@Nullable LuaString name, boolean fromLocal, byte byteIndex) {
        public int index() {
            return this.byteIndex & 0xFF;
        }
    }
}

