/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.function.LuaClosure;

public final class Print {
    private Print() {
    }

    private static void printString(StringBuilder out, LuaString s) {
        out.append('\"');
        int n = s.length();
        block11: for (int i = 0; i < n; ++i) {
            int c = s.charAt(i);
            if (c >= 32 && c <= 126 && c != 34 && c != 92) {
                out.append((char)c);
                continue;
            }
            switch (c) {
                case 34: {
                    out.append("\\\"");
                    continue block11;
                }
                case 92: {
                    out.append("\\\\");
                    continue block11;
                }
                case 7: {
                    out.append("\\a");
                    continue block11;
                }
                case 8: {
                    out.append("\\b");
                    continue block11;
                }
                case 12: {
                    out.append("\\f");
                    continue block11;
                }
                case 9: {
                    out.append("\\t");
                    continue block11;
                }
                case 13: {
                    out.append("\\r");
                    continue block11;
                }
                case 10: {
                    out.append("\\n");
                    continue block11;
                }
                case 11: {
                    out.append("\\v");
                    continue block11;
                }
                default: {
                    out.append(String.format("\\%03d", c));
                }
            }
        }
        out.append('\"');
    }

    private static void printConstant(StringBuilder out, Prototype f, int i) {
        LuaValue value = f.constants[i];
        switch (value.type()) {
            case 4: {
                Print.printString(out, (LuaString)value);
                break;
            }
            default: {
                out.append(value);
            }
        }
    }

    public static void printCode(StringBuilder out, Prototype f, boolean extended) {
        int[] code = f.code;
        for (int pc = 0; pc < code.length; ++pc) {
            Print.printOpcode(out, f, pc, extended);
            out.append("\n");
        }
    }

    private static int MYK(int x) {
        return -1 - x;
    }

    public static void printOpcode(StringBuilder out, Prototype f, int pc, boolean extended) {
        int[] code = f.code;
        int i = code[pc];
        int o = Lua.GET_OPCODE(i);
        int a = Lua.GETARG_A(i);
        int b = Lua.GETARG_B(i);
        int c = Lua.GETARG_C(i);
        int ax = Lua.GETARG_Ax(i);
        int bx = Lua.GETARG_Bx(i);
        int sbx = Lua.GETARG_sBx(i);
        out.append("\t").append(pc + 1).append("\t");
        int line = f.lineAt(pc);
        int column = f.columnAt(pc);
        if (extended && line > 0 && column > 0) {
            out.append("[").append(line).append("/").append(column).append("]");
        } else if (line > 0) {
            out.append("[").append(line).append("]");
        } else {
            out.append("[-]");
        }
        out.append("\t");
        String name = Lua.getOpName(o);
        out.append(name);
        for (int j = name.length(); j < 9; ++j) {
            out.append(' ');
        }
        out.append("\t");
        switch (Lua.getOpMode(o)) {
            case 0: {
                out.append(a);
                if (Lua.getBMode(o) != 0) {
                    out.append(" ").append(Lua.ISK(b) ? Print.MYK(Lua.INDEXK(b)) : b);
                }
                if (Lua.getCMode(o) == 0) break;
                out.append(" ").append(Lua.ISK(c) ? Print.MYK(Lua.INDEXK(c)) : c);
                break;
            }
            case 1: {
                out.append(a);
                if (Lua.getBMode(o) == 3) {
                    out.append(" ").append(Print.MYK(bx));
                }
                if (Lua.getBMode(o) != 1) break;
                out.append(" ").append(bx);
                break;
            }
            case 2: {
                out.append(a).append(" ").append(sbx);
                break;
            }
            case 3: {
                out.append(a).append(" ").append(Print.MYK(ax));
            }
        }
        switch (o) {
            case 1: {
                out.append("\t; ");
                Print.printConstant(out, f, bx);
                break;
            }
            case 3: {
                out.append("\t; ");
                out.append(b != 0 ? "true" : "false");
                if (c == 0) break;
                out.append(", to ").append(pc + 3);
                break;
            }
            case 5: 
            case 9: {
                out.append("\t; ");
                Print.printUpvalueName(out, f, b);
                break;
            }
            case 6: {
                out.append("\t; ");
                Print.printUpvalueName(out, f, b);
                if (!Lua.ISK(c)) break;
                out.append(" ");
                Print.printConstant(out, f, Lua.INDEXK(c));
                break;
            }
            case 8: {
                out.append("\t; ");
                Print.printUpvalueName(out, f, a);
                if (Lua.ISK(b)) {
                    out.append(" ");
                    Print.printConstant(out, f, Lua.INDEXK(b));
                }
                if (!Lua.ISK(c)) break;
                out.append(" ");
                Print.printConstant(out, f, Lua.INDEXK(c));
                break;
            }
            case 7: 
            case 12: {
                if (!Lua.ISK(c)) break;
                out.append("\t; ");
                Print.printConstant(out, f, Lua.INDEXK(c));
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: {
                if (!Lua.ISK(b) && !Lua.ISK(c)) break;
                out.append("\t; ");
                if (Lua.ISK(b)) {
                    Print.printConstant(out, f, Lua.INDEXK(b));
                } else {
                    out.append("-");
                }
                out.append(" ");
                if (Lua.ISK(c)) {
                    Print.printConstant(out, f, Lua.INDEXK(c));
                    break;
                }
                out.append("-");
                break;
            }
            case 23: 
            case 32: 
            case 33: 
            case 35: {
                out.append("\t; to ").append(sbx + pc + 2);
                break;
            }
            case 37: {
                out.append("\t; ").append(Print.id(f.children[bx]));
                break;
            }
            case 36: {
                if (c == 0) {
                    out.append("\t; ").append(code[++pc]);
                    break;
                }
                out.append("\t; ").append(c);
                break;
            }
            case 39: {
                out.append("\t; ");
                Print.printConstant(out, f, ax);
                break;
            }
        }
    }

    private static void printUpvalueName(StringBuilder out, Prototype f, int upvalue) {
        LuaString upvalueName = f.getUpvalueName(upvalue);
        if (upvalueName != null) {
            out.append(upvalueName);
        } else {
            out.append("-");
        }
    }

    private static void printHeader(StringBuilder out, Prototype f) {
        String s = String.valueOf(f.source);
        s = s.startsWith("@") || s.startsWith("=") ? s.substring(1) : ("\u001bLua".equals(s) ? "(bstring)" : "(string)");
        out.append("\n%").append(f.lineDefined == 0 ? "main" : "function").append(" <").append(s).append(":").append(f.lineDefined).append(",").append(f.lastLineDefined).append("> (").append(f.code.length).append(" instructions, ").append(f.code.length * 4).append(" bytes at ").append(Print.id(f)).append(")\n");
        out.append(f.parameters).append(" param, ").append(f.maxStackSize).append(" slots, ").append(f.upvalues()).append(" upvalues, ");
        out.append(f.locals.length).append(" locals, ").append(f.constants.length).append(" constants, ").append(f.children.length).append(" functions\n");
    }

    private static void printConstants(StringBuilder out, Prototype f) {
        int n = f.constants.length;
        out.append("constants (").append(n).append(") for ").append(Print.id(f)).append(":\n");
        for (int i = 0; i < n; ++i) {
            out.append("\t").append(i + 1).append("\t");
            Print.printConstant(out, f, i);
            out.append("\n");
        }
    }

    private static void printLocals(StringBuilder out, Prototype f) {
        int n = f.locals.length;
        out.append("locals (").append(n).append(") for ").append(Print.id(f)).append(":\n");
        for (int i = 0; i < n; ++i) {
            out.append("\t").append(i).append("\t").append(f.locals[i].name).append("\t").append(f.locals[i].startpc + 1).append("\t").append(f.locals[i].endpc + 1).append("\n");
        }
    }

    private static void printUpvalues(StringBuilder out, Prototype f) {
        out.append("upvalues (").append(f.upvalues()).append(") for ").append(Print.id(f)).append(":\n");
        int n = f.upvalues();
        for (int i = 0; i < n; ++i) {
            Prototype.UpvalueInfo upvalue = f.getUpvalue(i);
            out.append("\t").append(i).append("\t").append(upvalue.name()).append("\t").append(upvalue.fromLocal() ? (char)'1' : '0').append("\t").append(upvalue.index()).append("\n");
        }
    }

    public static void printFunction(StringBuilder out, Prototype f, boolean full, boolean extended) {
        int n = f.children.length;
        Print.printHeader(out, f);
        Print.printCode(out, f, extended);
        if (full) {
            Print.printConstants(out, f);
            Print.printLocals(out, f);
            Print.printUpvalues(out, f);
        }
        for (int i = 0; i < n; ++i) {
            Print.printFunction(out, f.children[i], full, extended);
        }
    }

    private static String id(Prototype f) {
        return String.valueOf(f.shortSource()) + ":" + f.lineDefined;
    }

    public static void printState(StringBuilder out, LuaClosure cl, int pc, LuaValue[] stack, int top) {
        int len = out.length();
        Print.printOpcode(out, cl.getPrototype(), pc, true);
        while (out.length() < len + 50) {
            out.append(' ');
        }
        out.append('[');
        for (int i = 0; i < stack.length; ++i) {
            LuaValue v = stack[i];
            if (v == null) {
                out.append("null");
            } else {
                switch (v.type()) {
                    case 4: {
                        LuaString s = (LuaString)v;
                        out.append((String)(s.length() < 48 ? s.toString() : String.valueOf(s.substringOfEnd(0, 32)) + "...+" + (s.length() - 32) + "b"));
                        break;
                    }
                    case 6: {
                        String string;
                        if (v instanceof LuaClosure) {
                            LuaClosure c = (LuaClosure)v;
                            string = c.getPrototype().toString();
                        } else {
                            string = v.toString();
                        }
                        out.append(string);
                        break;
                    }
                    case 7: {
                        out.append(v);
                        break;
                    }
                    default: {
                        out.append(v);
                    }
                }
            }
            if (i + 1 == top) {
                out.append(']');
            }
            out.append(" | ");
        }
    }
}

