/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.Objects;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.LuaFunction;

public final class LuaThread
extends LuaValue {
    private final LuaState luaState;
    private Status status;
    private LuaValue errFunc;
    private final DebugState debugState;
    private final LuaFunction function;
    private LuaThread previousThread;

    public LuaThread(LuaState state) {
        super(8);
        Objects.requireNonNull(state, "state cannot be null");
        this.status = Status.RUNNING;
        this.luaState = state;
        this.debugState = new DebugState(state);
        this.function = null;
    }

    public LuaThread(LuaState state, LuaFunction func) {
        super(8);
        Objects.requireNonNull(state, "state cannot be null");
        Objects.requireNonNull(func, "func cannot be null");
        this.status = Status.INITIAL;
        this.luaState = state;
        this.debugState = new DebugState(state);
        this.function = func;
        LuaThread current = state.getCurrentThread();
        if (current != null && current.debugState.getHook() != null && current.debugState.getHook().inheritHook()) {
            this.debugState.setHook(current.debugState.getHook(), current.debugState.hasCallHook(), current.debugState.hasLineHook(), current.debugState.hasReturnHook(), current.debugState.hookCount);
        }
    }

    @Override
    public LuaThread checkThread() {
        return this;
    }

    @Override
    public LuaTable getMetatable(LuaState state) {
        return state.threadMetatable;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isMainThread() {
        return this.luaState.getMainThread() == this;
    }

    public boolean isAlive() {
        return this.status != Status.DEAD;
    }

    public static LuaFunction getCallstackFunction(LuaState state, int level) {
        DebugFrame info = DebugState.get(state).getFrame(level);
        return info == null ? null : info.func;
    }

    public DebugState getDebugState() {
        return this.debugState;
    }

    public LuaValue getErrorFunc() {
        return this.errFunc;
    }

    public LuaValue setErrorFunc(LuaValue errFunc) {
        LuaValue prev = this.errFunc;
        this.errFunc = errFunc;
        return prev;
    }

    public static <T> T yield(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        Objects.requireNonNull(args, "args cannot be null");
        LuaThread thread = state.currentThread;
        if (thread.status != Status.RUNNING) {
            throw new LuaError("cannot yield a " + thread.status.getDisplayName() + " thread");
        }
        if (thread.isMainThread()) {
            throw new LuaError("cannot yield main thread");
        }
        throw UnwindThrowable.yield(args);
    }

    public static <T> T resume(LuaState state, LuaThread thread, Varargs args) throws LuaError, UnwindThrowable {
        LuaThread current = state.currentThread;
        if (current.status != Status.RUNNING) {
            throw new LuaError("cannot resume from a " + current.status.getDisplayName() + " thread");
        }
        if (thread.status.ordinal() > Status.SUSPENDED.ordinal()) {
            throw new LuaError("cannot resume " + thread.status.getDisplayName() + " coroutine");
        }
        throw UnwindThrowable.resume(thread, args);
    }

    public static Varargs runMain(LuaState state, LuaFunction function) throws LuaError {
        return LuaThread.run(state, state.getMainThread(), function, Constants.NONE);
    }

    public static Varargs runMain(LuaState state, LuaFunction function, Varargs args) throws LuaError {
        return LuaThread.run(state, state.getMainThread(), function, args);
    }

    public static Varargs run(LuaThread thread, Varargs args) throws LuaError {
        return LuaThread.run(thread.luaState, thread, null, args);
    }

    private static Varargs run(LuaState state, LuaThread thread, LuaFunction function, Varargs args) throws LuaError {
        return LuaThread.loop(state, thread, function, args);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Varargs loop(LuaState state, LuaThread thread, LuaFunction function, Varargs args) throws LuaError {
        le = null;
        do {
            block17: {
                ds = thread.debugState;
                state.currentThread = thread;
                if (thread.status == Status.INITIAL && function == null) {
                    function = thread.function;
                }
                try {
                    if (function != null) {
                        thread.status = Status.RUNNING;
                        toExecute = function;
                        function = null;
                        try {
                            args = Dispatch.invoke(state, toExecute, args);
                        }
                        catch (Exception | VirtualMachineError e) {
                            args = null;
                            le = LuaError.wrap(e);
                        }
                        break block17;
                    }
                    thread.status = Status.RUNNING;
                    while (true) {
                        ** try [egrp 2[TRYBLOCK] [2, 3 : 81->174)] { 
lbl22:
                        // 1 sources

                        break;
lbl23:
                        // 2 sources

                        catch (Exception | VirtualMachineError e) {
                            args = null;
                            le = LuaError.wrap(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (UnwindThrowable e) {
                    if (e.isSuspend()) {
                        thread.status = Status.SUSPENDED;
                        return null;
                    }
                    if (e.isYield()) {
                        thread.status = Status.SUSPENDED;
                        previous = thread.previousThread;
                        thread.previousThread = null;
                        thread = previous;
                        args = e.getArgs();
                        continue;
                    }
                    thread.status = Status.NORMAL;
                    next = e.getThread();
                    next.previousThread = state.currentThread;
                    thread = next;
                    args = e.getArgs();
                    continue;
                }
                block8: while (true) {
                    if (le != null) {
                        frame = LuaThread.findErrorHandler(ds);
                        if (frame == null) break;
                        err = le;
                        le = null;
                        args = ds.resumeError(frame, err);
                    }
                    while ((frame = ds.getStack()) != null) {
                        if ((frame.flags & 16) != 0 && (frame = LuaThread.findErrorHandler(ds)) == null) continue block8;
                        args = ds.resume(frame, args);
                    }
                    break;
                }
            }
            thread.status = Status.DEAD;
            previous = thread.previousThread;
            thread.previousThread = null;
            thread = previous;
            if (le == null) continue;
            le.fillTraceback(state);
            i = 0;
            while ((di = ds.getFrame(i)) != null) {
                di.cleanup();
                ++i;
            }
        } while (thread != null);
        if (le != null) {
            throw le;
        }
        return args;
    }

    private static DebugFrame findErrorHandler(DebugState ds) {
        int i = 0;
        DebugFrame frame;
        while ((frame = ds.getFrame(i)) != null && (frame.flags & 8) == 0) {
            ++i;
        }
        return frame;
    }

    public static enum Status {
        INITIAL("suspended"),
        SUSPENDED("suspended"),
        RUNNING("running"),
        NORMAL("normal"),
        DEAD("dead");

        private final String name;
        private final LuaValue nameValue;

        private Status(String name) {
            this.name = name;
            this.nameValue = ValueFactory.valueOf(name);
        }

        public String getDisplayName() {
            return this.name;
        }

        public LuaValue getDisplayNameValue() {
            return this.nameValue;
        }
    }
}

