/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import cc.tweaked.cobalt.internal.string.NumberParser;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;

public final class LuaString
extends LuaValue
implements Comparable<LuaString> {
    public static final int RECENT_STRINGS_CACHE_SIZE = 128;
    public static final int RECENT_STRINGS_MAX_LENGTH = 32;
    private Object contents;
    private final int offset;
    private final int length;
    private int hashCode;

    public static LuaString valueOf(String string) {
        byte[] bytes = new byte[string.length()];
        LuaString.encode(string, bytes, 0);
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len) {
        if (bytes.length < 32) {
            return Cache.instance.get(new LuaString(bytes, off, len));
        }
        if (len >= bytes.length / 2) {
            return new LuaString(bytes, off, len);
        }
        byte[] b = new byte[len];
        System.arraycopy(bytes, off, b, 0, len);
        LuaString string = new LuaString(b, 0, len);
        return len < 32 ? Cache.instance.get(string) : string;
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueOfStrings(LuaValue[] contents, int offset, int length, int strLength) {
        if (length == 0 || strLength == 0) {
            return Constants.EMPTYSTRING;
        }
        if (length == 1) {
            return (LuaString)contents[0];
        }
        if (strLength > 32) {
            LuaValue[] slice = new LuaString[length];
            System.arraycopy(contents, offset, slice, 0, length);
            return new LuaString(slice, strLength);
        }
        byte[] out = new byte[strLength];
        int position = 0;
        for (int i = 0; i < length; ++i) {
            position = ((LuaString)contents[offset + i]).copyTo(out, position);
        }
        return LuaString.valueOf(out);
    }

    private LuaString(byte[] contents, int offset, int length) {
        super(4);
        this.contents = contents;
        this.offset = offset;
        this.length = length;
    }

    private LuaString(LuaValue[] contents, int length) {
        super(4);
        this.contents = contents;
        this.offset = 0;
        this.length = length;
    }

    @Override
    public String toString() {
        return LuaString.decode(this.bytes(), this.offset, this.length);
    }

    @Override
    public LuaTable getMetatable(LuaState state) {
        return state.stringMetatable;
    }

    public int length() {
        return this.length;
    }

    private byte[] bytes() {
        Object contents = this.contents;
        if (contents instanceof byte[]) {
            byte[] bytes = (byte[])contents;
            return bytes;
        }
        return this.flatten();
    }

    private byte[] flatten() {
        ArrayDeque<LuaString> queue;
        LuaString string;
        int position;
        byte[] out;
        block6: {
            out = new byte[this.length];
            position = 0;
            LuaString[] strings = (LuaString[])this.contents;
            for (int i = 0; i < strings.length; ++i) {
                string = strings[i];
                Object contents = string.contents;
                if (contents instanceof byte[]) {
                    byte[] bytes = (byte[])contents;
                    System.arraycopy(bytes, string.offset, out, position, string.length);
                    position += string.length;
                    continue;
                }
                queue = new ArrayDeque<LuaString>(Math.max(4, strings.length - i));
                ++i;
                while (i < strings.length) {
                    queue.addLast(strings[i]);
                    ++i;
                }
                break block6;
            }
            this.contents = out;
            return out;
        }
        while (true) {
            Object contents;
            if ((contents = string.contents) instanceof byte[]) {
                byte[] bytes = (byte[])contents;
                System.arraycopy(bytes, string.offset, out, position, string.length);
                position += string.length;
                string = (LuaString)queue.pollFirst();
                if (string != null) continue;
                break;
            }
            LuaString[] newStrings = (LuaString[])contents;
            for (int i = newStrings.length - 1; i > 0; --i) {
                queue.addFirst(newStrings[i]);
            }
            string = newStrings[0];
        }
        this.contents = out;
        return out;
    }

    @Override
    public int compareTo(LuaString rhs) {
        byte[] bytes = this.bytes();
        byte[] rhsBytes = rhs.bytes();
        int len = Math.min(this.length, rhs.length);
        int mismatch = Arrays.mismatch(bytes, this.offset, this.offset + len, rhsBytes, rhs.offset, rhs.offset + len);
        if (mismatch >= 0) {
            return Byte.compareUnsigned(bytes[this.offset + mismatch], rhsBytes[rhs.offset + mismatch]);
        }
        return this.length - rhs.length;
    }

    public boolean equals(Object o) {
        LuaString str;
        return this == o || o instanceof LuaString && this.equals(str = (LuaString)o);
    }

    private boolean equals(LuaString s) {
        if (this == s) {
            return true;
        }
        if (s.length != this.length) {
            return false;
        }
        if (this.contents == s.contents && s.offset == this.offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        return LuaString.equals(this.bytes(), this.offset, s.bytes(), s.offset, this.length);
    }

    public static boolean equals(LuaString a, int aOffset, LuaString b, int bOffset, int length) {
        return LuaString.equals(a.bytes(), a.offset + aOffset, b.bytes(), b.offset + bOffset, length);
    }

    private static boolean equals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        return Arrays.equals(a, aOffset, aOffset + length, b, bOffset, bOffset + length);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h != 0) {
            return h;
        }
        byte[] bytes = this.bytes();
        h = this.length;
        int step = (this.length >> 5) + 1;
        for (int l1 = this.length; l1 >= step; l1 -= step) {
            h ^= (h << 5) + (h >> 2) + (bytes[this.offset + l1 - 1] & 0xFF);
        }
        this.hashCode = h;
        return this.hashCode;
    }

    public LuaString substringOfLen(int beginIndex, int length) {
        return LuaString.valueOf(this.bytes(), this.offset + beginIndex, length);
    }

    public LuaString substringOfEnd(int beginIndex, int endIndex) {
        return LuaString.valueOf(this.bytes(), this.offset + beginIndex, endIndex - beginIndex);
    }

    public LuaString substring(int beginIndex) {
        return LuaString.valueOf(this.bytes(), this.offset + beginIndex, this.length - 1);
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes()[this.offset + index];
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Byte.toUnsignedInt(this.bytes()[this.offset + index]);
    }

    public boolean startsWith(byte character) {
        return this.length != 0 && this.byteAt(0) == character;
    }

    public int indexOfAny(LuaString accept) {
        byte[] bytes = this.bytes();
        byte[] acceptBytes = accept.bytes();
        int limit = this.offset + this.length;
        int searchLimit = accept.offset + accept.length;
        for (int i = this.offset; i < limit; ++i) {
            for (int j = accept.offset; j < searchLimit; ++j) {
                if (bytes[i] != acceptBytes[j]) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    public int indexOf(byte b) {
        byte[] bytes = this.bytes();
        int j = this.offset;
        for (int i = 0; i < this.length; ++i) {
            if (bytes[j++] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaString search, int start) {
        byte[] bytes = this.bytes();
        byte[] searchBytes = search.bytes();
        int searchLen = search.length();
        int limit = this.offset + this.length - searchLen;
        for (int i = this.offset + start; i <= limit; ++i) {
            if (!LuaString.equals(bytes, i, searchBytes, search.offset, searchLen)) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(byte c) {
        byte[] bytes = this.bytes();
        for (int i = this.offset + this.length - 1; i >= this.offset; --i) {
            if (bytes[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void write(DataOutput output) throws IOException {
        output.write(this.bytes(), this.offset, this.length);
    }

    public void write(OutputStream output) throws IOException {
        output.write(this.bytes(), this.offset, this.length);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.bytes(), this.offset, this.length);
    }

    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.bytes(), this.offset, this.length).asReadOnlyBuffer();
    }

    public int copyTo(int strOffset, byte[] bytes, int arrayOffset, int len) {
        if (strOffset < 0 || len > this.length - strOffset) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.bytes(), this.offset + strOffset, bytes, arrayOffset, len);
        return arrayOffset + len;
    }

    public int copyTo(byte[] dest, int destOffset) {
        System.arraycopy(this.bytes(), this.offset, dest, destOffset, this.length);
        return destOffset + this.length;
    }

    private static String decode(byte[] bytes, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(bytes[offset + i] & 0xFF);
        }
        return String.valueOf(chars);
    }

    public static void encode(String string, byte[] bytes, int off) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            bytes[i + off] = c < '\u0100' ? (int)c : 63;
        }
    }

    @Override
    public int checkInteger() throws LuaError {
        return (int)this.checkDouble();
    }

    @Override
    public long checkLong() throws LuaError {
        return (long)this.checkDouble();
    }

    @Override
    public double checkDouble() throws LuaError {
        double d = this.scanNumber(10);
        if (Double.isNaN(d)) {
            throw ErrorFactory.argError(this, "number");
        }
        return d;
    }

    @Override
    public LuaNumber checkNumber() throws LuaError {
        return ValueFactory.valueOf(this.checkDouble());
    }

    @Override
    public LuaNumber checkNumber(String msg) throws LuaError {
        double d = this.scanNumber(10);
        if (Double.isNaN(d)) {
            throw new LuaError(msg);
        }
        return ValueFactory.valueOf(d);
    }

    @Override
    public LuaValue toNumber() {
        return this.toNumber(10);
    }

    @Override
    public boolean isNumber() {
        double d = this.scanNumber(10);
        return !Double.isNaN(d);
    }

    @Override
    public double toDouble() {
        return this.scanNumber(10);
    }

    @Override
    public int toInteger() {
        return (int)this.toDouble();
    }

    @Override
    public LuaValue toLuaString() {
        return this;
    }

    @Override
    public String checkString() {
        return this.toString();
    }

    @Override
    public LuaString checkLuaString() {
        return this;
    }

    public LuaValue toNumber(int base) {
        double d = this.scanNumber(base);
        return Double.isNaN(d) ? Constants.NIL : ValueFactory.valueOf(d);
    }

    private double scanNumber(int base) {
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        return NumberParser.parse(this.bytes(), this.offset, this.length, base);
    }

    private static class Cache {
        public final LuaString[] recentShortStrings = new LuaString[128];
        public static final Cache instance = new Cache();

        private Cache() {
        }

        public LuaString get(LuaString s) {
            int index = s.hashCode() & 0x7F;
            LuaString cached = this.recentShortStrings[index];
            if (cached != null && s.equals(cached)) {
                return cached;
            }
            this.recentShortStrings[index] = s;
            return s;
        }
    }
}

