/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;

public final class LuaInteger
extends LuaNumber {
    private static final LuaInteger[] intValues = new LuaInteger[512];
    private final int v;

    public static LuaInteger valueOf(int i) {
        return i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i);
    }

    public static LuaNumber valueOf(long l) {
        int i = (int)l;
        return l == (long)i ? (i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i)) : LuaDouble.valueOf(l);
    }

    LuaInteger(int i) {
        this.v = i;
    }

    public int intValue() {
        return this.v;
    }

    @Override
    public double toDouble() {
        return this.v;
    }

    @Override
    public int toInteger() {
        return this.v;
    }

    @Override
    public String toString() {
        return Integer.toString(this.v);
    }

    @Override
    public LuaString checkLuaString() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public LuaValue toLuaString() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    public int hashCode() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o instanceof LuaInteger && ((LuaInteger)o).v == this.v;
    }

    @Override
    public int checkInteger() {
        return this.v;
    }

    @Override
    public long checkLong() {
        return this.v;
    }

    @Override
    public double checkDouble() {
        return this.v;
    }

    @Override
    public String checkString() {
        return String.valueOf(this.v);
    }

    static {
        for (int i = 0; i < 512; ++i) {
            LuaInteger.intValues[i] = new LuaInteger(i - 256);
        }
    }
}

