/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.debug.DebugHelpers;

public final class LuaError
extends Exception {
    private static final long serialVersionUID = 3065540200206862088L;
    private LuaValue value;
    private String traceback;
    private final int level;
    private final boolean calculateLevel;

    public LuaError(Throwable cause) {
        super(cause);
        this.level = 1;
        this.calculateLevel = true;
        this.value = ValueFactory.valueOf("vm error: " + cause.toString());
    }

    public LuaError(String message) {
        super(message);
        this.level = 1;
        this.calculateLevel = true;
        this.value = message == null ? Constants.NIL : ValueFactory.valueOf(message);
    }

    public LuaError(String message, int level) {
        super(message);
        this.level = level;
        this.calculateLevel = false;
        this.value = message == null ? Constants.NIL : ValueFactory.valueOf(message);
    }

    public LuaError(LuaValue message) {
        super(LuaError.rawToString(message));
        this.level = 1;
        this.calculateLevel = true;
        this.value = message;
    }

    public LuaError(LuaValue message, int level) {
        super(LuaError.rawToString(message));
        this.level = level;
        this.calculateLevel = false;
        this.value = message;
    }

    public static LuaError wrap(Throwable error) {
        if (error instanceof LuaError) {
            return (LuaError)error;
        }
        return new LuaError(error);
    }

    @Override
    public String getMessage() {
        return this.traceback != null ? this.traceback : LuaError.rawToString(this.value);
    }

    public LuaValue getValue() {
        return this.value;
    }

    public void fillTraceback(LuaState state) {
        String fileLine;
        if (this.traceback != null) {
            return;
        }
        if (this.getCause() != null) {
            state.reportInternalError(this.getCause(), () -> "Uncaught Java exception");
        }
        LuaThread thread = state.getCurrentThread();
        if (this.level > 0 && this.value.type() == 4 && (fileLine = this.calculateLevel ? DebugHelpers.fileLine(thread) : DebugHelpers.fileLine(thread, this.level)) != null) {
            this.value = ValueFactory.valueOf(fileLine + ": " + this.value.toString());
        }
        this.traceback = this.getMessage() + "\n" + DebugHelpers.traceback(thread, this.level);
    }

    private static String rawToString(LuaValue value) {
        return switch (value.type()) {
            case 2, 5, 7 -> value.typeName() + ": " + Integer.toHexString(value.hashCode());
            default -> value.toString();
        };
    }
}

