/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.LuaString;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private byte[] bytes;
    private int length;

    public Buffer() {
        this(64);
    }

    public Buffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.length = 0;
    }

    public LuaString toLuaString() {
        this.realloc(this.length);
        return LuaString.valueOf(this.bytes, 0, this.length);
    }

    public String toString() {
        return this.toLuaString().toString();
    }

    public void append(byte b) {
        this.ensure(1);
        this.bytes[this.length++] = b;
    }

    public void append(byte[] b) {
        this.ensure(b.length);
        System.arraycopy(b, 0, this.bytes, this.length, b.length);
        this.length += b.length;
    }

    public Buffer append(byte[] b, int start, int length) {
        this.ensure(length);
        System.arraycopy(b, start, this.bytes, this.length, length);
        this.length += length;
        return this;
    }

    public void append(char c) {
        this.ensure(1);
        this.bytes[this.length++] = c < '\u0100' ? (int)c : 63;
    }

    public void append(char[] chars, int start, int length) {
        this.ensure(length);
        int j = this.length;
        int i = start;
        while (i < start + length) {
            char c = chars[i];
            this.bytes[j] = c < '\u0100' ? (int)c : 63;
            ++i;
            ++j;
        }
        this.length += length;
    }

    public Buffer append(LuaString str) {
        this.ensure(str.length());
        this.length = str.copyTo(this.bytes, this.length);
        return this;
    }

    public Buffer append(LuaString str, int start, int srcLength) {
        this.ensure(this.length);
        this.length = str.copyTo(start, this.bytes, this.length, srcLength);
        return this;
    }

    public Buffer append(String str) {
        int n = str.length();
        this.ensure(n);
        LuaString.encode(str, this.bytes, this.length);
        this.length += n;
        return this;
    }

    public void ensure(int space) {
        int newLength = this.length + space;
        if (this.bytes.length >= newLength) {
            return;
        }
        int m = newLength < 32 ? 32 : Math.max(newLength, this.length * 2);
        this.realloc(m);
    }

    private void realloc(int newSize) {
        if (newSize == this.bytes.length) {
            return;
        }
        byte[] newBytes = new byte[newSize];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
        this.bytes = newBytes;
    }
}

