/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.string;

import cc.tweaked.cobalt.internal.string.CharProperties;
import org.squiddev.cobalt.lib.StringLib;

public final class NumberParser {
    private NumberParser() {
    }

    public static double parse(byte[] bytes, int start, int length, int base) {
        int end = start + length;
        while (start < end && StringLib.isWhitespace(bytes[start])) {
            ++start;
        }
        while (start < end && StringLib.isWhitespace(bytes[end - 1])) {
            --end;
        }
        int originalStart = start;
        boolean isNeg = false;
        if (start < end) {
            switch (bytes[start]) {
                case 43: {
                    ++start;
                    break;
                }
                case 45: {
                    ++start;
                    isNeg = true;
                }
            }
        }
        if (start >= end) {
            return Double.NaN;
        }
        if (!(base != 10 && base != 16 || bytes[start] != 48 || start + 1 >= end || bytes[start + 1] != 120 && bytes[start + 1] != 88)) {
            base = 16;
            if ((start += 2) >= end) {
                return Double.NaN;
            }
        }
        return switch (base) {
            case 10 -> NumberParser.scanDouble(bytes, originalStart, end);
            case 16 -> NumberParser.scanHexDouble(bytes, start, end, isNeg);
            default -> NumberParser.scanLong(base, bytes, start, end, isNeg);
        };
    }

    private static double scanLong(int base, byte[] bytes, int start, int end, boolean isNeg) {
        double x = 0.0;
        for (int i = start; i < end; ++i) {
            int digit;
            byte chr = bytes[i];
            if (CharProperties.isDigit(chr)) {
                digit = chr - 48;
            } else if (CharProperties.isAlpha(chr)) {
                digit = (chr | 0x20) - 97 + 10;
            } else {
                return Double.NaN;
            }
            if (digit >= base) {
                return Double.NaN;
            }
            x = x * (double)base + (double)digit;
        }
        return isNeg ? -x : x;
    }

    private static double scanDouble(byte[] bytes, int start, int end) {
        char[] c = new char[end - start];
        for (int i = start; i < end; ++i) {
            byte b = bytes[i];
            if (!NumberParser.isValidDoubleCharacter(b)) {
                return Double.NaN;
            }
            c[i - start] = (char)b;
        }
        try {
            return Double.parseDouble(String.valueOf(c));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static boolean isValidDoubleCharacter(byte b) {
        return b >= 48 && b <= 57 || b == 43 || b == 45 || b == 46 || b == 69 || b == 101;
    }

    private static double scanHexDouble(byte[] bytes, int index, int end, boolean isNeg) {
        double result = 0.0;
        int exponent = 0;
        int sigDigits = 0;
        int nonSigDigits = 0;
        boolean hasDot = false;
        while (index < end) {
            byte s = bytes[index];
            if (s == 46) {
                if (hasDot) {
                    return Double.NaN;
                }
                hasDot = true;
            } else {
                if (!CharProperties.isHex(s)) break;
                if (sigDigits == 0 && s == 48) {
                    ++nonSigDigits;
                } else if (++sigDigits <= 30) {
                    result = result * 16.0 + (double)CharProperties.hexValue(s);
                } else {
                    return Double.NaN;
                }
                if (hasDot) {
                    --exponent;
                }
            }
            ++index;
        }
        if (sigDigits + nonSigDigits == 0) {
            return Double.NaN;
        }
        exponent *= 4;
        if (index < end) {
            byte expSeparator = bytes[index];
            if (expSeparator != 80 && expSeparator != 112) {
                return Double.NaN;
            }
            int givenExponent = 0;
            boolean expNegative = false;
            if (++index < end) {
                switch (bytes[index]) {
                    case 43: {
                        ++index;
                        break;
                    }
                    case 45: {
                        ++index;
                        expNegative = true;
                    }
                }
            }
            if (index >= end) {
                return Double.NaN;
            }
            while (index < end) {
                byte expChar = bytes[index];
                if (!CharProperties.isDigit(expChar)) {
                    return Double.NaN;
                }
                givenExponent = givenExponent * 10 + (expChar - 48);
                ++index;
            }
            if (expNegative) {
                givenExponent = -givenExponent;
            }
            exponent += givenExponent;
        }
        if (isNeg) {
            result = -result;
        }
        return Math.scalb(result, exponent);
    }
}

