/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import java.math.BigInteger;
import org.checkerframework.checker.signedness.qual.SignedPositive;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class UnsignedValues {
    private static final int ASCII_ZERO = 48;
    private static final @Unsigned long INT_MASK = 0xFFFFFFFFL;
    private static final @Unsigned long NOT_INT_MASK = -4294967296L;

    public static boolean isAssignableToUint(@Unsigned long value) {
        return (value & 0xFFFFFFFF00000000L) == 0L;
    }

    public static @Unsigned long toUlong(@Unsigned int value) {
        return Integer.toUnsignedLong(value);
    }

    public static @Unsigned long toUlongFromSigned(@SignedPositive int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be positive");
        }
        return Integer.toUnsignedLong(value);
    }

    public static @Unsigned int toUint(@Unsigned long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static @Unsigned int toUint(BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("value must be positive");
        }
        return (int)value.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue();
    }

    public static @Unsigned int uDivide(@Unsigned int dividend, @Unsigned int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    public static @Unsigned int uRemainder(@Unsigned int dividend, @Unsigned int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static @Unsigned long uDivide(@Unsigned long dividend, @Unsigned long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static @Unsigned long uRemainder(@Unsigned long dividend, @Unsigned long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static boolean uintLE(@Unsigned int lval, @Unsigned int rval) {
        return Integer.compareUnsigned(lval, rval) <= 0;
    }

    public static boolean uintLT(@Unsigned int lval, @Unsigned int rval) {
        return Integer.compareUnsigned(lval, rval) < 0;
    }

    public static boolean uintGE(@Unsigned int lval, @Unsigned int rval) {
        return Integer.compareUnsigned(lval, rval) >= 0;
    }

    public static boolean uintGT(@Unsigned int lval, @Unsigned int rval) {
        return Integer.compareUnsigned(lval, rval) > 0;
    }

    public static boolean ulongGE(@Unsigned long lval, @Unsigned long rval) {
        return Long.compareUnsigned(lval, rval) >= 0;
    }

    public static boolean ulongGT(@Unsigned long lval, @Unsigned long rval) {
        return Long.compareUnsigned(lval, rval) > 0;
    }

    public static boolean ulongLE(@Unsigned long lval, @Unsigned long rval) {
        return Long.compareUnsigned(lval, rval) <= 0;
    }

    public static boolean ulongLT(@Unsigned long lval, @Unsigned long rval) {
        return Long.compareUnsigned(lval, rval) < 0;
    }

    private UnsignedValues() {
    }

    public static char digitToChar(@Unsigned long digit) {
        if (UnsignedValues.ulongGT(digit, 9L)) {
            throw new IllegalArgumentException("digit must be 0-9");
        }
        return (char)(digit + 48L);
    }

    public static char digitToChar(@Unsigned int digit) {
        if (UnsignedValues.uintGT(digit, 9)) {
            throw new IllegalArgumentException("digit must be 0-9");
        }
        return (char)(digit + 48);
    }
}

