/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Assert;
import cc.tweaked.cobalt.internal.doubles.BigNumDtoa;
import cc.tweaked.cobalt.internal.doubles.DecimalRepBuf;
import cc.tweaked.cobalt.internal.doubles.Doubles;
import cc.tweaked.cobalt.internal.doubles.FastDtoa;
import cc.tweaked.cobalt.internal.doubles.FixedDtoa;
import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.squiddev.cobalt.Buffer;

public final class DoubleToStringConverter {
    private static final int MAX_FIXED_DIGITS_BEFORE_POINT = 308;
    private static final double FIRST_NON_FIXED = 1.0E308;
    private static final int MAX_FIXED_DIGITS_AFTER_POINT = 100;
    private static final int MAX_EXPONENTIAL_DIGITS = 120;
    private static final int MIN_PRECISION_DIGITS = 1;
    private static final int MAX_PRECISION_DIGITS = 120;
    private static final int EXPONENTIAL_REP_CAPACITY = 122;
    private static final int FIXED_REP_CAPACITY = 409;
    private static final int PRECISION_REP_CAPACITY = 121;
    private static final int MIN_EXPONENT_WIDTH = 2;
    private static final int MAX_EXPONENT_LENGTH = 5;
    private static final int ASCII_ZERO = 48;
    private static final int MAX_LEADING_ZEROS = 4;
    private static final int MAX_TRAILING_ZEROS = 0;

    private DoubleToStringConverter() {
    }

    private static void handleSpecialValues(double value, FormatOptions fo, Buffer resultBuilder) {
        String symbol;
        boolean isInfinite;
        boolean sign = value < 0.0;
        int effectiveWidth = fo.width();
        if (sign || fo.explicitPlus() || fo.spaceWhenPositive()) {
            --effectiveWidth;
        }
        if (isInfinite = Double.isInfinite(value)) {
            symbol = fo.symbols().infinitySymbol();
        } else if (Double.isNaN(value)) {
            symbol = fo.symbols().nanSymbol();
        } else {
            throw new IllegalStateException("Unreachable");
        }
        if (!fo.leftAdjust() && symbol.length() < effectiveWidth) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', effectiveWidth - symbol.length());
        }
        if (sign) {
            resultBuilder.append('-');
        } else if (fo.explicitPlus()) {
            resultBuilder.append('+');
        } else if (fo.spaceWhenPositive()) {
            resultBuilder.append(' ');
        }
        resultBuilder.append(symbol);
        if (fo.leftAdjust() && symbol.length() < effectiveWidth) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', effectiveWidth - symbol.length());
        }
    }

    private static void createExponentialRepresentation(DecimalRepBuf decimalDigits, double value, int length, int exponent, FormatOptions fo, Buffer resultBuilder) {
        Assert.requireArg(decimalDigits.length() != 0, "decimalDigits must not be empty");
        Assert.requireArg(length <= decimalDigits.length(), "length must be smaller than decimalDigits");
        assert ((double)exponent < 10000.0);
        ExponentPart exponentPart = DoubleToStringConverter.createExponentPart(exponent, 2);
        boolean emitTrailingPoint = fo.alternateForm();
        int padWidth = 0;
        if (fo.width() > 0) {
            int valueWidth = DoubleToStringConverter.calculateExpWidth(length, fo, exponentPart, DoubleToStringConverter.shouldEmitMinus(value), emitTrailingPoint);
            padWidth = fo.width() - valueWidth;
        }
        if (padWidth > 0 && !fo.leftAdjust() && !fo.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', padWidth);
        }
        DoubleToStringConverter.appendSign(value, fo, resultBuilder);
        if (padWidth > 0 && !fo.leftAdjust() && fo.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, '0', padWidth);
        }
        resultBuilder.append(decimalDigits.charAt(0));
        if (length != 1) {
            resultBuilder.append('.');
            resultBuilder.append(decimalDigits.getBuffer(), 1, length - 1);
        } else if (fo.alternateForm()) {
            resultBuilder.append('.');
        }
        resultBuilder.append((char)fo.symbols().exponentCharacter());
        resultBuilder.append(exponentPart.buffer(), exponentPart.start(), exponentPart.length());
        if (padWidth > 0 && fo.leftAdjust()) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', padWidth);
        }
    }

    private static ExponentPart createExponentPart(int exponent, int minLength) {
        boolean sign = false;
        if (exponent < 0) {
            sign = true;
            exponent = -exponent;
        }
        char[] buffer = new char[6];
        int firstCharPos = 6;
        if (exponent == 0) {
            buffer[--firstCharPos] = 48;
        } else {
            while (exponent > 0) {
                buffer[--firstCharPos] = (char)(48 + exponent % 10);
                exponent /= 10;
            }
        }
        while (6 - firstCharPos < minLength) {
            buffer[--firstCharPos] = 48;
        }
        buffer[--firstCharPos] = sign ? 45 : 43;
        return new ExponentPart(buffer, firstCharPos, 6 - firstCharPos);
    }

    private static void createDecimalRepresentation(DecimalRepBuf decimalDigits, double value, int digitsAfterPoint, FormatOptions fo, Buffer resultBuilder) {
        int decimalPoint = decimalDigits.getPointPosition();
        int digitsLength = decimalDigits.length();
        if (digitsLength > decimalPoint + digitsAfterPoint) {
            throw new IllegalArgumentException("too many digits for given digitAfterPoint");
        }
        int padWidth = 0;
        if (fo.width() > 0) {
            int valueWidth = DoubleToStringConverter.calculateDecimalWidth(decimalDigits, fo, digitsAfterPoint, DoubleToStringConverter.shouldEmitMinus(value), fo.alternateForm());
            padWidth = fo.width() - valueWidth;
        }
        if (padWidth > 0 && !fo.leftAdjust() && !fo.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', padWidth);
        }
        DoubleToStringConverter.appendSign(value, fo, resultBuilder);
        if (padWidth > 0 && !fo.leftAdjust() && fo.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, '0', padWidth);
        }
        if (decimalPoint <= 0) {
            resultBuilder.append('0');
            if (digitsAfterPoint > 0) {
                resultBuilder.append('.');
                DoubleToStringConverter.addPadding(resultBuilder, '0', -decimalPoint);
                assert (digitsLength <= digitsAfterPoint - -decimalPoint);
                resultBuilder.append(decimalDigits.getBuffer(), 0, decimalDigits.length());
                remainingDigits = digitsAfterPoint - -decimalPoint - digitsLength;
                DoubleToStringConverter.addPadding(resultBuilder, '0', remainingDigits);
            }
        } else if (decimalPoint >= digitsLength) {
            resultBuilder.append(decimalDigits.getBuffer(), 0, decimalDigits.length());
            DoubleToStringConverter.addPadding(resultBuilder, '0', decimalPoint - digitsLength);
            if (digitsAfterPoint > 0) {
                resultBuilder.append('.');
                DoubleToStringConverter.addPadding(resultBuilder, '0', digitsAfterPoint);
            }
        } else {
            assert (digitsAfterPoint > 0);
            resultBuilder.append(decimalDigits.getBuffer(), 0, decimalPoint);
            resultBuilder.append('.');
            assert (digitsLength - decimalPoint <= digitsAfterPoint);
            resultBuilder.append(decimalDigits.getBuffer(), decimalPoint, digitsLength - decimalPoint);
            remainingDigits = digitsAfterPoint - (digitsLength - decimalPoint);
            DoubleToStringConverter.addPadding(resultBuilder, '0', remainingDigits);
        }
        if (digitsAfterPoint == 0 && fo.alternateForm()) {
            resultBuilder.append('.');
        }
        if (padWidth > 0 && fo.leftAdjust()) {
            DoubleToStringConverter.addPadding(resultBuilder, fo.zeroPad() ? (char)'0' : ' ', padWidth);
        }
    }

    private static int calculateDecimalWidth(DecimalRepBuf decimalDigits, FormatOptions fo, int digitsAfterPoint, boolean emitMinus, boolean emitTrailingPoint) {
        int decimalPoint = decimalDigits.getPointPosition();
        int digitsLength = decimalDigits.length();
        int valueWidth = digitsLength == 0 ? 1 + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0) : (decimalPoint <= 0 ? 2 + digitsAfterPoint : (digitsLength > 0 ? decimalPoint + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0) : 1 + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0)));
        if (digitsAfterPoint == 0 && emitTrailingPoint) {
            ++valueWidth;
        }
        if (emitMinus || fo.explicitPlus() || fo.spaceWhenPositive()) {
            ++valueWidth;
        }
        return valueWidth;
    }

    private static int calculateExpWidth(int digitsLength, FormatOptions fo, ExponentPart exponentPart, boolean emitMinus, boolean emitTrailingPoint) {
        int valueWidth = digitsLength + exponentPart.length() + (digitsLength > 1 ? 2 : 1);
        if (digitsLength == 1 && emitTrailingPoint) {
            ++valueWidth;
        }
        if (emitMinus || fo.explicitPlus() || fo.spaceWhenPositive()) {
            ++valueWidth;
        }
        return valueWidth;
    }

    public static void toFixed(double value, int requestedDigits, FormatOptions formatOptions, Buffer resultBuilder) {
        if (Doubles.isSpecial(value)) {
            DoubleToStringConverter.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (requestedDigits > 100) {
            throw new IllegalArgumentException("requestedDigits too large. max: 308(MAX_FIXED_DIGITS_BEFORE_POINT) got: " + requestedDigits);
        }
        if (value > 1.0E308 || value < -1.0E308) {
            throw new IllegalArgumentException("value >= 10^308(10^MAX_FIXED_DIGITS_BEFORE_POINT) got: " + value);
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(409);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.FIXED, requestedDigits, decimalRep);
        DoubleToStringConverter.createDecimalRepresentation(decimalRep, value, requestedDigits, formatOptions, resultBuilder);
    }

    public static void toExponential(double value, int requestedDigits, FormatOptions formatOptions, Buffer resultBuilder) {
        if (Doubles.isSpecial(value)) {
            DoubleToStringConverter.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (requestedDigits < 0) {
            throw new IllegalArgumentException(String.format("requestedDigits must be >= 0. got: %d", requestedDigits));
        }
        if (requestedDigits > 120) {
            throw new IllegalArgumentException(String.format("requestedDigits must be less than %d. got: %d", 120, requestedDigits));
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(122);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.PRECISION, requestedDigits + 1, decimalRep);
        assert (decimalRep.length() <= requestedDigits + 1);
        decimalRep.zeroExtend(requestedDigits + 1);
        int exponent = decimalRep.getPointPosition() - 1;
        DoubleToStringConverter.createExponentialRepresentation(decimalRep, value, decimalRep.length(), exponent, formatOptions, resultBuilder);
    }

    public static void toPrecision(double value, int precision, FormatOptions formatOptions, Buffer resultBuilder) {
        boolean asExponential;
        if (Doubles.isSpecial(value)) {
            DoubleToStringConverter.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (precision < 1 || precision > 120) {
            throw new IllegalArgumentException(String.format("argument precision must be in range (%d,%d)", 1, 120));
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(121);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.PRECISION, precision, decimalRep);
        assert (decimalRep.length() <= precision);
        int decimalPoint = decimalRep.getPointPosition();
        int exponent = decimalPoint - 1;
        boolean bl = asExponential = -decimalPoint + 1 > 4 || decimalPoint - precision > 0;
        if (!formatOptions.alternateForm()) {
            decimalRep.truncateZeros(asExponential);
            precision = Math.min(precision, decimalRep.length());
        }
        if (asExponential) {
            decimalRep.zeroExtend(precision);
            DoubleToStringConverter.createExponentialRepresentation(decimalRep, value, precision, exponent, formatOptions, resultBuilder);
        } else {
            DoubleToStringConverter.createDecimalRepresentation(decimalRep, value, Math.max(0, precision - decimalRep.getPointPosition()), formatOptions, resultBuilder);
        }
    }

    public static void toHex(double value, int requestedDigits, FormatOptions formatOptions, Buffer resultBuilder) {
        int padWidth;
        if (Doubles.isSpecial(value)) {
            DoubleToStringConverter.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        boolean negative = DoubleToStringConverter.shouldEmitMinus(value);
        double absValue = Math.abs(value);
        ExponentPart significand = DoubleToStringConverter.createHexSignificand(absValue, requestedDigits, formatOptions);
        int exponentValue = absValue == 0.0 ? 0 : Doubles.exponent(absValue) + 52;
        ExponentPart exponent = DoubleToStringConverter.createExponentPart(exponentValue, 1);
        int valueWidth = significand.length() + exponent.length() + 3;
        if (negative || formatOptions.explicitPlus() || formatOptions.spaceWhenPositive()) {
            ++valueWidth;
        }
        int n = padWidth = formatOptions.width() <= 0 ? 0 : formatOptions.width() - valueWidth;
        if (padWidth > 0 && !formatOptions.leftAdjust() && !formatOptions.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', padWidth);
        }
        DoubleToStringConverter.appendSign(value, formatOptions, resultBuilder);
        resultBuilder.append('0');
        resultBuilder.append(formatOptions.symbols().hexSeparator());
        if (padWidth > 0 && !formatOptions.leftAdjust() && formatOptions.zeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, '0', padWidth);
        }
        resultBuilder.append(significand.buffer(), significand.start(), significand.length());
        resultBuilder.append(formatOptions.symbols().hexExponent());
        resultBuilder.append(exponent.buffer(), exponent.start(), exponent.length());
        if (padWidth > 0 && formatOptions.leftAdjust()) {
            DoubleToStringConverter.addPadding(resultBuilder, ' ', padWidth);
        }
    }

    private static ExponentPart createHexSignificand(double value, int requestedDigits, FormatOptions fo) {
        boolean sticky;
        int shiftDistance = requestedDigits == -1 || requestedDigits >= 13 ? 0 : 53 - (1 + requestedDigits * 4);
        long significand = Doubles.significand(value);
        long truncatedSig = significand >>> shiftDistance;
        long roundingBits = significand & (-1L << shiftDistance ^ 0xFFFFFFFFFFFFFFFFL);
        boolean leastZero = (truncatedSig & 1L) == 0L;
        boolean round = (1L << shiftDistance - 1 & roundingBits) != 0L;
        boolean bl = sticky = shiftDistance > 1 && ((1L << shiftDistance - 1 ^ 0xFFFFFFFFFFFFFFFFL) & roundingBits) != 0L;
        if (leastZero && round && sticky || !leastZero && round) {
            ++truncatedSig;
        }
        int minLength = 15;
        char[] mainBuffer = new char[15 + Math.max(0, requestedDigits)];
        int i = 15;
        int end = 14;
        long shrinkingSig = truncatedSig;
        do {
            long digit = shrinkingSig & 0xFL;
            char c = mainBuffer[--i] = digit <= 9L ? UnsignedValues.digitToChar(digit) : (char)((long)fo.symbols().hexBase() + (digit - 10L));
        } while ((shrinkingSig >>>= 4) != 0L);
        if (Doubles.isDenormal(value)) {
            mainBuffer[--i] = 48;
        }
        while (end > i && mainBuffer[end] == '0') {
            --end;
        }
        int expectedEnd = i + requestedDigits;
        while (end < expectedEnd) {
            mainBuffer[++end] = 48;
        }
        if (end - i > 0 || fo.alternateForm()) {
            mainBuffer[i - 1] = mainBuffer[i];
            mainBuffer[i] = 46;
            --i;
        }
        return new ExponentPart(mainBuffer, i, end - i + 1);
    }

    private static boolean shouldEmitMinus(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L && value != 0.0;
    }

    private static void appendSign(double value, FormatOptions formatOptions, Buffer resultBuilder) {
        if (DoubleToStringConverter.shouldEmitMinus(value)) {
            resultBuilder.append('-');
        } else if (formatOptions.spaceWhenPositive()) {
            resultBuilder.append(' ');
        } else if (formatOptions.explicitPlus()) {
            resultBuilder.append('+');
        }
    }

    private static BigNumDtoa.BignumDtoaMode dtoaToBignumDtoaMode(DtoaMode dtoaMode) {
        return switch (dtoaMode) {
            default -> throw new IncompatibleClassChangeError();
            case DtoaMode.FIXED -> BigNumDtoa.BignumDtoaMode.FIXED;
            case DtoaMode.PRECISION -> BigNumDtoa.BignumDtoaMode.PRECISION;
        };
    }

    static void doubleToAscii(double v, DtoaMode mode, int requestedDigits, DecimalRepBuf buffer) {
        boolean fastWorked;
        assert (!Doubles.isSpecial(v)) : "value can't be a special value";
        Assert.requireArg(requestedDigits >= 0, "requestedDigits must be >= 0");
        buffer.reset();
        if (Doubles.sign(v) < 0) {
            buffer.setSign(true);
            v = -v;
        } else {
            buffer.setSign(false);
        }
        if (mode == DtoaMode.PRECISION && requestedDigits == 0) {
            return;
        }
        if (v == 0.0) {
            buffer.append(0);
            buffer.setPointPosition(1);
            return;
        }
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FIXED: {
                boolean bl = FixedDtoa.fastFixedDtoa(v, requestedDigits, buffer);
                break;
            }
            case PRECISION: {
                boolean bl = fastWorked = FastDtoa.fastDtoa(v, requestedDigits, buffer);
            }
        }
        if (fastWorked) {
            return;
        }
        buffer.reset();
        BigNumDtoa.BignumDtoaMode dtoaMode = DoubleToStringConverter.dtoaToBignumDtoaMode(mode);
        BigNumDtoa.bignumDtoa(v, dtoaMode, requestedDigits, buffer);
    }

    private static void addPadding(Buffer sb, char character, int count) {
        for (int i = count; i > 0; --i) {
            sb.append(character);
        }
    }

    public record FormatOptions(Symbols symbols, boolean explicitPlus, boolean spaceWhenPositive, boolean alternateForm, int width, boolean zeroPad, boolean leftAdjust) {
    }

    public record Symbols(String infinitySymbol, String nanSymbol, @Unsigned int exponentCharacter, char hexSeparator, char hexExponent, char hexBase) {
    }

    private record ExponentPart(char[] buffer, int start, int length) {
        @Override
        public String toString() {
            return "Exponent(" + String.valueOf(this.buffer, this.start, this.length) + ")";
        }
    }

    static enum DtoaMode {
        FIXED,
        PRECISION;

    }
}

