/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Assert;
import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import java.math.BigInteger;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class Bignum {
    private static final long LONG_SIGN_BIT = Long.MIN_VALUE;
    private static final long LONG_UNSIGNED_BITS = Long.MAX_VALUE;
    private static final BigInteger INT_MASK = BigInteger.valueOf(0xFFFFFFFFL);
    private static final BigInteger NOT_INT_MASK = INT_MASK.not();
    private BigInteger val;

    public Bignum() {
        this.val = BigInteger.ZERO;
    }

    private Bignum(BigInteger val) {
        this.val = val;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bignum bignum = (Bignum)o;
        return this.val.equals(bignum.val);
    }

    public int hashCode() {
        return Objects.hash(this.val);
    }

    String toHexString() {
        return this.val.toString(16).toUpperCase();
    }

    public Bignum copy() {
        return new Bignum(this.val);
    }

    public void assignHexString(String value) {
        this.val = new BigInteger(value, 16);
    }

    public void assignDecimalString(String value) {
        this.val = new BigInteger(value);
    }

    public void assignUInt(@Unsigned short unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt(@Unsigned int unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt(@Unsigned long unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt16(@Unsigned short unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignUInt32(@Unsigned int unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignUInt64(@Unsigned long unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignBignum(Bignum other) {
        this.val = other.val;
    }

    public void assignPowerUInt16(int base, int exponent) {
        this.assignPower(base, exponent);
    }

    public void assignPower(int base, int exponent) {
        this.val = BigInteger.valueOf(base).pow(exponent);
    }

    public void addUInt64(@Unsigned long operand) {
        this.add(Bignum.fromUnsigned(operand));
    }

    private void add(BigInteger operand) {
        this.val = this.val.add(operand);
    }

    public void addBignum(Bignum other) {
        this.val = this.val.add(other.val);
    }

    public void subtractBignum(Bignum other) {
        this.val = this.val.subtract(other.val);
    }

    public void square() {
        this.val = this.val.multiply(this.val);
    }

    public void shiftLeft(int shiftAmount) {
        this.val = this.val.shiftLeft(shiftAmount);
    }

    public void multiplyByUInt32(@Unsigned int unsignedFactor) {
        this.multiply(Bignum.fromUnsigned(unsignedFactor));
    }

    void multiplyByUInt64(@Unsigned long unsignedFactor) {
        this.multiply(Bignum.fromUnsigned(unsignedFactor));
    }

    void multiplyByPowerOfTen(int exponent) {
        this.val = this.val.multiply(BigInteger.valueOf(10L).pow(exponent));
    }

    private void multiply(BigInteger exponent) {
        this.val = this.val.multiply(exponent);
    }

    void times10() {
        this.multiplyByUInt32(10);
    }

    @Unsigned int divideModuloIntBignum(Bignum other) {
        Assert.requireState(this.val.signum() >= 0 && other.val.signum() >= 0, "values must be positive");
        BigInteger[] rets = this.val.divideAndRemainder(other.val);
        this.val = rets[1];
        return UnsignedValues.toUint(rets[0]);
    }

    static int compare(Bignum a, Bignum b) {
        return a.val.compareTo(b.val);
    }

    static boolean equal(Bignum a, Bignum b) {
        return Bignum.compare(a, b) == 0;
    }

    static boolean lessEqual(Bignum a, Bignum b) {
        return Bignum.compare(a, b) <= 0;
    }

    static boolean less(Bignum a, Bignum b) {
        return Bignum.compare(a, b) < 0;
    }

    static int plusCompare(Bignum a, Bignum b, Bignum c) {
        return a.val.add(b.val).compareTo(c.val);
    }

    static boolean plusEqual(Bignum a, Bignum b, Bignum c) {
        return Bignum.plusCompare(a, b, c) == 0;
    }

    static boolean plusLessEqual(Bignum a, Bignum b, Bignum c) {
        return Bignum.plusCompare(a, b, c) <= 0;
    }

    static boolean plusLess(Bignum a, Bignum b, Bignum c) {
        return Bignum.plusCompare(a, b, c) < 0;
    }

    private static BigInteger fromUnsigned(@Unsigned short value) {
        return BigInteger.valueOf(Short.toUnsignedLong(value));
    }

    private static BigInteger fromUnsigned(@Unsigned int value) {
        return BigInteger.valueOf(Integer.toUnsignedLong(value));
    }

    private static BigInteger fromUnsigned(@Unsigned long value) {
        if ((value & Long.MIN_VALUE) != 0L) {
            return BigInteger.valueOf(value & Long.MAX_VALUE).add(BigInteger.valueOf(1L).shiftLeft(63));
        }
        return BigInteger.valueOf(value);
    }
}

