/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.compacthelpcommand_common_neoforge.cmds;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.compacthelpcommand_common_neoforge.config.ConfigHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandHelp {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.help.failed"));
    private static final ChatFormatting commandcolour = ChatFormatting.getById((int)ConfigHandler.commandColour);
    private static final ChatFormatting subcommandcolour = ChatFormatting.getById((int)ConfigHandler.subcommandColour);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"help").executes(command -> CommandHelp.processHelpCommands(dispatcher, (CommandContext<CommandSourceStack>)command, 1, (CommandSourceStack)command.getSource()))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(command -> CommandHelp.processHelpCommands(dispatcher, (CommandContext<CommandSourceStack>)command, IntegerArgumentType.getInteger((CommandContext)command, (String)"page"), (CommandSourceStack)command.getSource())))).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(command -> {
            String fakecommand = StringArgumentType.getString((CommandContext)command, (String)"command");
            if (NumberFunctions.isNumeric((String)fakecommand)) {
                return CommandHelp.processHelpCommands(dispatcher, (CommandContext<CommandSourceStack>)command, Integer.parseInt(fakecommand), (CommandSourceStack)command.getSource());
            }
            ParseResults parseResults = dispatcher.parse(StringArgumentType.getString((CommandContext)command, (String)"command"), (Object)((CommandSourceStack)command.getSource()));
            if (parseResults.getContext().getNodes().isEmpty()) {
                throw ERROR_FAILED.create();
            }
            Map commandNodeMap = dispatcher.getSmartUsage(((ParsedCommandNode)Iterables.getLast((Iterable)parseResults.getContext().getNodes())).getNode(), (Object)((CommandSourceStack)command.getSource()));
            MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (String)" ", (ChatFormatting)ChatFormatting.WHITE);
            for (String nextStringVar : commandNodeMap.values()) {
                ((CommandSourceStack)command.getSource()).sendSuccess(() -> {
                    String stringCommand = parseResults.getReader().getString();
                    String csuffix = nextStringVar;
                    if (ConfigHandler.addVerticalBarSpacing) {
                        csuffix = csuffix.replace("|", " | ");
                    }
                    MutableComponent tc = Component.literal((String)"");
                    MutableComponent tc0 = Component.literal((String)("/" + stringCommand + " "));
                    tc0.withStyle(commandcolour);
                    tc.append((Component)tc0);
                    MutableComponent tc1 = Component.literal((String)csuffix);
                    tc1.withStyle(subcommandcolour);
                    tc.append((Component)tc1);
                    return tc;
                }, false);
            }
            return commandNodeMap.size();
        })));
    }

    private static Integer processHelpCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandContext<CommandSourceStack> command, Integer page, CommandSourceStack commandSourceStack) {
        ArrayList<CallSite> scmds = new ArrayList<CallSite>();
        Map map = dispatcher.getSmartUsage((CommandNode)dispatcher.getRoot(), (Object)((CommandSourceStack)command.getSource()));
        for (String s : map.values()) {
            String scmd = "/" + s;
            scmds.add((CallSite)((Object)scmd));
        }
        Collections.sort(scmds);
        int amountperpage = ConfigHandler.amountCommandsPerPage;
        int totalcount = scmds.size();
        int totalpages = (int)Math.ceil((float)totalcount / (float)amountperpage) + 1;
        if (page <= 0) {
            page = 1;
        }
        if (page > totalpages) {
            page = totalpages;
        }
        MessageFunctions.sendMessage((CommandSourceStack)commandSourceStack, (String)" ", (ChatFormatting)ChatFormatting.WHITE);
        for (int n = 0; n < amountperpage * page; ++n) {
            if (n < amountperpage * page - amountperpage) continue;
            if (scmds.size() < n + 1) break;
            String commandline = (String)scmds.get(n);
            commandSourceStack.sendSuccess(() -> {
                String[] cmdlspl = commandline.split(" ");
                String acmd = cmdlspl[0];
                String csuffix = commandline.replaceAll(acmd, "");
                if (ConfigHandler.addVerticalBarSpacing) {
                    csuffix = csuffix.replace("|", " | ");
                }
                MutableComponent tc = Component.literal((String)"");
                MutableComponent tc0 = Component.literal((String)acmd);
                tc0.withStyle(commandcolour);
                tc.append((Component)tc0);
                MutableComponent tc1 = Component.literal((String)csuffix);
                tc1.withStyle(subcommandcolour);
                tc.append((Component)tc1);
                return tc;
            }, false);
        }
        MessageFunctions.sendMessage((CommandSourceStack)commandSourceStack, (String)(" Page " + page + " / " + totalpages + ", /help <page>"), (ChatFormatting)ChatFormatting.YELLOW);
        return 1;
    }
}

