/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.extendedbonemeal_common_forge.events;

import com.natamus.collective_common_forge.functions.CropFunctions;
import com.natamus.extendedbonemeal_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ExtendedEvent {
    public static boolean onBoneMeal(Player player, Level level, BlockPos clickPos, BlockState blockState, ItemStack itemStack) {
        if (level.isClientSide) {
            return true;
        }
        if (player == null) {
            return true;
        }
        if (!player.isCrouching()) {
            return true;
        }
        if (!Util.isBoneMeal(itemStack)) {
            return true;
        }
        Block block = blockState.getBlock();
        if (!(block instanceof BonemealableBlock) || block instanceof SaplingBlock || block.equals(Blocks.GRASS_BLOCK) || block instanceof TallGrassBlock || block instanceof MushroomBlock) {
            return true;
        }
        return !CropFunctions.growCrop((Level)level, (Player)player, (BlockState)blockState, (BlockPos)clickPos, (ItemStack)itemStack);
    }

    public static boolean onCropClick(Level level, Player player, InteractionHand interactionHand, BlockPos targetPos, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return true;
        }
        ItemStack handStack = player.getItemInHand(interactionHand);
        if (!Util.isBoneMeal(handStack)) {
            return true;
        }
        BlockState state = level.getBlockState(targetPos);
        Block block = state.getBlock();
        if (block.equals(Blocks.AIR)) {
            targetPos = targetPos.below().immutable();
            state = level.getBlockState(targetPos);
            block = state.getBlock();
        }
        if (block.equals(Blocks.NETHER_WART)) {
            return CropFunctions.growCrop((Level)level, (Player)player, (BlockState)state, (BlockPos)targetPos, (ItemStack)handStack);
        }
        if (block.equals(Blocks.CACTUS)) {
            if (!CropFunctions.growCactus((Level)level, (BlockPos)targetPos)) {
                return true;
            }
        } else if (block.equals(Blocks.SUGAR_CANE)) {
            if (!CropFunctions.growSugarcane((Level)level, (BlockPos)targetPos)) {
                return true;
            }
        } else if (block.equals(Blocks.VINE)) {
            if (!CropFunctions.growVine((Level)level, (BlockPos)targetPos)) {
                return true;
            }
        } else {
            return true;
        }
        if (!player.isCreative()) {
            handStack.shrink(1);
        }
        return true;
    }
}

