/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.oreharvester_common_neoforge.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Util {
    private static final HashMap<BlockPos, Integer> rgnbcount = new HashMap();

    public static boolean isOre(BlockState blockState) {
        return Util.isOre(blockState, blockState.getBlock());
    }

    public static boolean isOre(Block block) {
        return Util.isOre(block.defaultBlockState(), block);
    }

    public static boolean isOre(BlockState blockState, Block block) {
        return Services.BLOCKTAGS.isOre(blockState, ConfigHandler.enableFuzzyOreSearch) || block.equals(Blocks.ANCIENT_DEBRIS);
    }

    @Nullable
    public static Item getOreDrop(Level level, BlockState blockState, Block block, ItemStack itemStack, Player player, Vec3 origin) {
        List possibleDrops = BlockFunctions.getBlockDrops((Level)level, (BlockState)blockState, (ItemStack)itemStack, (Player)player, (Vec3)origin);
        if (possibleDrops.size() == 0) {
            return null;
        }
        return ((ItemStack)possibleDrops.getFirst()).getItem();
    }

    public static List<BlockPos> getOresNextToEachOther(Level level, BlockPos startPos, Block block) {
        return Util.getBlocksNextToEachOther(level, startPos, block, 20);
    }

    public static List<BlockPos> getBlocksNextToEachOther(Level level, BlockPos startPos, Block block, int maxDistance) {
        ArrayList<BlockPos> checkedBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> blocksAround = new ArrayList<BlockPos>();
        if (level.getBlockState(startPos).getBlock().equals(block)) {
            blocksAround.add(startPos);
            checkedBlocks.add(startPos);
        }
        rgnbcount.put(startPos.immutable(), 0);
        Util.recursiveGetNextBlocks(level, startPos, startPos, block, blocksAround, checkedBlocks, maxDistance);
        return blocksAround;
    }

    private static void recursiveGetNextBlocks(Level level, BlockPos startPos, BlockPos pos, Block block, List<BlockPos> blocksAround, List<BlockPos> checkedBlocks, int maxDistance) {
        int rgnbc = rgnbcount.get(startPos);
        if (rgnbc <= 100) {
            rgnbcount.put(startPos, rgnbc + 1);
            for (BlockPos pba : BlockPos.betweenClosed((int)(pos.getX() - 1), (int)(pos.getY() - 1), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)(pos.getY() + 1), (int)(pos.getZ() + 1))) {
                if (checkedBlocks.contains(pba = pba.immutable())) continue;
                checkedBlocks.add(pba);
                if (!level.getBlockState(pba).getBlock().equals(block) || blocksAround.contains(pba)) continue;
                boolean isAllowed = false;
                List connected = BlockPosFunctions.getBlocksAround((BlockPos)pba, (boolean)true);
                for (BlockPos cp : connected) {
                    Block cpBlock = level.getBlockState(cp).getBlock();
                    if (!cpBlock.equals(block) && !cpBlock.equals(Blocks.AIR)) continue;
                    isAllowed = true;
                    break;
                }
                if (!isAllowed) continue;
                blocksAround.add(pba);
                if (!BlockPosFunctions.withinDistance((BlockPos)startPos, (BlockPos)pba, (int)maxDistance).booleanValue()) continue;
                Util.recursiveGetNextBlocks(level, startPos, pba, block, blocksAround, checkedBlocks, maxDistance);
            }
        }
    }
}

