/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.networking.api.server.EarlyConfigurationNetworkHandler;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.impl.ExtClientConnection;
import eu.pb4.polymer.networking.impl.NetImpl;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import eu.pb4.polymer.networking.impl.packets.HelloS2CPayload;
import eu.pb4.polymer.networking.impl.packets.MetadataPayload;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.UUID;
import net.minecraft.class_2520;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_6374;
import net.minecraft.class_8609;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PolymerHandshakeHandlerImplLogin
extends EarlyConfigurationNetworkHandler
implements PolymerHandshakeHandler {
    public static int PING_ID = 595830;
    private int pings = 0;
    private final Object2LongMap<class_2960> lastUpdate = new Object2LongOpenHashMap();
    private final ExtClientConnection extClientConnection;

    private PolymerHandshakeHandlerImplLogin(EarlyConfigurationNetworkHandler.Context context) {
        super(class_2960.method_60655((String)"polymer", (String)"early_handshake"), context);
        this.sendPacket(new HelloS2CPayload());
        this.sendPing(PING_ID);
        this.extClientConnection = ExtClientConnection.of(this.getConnection());
    }

    @Nullable
    public static EarlyConfigurationNetworkHandler create(EarlyConfigurationNetworkHandler.Context context) {
        if (PolymerCommonUtils.isBedrockPlayer((GameProfile)context.profile())) {
            return null;
        }
        return new PolymerHandshakeHandlerImplLogin(context);
    }

    @Override
    public void set(String polymerVersion, Object2IntMap<class_2960> protocolVersions) {
        this.extClientConnection.polymerNet$setVersion(polymerVersion);
        for (Object2IntMap.Entry entry : protocolVersions.object2IntEntrySet()) {
            this.extClientConnection.polymerNet$setSupportedVersion((class_2960)entry.getKey(), entry.getIntValue());
        }
    }

    @Override
    public void setMetadataValue(class_2960 identifier, class_2520 value) {
        this.extClientConnection.polymerNet$getMetadataMap().put((Object)identifier, (Object)value);
    }

    @Override
    public boolean isPolymer() {
        return this.extClientConnection.polymerNet$hasPolymer();
    }

    @Override
    public String getPolymerVersion() {
        return this.extClientConnection.polymerNet$version();
    }

    @Override
    public int getSupportedProtocol(class_2960 identifier) {
        return this.extClientConnection.polymerNet$getSupportedVersion(identifier);
    }

    @Override
    public void setLastPacketTime(class_2960 identifier) {
        this.lastUpdate.put((Object)identifier, System.currentTimeMillis());
    }

    @Override
    public long getLastPacketTime(class_2960 identifier) {
        return this.lastUpdate.getLong((Object)identifier);
    }

    @Override
    @Nullable
    public class_3222 getPlayer() {
        return null;
    }

    @Override
    public void apply(class_3244 handler) {
        NetworkHandlerExtension polymerHandler = NetworkHandlerExtension.of((class_8609)handler);
        for (class_2960 entry : this.lastUpdate.keySet()) {
            polymerHandler.polymerNet$savePacketTime(entry);
        }
    }

    @Override
    public boolean getPackStatus(UUID uuid) {
        return ((CommonClientConnectionExt)this.getConnection()).polymerCommon$hasResourcePack(uuid);
    }

    @Override
    public void reset() {
        this.extClientConnection.polymerNet$getSupportMap().clear();
    }

    @Override
    public void setPackStatus(UUID uuid, boolean status) {
        ((CommonClientConnectionExt)this.getConnection()).polymerCommon$setResourcePack(uuid, status);
    }

    @Override
    public boolean handleCustomPayload(class_2817 packet) {
        class_8710 class_87102 = packet.comp_1647();
        if (class_87102 instanceof HandshakePayload) {
            HandshakePayload handshakePayload = (HandshakePayload)class_87102;
            try {
                ServerPacketRegistry.handleHandshake(this, handshakePayload);
            }
            catch (Throwable e) {
                NetImpl.LOGGER.error("Packet Handling failed!", e);
            }
            return true;
        }
        class_8710 e = packet.comp_1647();
        if (e instanceof MetadataPayload) {
            MetadataPayload payload = (MetadataPayload)e;
            try {
                ServerPacketRegistry.handleMetadata(this, payload);
            }
            catch (Throwable e2) {
                NetImpl.LOGGER.error("Packet Handling failed!", e2);
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_52394(class_6374 packet) {
        if (packet.method_36960() == PING_ID) {
            switch (this.pings++) {
                case 0: {
                    this.sendPing(PING_ID);
                    break;
                }
                case 1: {
                    this.continueJoining();
                }
            }
        }
    }
}

