/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import java.util.Collections;
import java.util.function.IntSupplier;
import net.minecraft.class_10712;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleBlockEntity
extends AbstractComputerBlockEntity
implements BasicContainer {
    private static final Logger LOG = LoggerFactory.getLogger(TurtleBlockEntity.class);
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private final class_2371<class_1799> inventorySnapshot = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private boolean inventoryChanged = false;
    private final IntSupplier fuelLimit;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    private @Nullable IPeripheral peripheral;

    public TurtleBlockEntity(class_2591<? extends TurtleBlockEntity> type, class_2338 pos, class_2680 state, IntSupplier fuelLimit, ComputerFamily family) {
        super(type, pos, state, family);
        this.fuelLimit = fuelLimit;
    }

    boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((class_3218)this.method_10997(), this.method_11016(), ServerComputer.properties(id, this.getFamily()).label(this.getLabel()).terminalSize(new TerminalSize(39, 13)).storageCapacity(this.storageCapacity).addComponent(ComputerComponents.TURTLE, this.brain));
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    protected float getInteractRange() {
        return 8.0f;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    public void method_66473(class_2338 blockPos, class_2680 blockState) {
        if (!this.hasMoved()) {
            super.method_66473(blockPos, blockState);
        }
    }

    @Override
    public void neighborChanged() {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.neighborChanged();
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void loadServer(class_11368 nbt) {
        super.loadServer(nbt);
        class_1262.method_5429((class_11368)nbt, this.inventory);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventorySnapshot.set(i, (Object)((class_1799)this.inventory.get(i)).method_7972());
        }
        this.brain.readFromNBT(nbt);
    }

    @Override
    public void method_11007(class_11372 nbt) {
        class_1262.method_5426((class_11372)nbt, this.inventory);
        this.brain.writeToNBT(nbt);
        super.method_11007(nbt);
    }

    @Override
    protected void method_57568(class_9473 component) {
        super.method_57568(component);
        class_9282 colour = (class_9282)component.method_58694(class_9334.field_49644);
        if (colour != null) {
            this.brain.setColour(colour.comp_2384());
        }
        this.brain.setFuelLevel((Integer)component.method_58695((class_9331)ModRegistry.DataComponents.FUEL.get(), (Object)0));
        this.brain.setOverlay((class_2960)component.method_58694((class_9331)ModRegistry.DataComponents.OVERLAY.get()));
        this.brain.setUpgrade(TurtleSide.LEFT, (UpgradeData)component.method_58694((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get()));
        this.brain.setUpgrade(TurtleSide.RIGHT, (UpgradeData)component.method_58694((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get()));
    }

    @Override
    protected void collectSafeComponents(class_9323.class_9324 builder) {
        super.collectSafeComponents(builder);
        if (this.brain.getColour() != -1) {
            builder.method_57840(class_9334.field_49644, (Object)new class_9282(this.brain.getColour()));
            builder.method_57840(class_9334.field_56400, (Object)class_10712.field_56318.method_67215(class_9334.field_49644, true));
        }
        builder.method_57840((class_9331)ModRegistry.DataComponents.OVERLAY.get(), (Object)this.brain.getOverlay());
        builder.method_57840((class_9331)ModRegistry.DataComponents.FUEL.get(), (Object)this.brain.getFuelLevel());
        builder.method_57840((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.LEFT)));
        builder.method_57840((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.RIGHT)));
    }

    private static @Nullable UpgradeData<ITurtleUpgrade> withPersistedData(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        return upgrade == null ? null : UpgradeData.of(upgrade.holder(), upgrade.upgrade().getPersistedData(upgrade.data()));
    }

    @Override
    @Deprecated
    public void method_57569(class_11372 tag) {
        super.method_57569(tag);
        tag.method_71478("Color");
        tag.method_71478("Fuel");
        tag.method_71478("Overlay");
        tag.method_71478("LeftUpgrade");
        tag.method_71478("RightUpgrade");
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654(TurtleBlock.FACING);
    }

    public void setDirection(class_2350 dir) {
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
            dir = class_2350.field_11043;
        }
        this.method_10997().method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(TurtleBlock.FACING, (Comparable)dir));
        this.updateRedstone();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    public @Nullable ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    public int getColour() {
        return this.brain.getColour();
    }

    public @Nullable class_2960 getOverlay() {
        return this.brain.getOverlay();
    }

    public ITurtleAccess getAccess() {
        return this.brain;
    }

    public class_243 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.onTileEntityChange();
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_1799 getItemSnapshot(int slot) {
        return slot >= 0 && slot < this.inventorySnapshot.size() ? (class_1799)this.inventorySnapshot.get(slot) : class_1799.field_8037;
    }

    public void method_5431() {
        super.method_5431();
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 item = this.method_5438(slot);
            if (class_1799.method_7973((class_1799)item, (class_1799)((class_1799)this.inventorySnapshot.get(slot)))) continue;
            this.inventoryChanged = true;
            this.inventorySnapshot.set(slot, (Object)item.method_7972());
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.isUsable(player);
    }

    public void onTileEntityChange() {
        super.method_5431();
    }

    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        try (class_8942.class_11340 problems = new class_8942.class_11340(this.method_71402(), LOG);){
            class_11362 nbt = class_11362.method_71459((class_8942)problems, (class_7225.class_7874)registries);
            if (this.label != null) {
                nbt.method_71469("Label", this.label);
            }
            this.brain.writeDescription((class_11372)nbt);
            class_2487 class_24872 = nbt.method_71475();
            return class_24872;
        }
    }

    @Override
    public void loadClient(class_11368 nbt) {
        super.loadClient(nbt);
        this.label = nbt.method_71428("Label", null);
        this.brain.readDescription(nbt);
    }

    public int getFuelLimit() {
        return this.fuelLimit.getAsInt();
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getUpgradeType().isPeripheral();
    }

    public void transferStateFrom(TurtleBlockEntity copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.inventorySnapshot, copy.inventorySnapshot);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        PlatformHelper.get().invalidateComponent(this);
    }

    public @Nullable IPeripheral peripheral() {
        if (this.hasMoved()) {
            return null;
        }
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("turtle", this);
        return this.peripheral;
    }

    public @Nullable class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return TurtleMenu.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

