/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import org.jspecify.annotations.Nullable;

public class WiredModemFullBlockEntity
extends class_2586 {
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private boolean refreshConnections = false;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this.tickToken));
    private final WiredModemElement element = new FullElement(this);
    private final WiredNode node = this.element.getNode();
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());
    private int invalidSides = 0;

    public WiredModemFullBlockEntity(class_2591<WiredModemFullBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        ComponentAccess<IPeripheral> peripheralAccess = PlatformHelper.get().createPeripheralAccess(this, this::queueRefreshPeripheral);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i] = new WiredModemLocalPeripheral(peripheralAccess);
        }
    }

    public void method_11012() {
        super.method_11012();
        for (WiredModemPeripheral modem : this.modems) {
            if (modem == null) continue;
            modem.removed();
        }
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            this.node.remove();
        }
    }

    public void method_10996() {
        super.method_10996();
        this.refreshConnections = true;
        this.invalidSides = 63;
        TickScheduler.schedule(this.tickToken);
    }

    void neighborChanged() {
        this.invalidSides = 63;
        TickScheduler.schedule(this.tickToken);
    }

    void queueRefreshPeripheral(class_2350 facing) {
        this.invalidSides |= 1 << facing.ordinal();
        TickScheduler.schedule(this.tickToken);
    }

    public class_1269 use(class_1657 player) {
        if (player.method_18276() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        if (this.method_10997().field_9236) {
            return class_1269.field_5812;
        }
        List<String> oldPeriphNames = this.getConnectedPeripheralNames();
        if (this.isPeripheralOn()) {
            this.detachPeripherals();
        } else {
            this.attachPeripherals(63);
        }
        List<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equals(periphNames, oldPeriphNames)) {
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            WiredModemFullBlockEntity.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return class_1269.field_21466;
    }

    private static void sendPeripheralChanges(class_1657 player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        class_5250 base = class_2561.method_43470((String)"");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.method_27693(", ");
            }
            base.method_10852((class_2561)ChatHelpers.copy((String)names.get(i)));
        }
        player.method_7353((class_2561)class_2561.method_43469((String)kind, (Object[])new Object[]{base}), false);
    }

    public void method_11014(class_11368 nbt) {
        super.method_11014(nbt);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    public void method_11007(class_11372 nbt) {
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.method_11007(nbt);
    }

    void blockTick() {
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.invalidSides != 0) {
            int oldInvalidSides = this.invalidSides;
            this.invalidSides = 0;
            if (this.isPeripheralOn()) {
                this.attachPeripherals(oldInvalidSides);
            }
        }
        if (this.modemState.pollChanged()) {
            this.updateModemBlockState();
        }
        if (this.refreshConnections) {
            this.connectionsChanged();
        }
    }

    private void updateModemBlockState() {
        class_2680 state = this.method_11010();
        boolean modemOn = this.modemState.isOpen();
        if ((Boolean)state.method_11654((class_2769)WiredModemFullBlock.MODEM_ON) == modemOn) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)WiredModemFullBlock.MODEM_ON, (Comparable)Boolean.valueOf(modemOn)));
    }

    private void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    private void connectionsChanged() {
        if (this.method_10997().field_9236) {
            return;
        }
        this.refreshConnections = false;
        class_1937 world = this.method_10997();
        class_2338 current = this.method_11016();
        for (class_2350 facing : DirectionUtil.FACINGS) {
            WiredElement element;
            class_2338 offset = current.method_10093(facing);
            if (!world.method_8477(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            this.node.connectTo(element.getNode());
        }
    }

    private List<String> getConnectedPeripheralNames() {
        ArrayList<String> peripherals = new ArrayList<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        peripherals.sort(String::compareTo);
        return peripherals;
    }

    private void attachPeripherals(int sides) {
        boolean anyChanged = false;
        HashMap<String, IPeripheral> attachedPeripherals = new HashMap<String, IPeripheral>(6);
        for (class_2350 facing : DirectionUtil.FACINGS) {
            WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
            if (DirectionUtil.isSet(sides, facing)) {
                anyChanged |= peripheral.attach(this.method_10997(), this.method_11016(), facing);
            }
            peripheral.extendMap(attachedPeripherals);
        }
        if (anyChanged) {
            this.node.updatePeripherals(attachedPeripherals);
        }
        this.updatePeripheralBlocKState(!attachedPeripherals.isEmpty());
    }

    private void detachPeripherals() {
        boolean anyChanged = false;
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            anyChanged |= peripheral.detach();
        }
        if (anyChanged) {
            this.node.updatePeripherals(Map.of());
        }
        this.updatePeripheralBlocKState(false);
    }

    private void updatePeripheralBlocKState(boolean peripheralOn) {
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)WiredModemFullBlock.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.method_10997().method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)WiredModemFullBlock.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    private boolean isPeripheralOn() {
        return (Boolean)this.method_11010().method_11654((class_2769)WiredModemFullBlock.PERIPHERAL_ON);
    }

    public WiredElement getElement() {
        return this.element;
    }

    public @Nullable WiredModemPeripheral getPeripheral(final @Nullable class_2350 side) {
        if (side == null) {
            return null;
        }
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element, this.peripherals[side.ordinal()], this){

            @Override
            public class_243 getPosition() {
                return class_243.method_24953((class_2382)WiredModemFullBlockEntity.this.method_11016().method_10093(side));
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final WiredModemFullBlockEntity entity;

        private FullElement(WiredModemFullBlockEntity entity) {
            this.entity = entity;
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        public class_1937 getLevel() {
            return this.entity.method_10997();
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24953((class_2382)this.entity.method_11016());
        }
    }
}

