/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.Logging;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAPI.class);
    private final IComputerSystem computer;
    private final AdminComputer admin;
    private final OutputReceiver receiver = new OutputReceiver();

    public CommandAPI(IComputerSystem computer, AdminComputer admin) {
        this.computer = computer;
        this.admin = admin;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.computer.getLevel().method_8503();
        if (!server.method_3812()) {
            return new Object[]{false, CommandAPI.createOutput("Command blocks disabled by server")};
        }
        class_2170 commandManager = server.method_3734();
        try {
            this.receiver.clearOutput();
            CommandState state = new CommandState();
            class_2168 source = this.getSource().method_9231((success, x) -> {
                if (success) {
                    ++state.successes;
                }
            });
            commandManager.method_44252(source, command);
            return new Object[]{state.successes > 0, this.receiver.copyOutput(), state.successes};
        }
        catch (Throwable t) {
            LOG.error(Logging.JAVA_ERROR, "Error running command.", t);
            return new Object[]{false, CommandAPI.createOutput("Java Exception Thrown: " + String.valueOf(t))};
        }
    }

    private static Map<?, ?> getBlockInfo(class_1937 world, class_2338 pos) {
        BlockReference block = new BlockReference(world, pos);
        Map<String, Object> table = VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails(block);
        class_2586 tile = block.blockEntity();
        if (tile != null) {
            table.put("nbt", NBTUtil.toLua((class_2520)tile.method_38242((class_7225.class_7874)world.method_30349())));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public final Object[] exec(String command) {
        return this.doCommand(command);
    }

    @LuaFunction
    public final long execAsync(ILuaContext context, String command) throws LuaException {
        return context.issueMainThreadTask(() -> this.doCommand(command));
    }

    @LuaFunction(mainThread=true)
    public final List<String> list(IArguments args) throws LuaException {
        MinecraftServer server = this.computer.getLevel().method_8503();
        RootCommandNode node = server.method_3734().method_9235().getRoot();
        for (int j = 0; j < args.count(); ++j) {
            String name = args.getString(j);
            if ((node = node.getChild(name)) instanceof LiteralCommandNode) continue;
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            result.add(child.getName());
        }
        return Collections.unmodifiableList(result);
    }

    @LuaFunction
    public final Object[] getBlockPosition() {
        class_2338 pos = this.computer.getPosition();
        return new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
    }

    @LuaFunction(mainThread=true)
    public final List<Map<?, ?>> getBlockInfos(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> dimension) throws LuaException {
        class_1937 world = this.getLevel(dimension);
        class_2338 min = new class_2338(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        class_2338 max = new class_2338(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
        if (!world.method_24794(min) || !world.method_24794(max)) {
            throw new LuaException("Co-ordinates out of range");
        }
        int blocks = (max.method_10263() - min.method_10263() + 1) * (max.method_10264() - min.method_10264() + 1) * (max.method_10260() - min.method_10260() + 1);
        if (blocks > 4096) {
            throw new LuaException("Too many blocks");
        }
        ArrayList results = new ArrayList(blocks);
        for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
            for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
                    class_2338 pos = new class_2338(x, y, z);
                    results.add(CommandAPI.getBlockInfo(world, pos));
                }
            }
        }
        return results;
    }

    @LuaFunction(mainThread=true)
    public final Map<?, ?> getBlockInfo(int x, int y, int z, Optional<String> dimension) throws LuaException {
        class_2338 position;
        class_1937 level = this.getLevel(dimension);
        if (!level.method_24794(position = new class_2338(x, y, z))) {
            throw new LuaException("Co-ordinates out of range");
        }
        return CommandAPI.getBlockInfo(level, position);
    }

    private class_1937 getLevel(Optional<String> id) throws LuaException {
        class_3218 currentLevel = this.computer.getLevel();
        if (id.isEmpty()) {
            return currentLevel;
        }
        class_2960 dimensionId = class_2960.method_12829((String)id.get());
        if (dimensionId == null) {
            throw new LuaException("Invalid dimension name");
        }
        class_3218 level = currentLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionId));
        if (level == null) {
            throw new LuaException("Unknown dimension");
        }
        return level;
    }

    private class_2168 getSource() {
        String name = "@";
        String label = this.computer.getLabel();
        if (label != null) {
            name = label;
        }
        return new class_2168((class_2165)this.receiver, class_243.method_24953((class_2382)this.computer.getPosition()), class_241.field_1340, this.computer.getLevel(), this.admin.permissionLevel(), name, (class_2561)class_2561.method_43470((String)name), this.computer.getLevel().method_8503(), null);
    }

    private final class OutputReceiver
    implements class_2165 {
        private final List<String> output = new ArrayList<String>();

        private OutputReceiver() {
        }

        void clearOutput() {
            this.output.clear();
        }

        List<String> copyOutput() {
            return List.copyOf(this.output);
        }

        public void method_43496(class_2561 textComponent) {
            this.output.add(textComponent.getString());
        }

        public boolean method_9200() {
            return true;
        }

        public boolean method_9202() {
            return true;
        }

        public boolean method_9201() {
            return CommandAPI.this.computer.getLevel().method_64395().method_8355(class_1928.field_19394);
        }
    }

    private static final class CommandState {
        int successes;

        private CommandState() {
        }
    }
}

