/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1799;

public final class TurtleRefuelHandlers {
    private static final List<TurtleRefuelHandler> handlers = new CopyOnWriteArrayList<TurtleRefuelHandler>();

    private TurtleRefuelHandlers() {
    }

    public static synchronized void register(TurtleRefuelHandler handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        handlers.add(handler);
    }

    public static OptionalInt refuel(ITurtleAccess turtle, class_1799 stack, int slot, int limit) {
        for (TurtleRefuelHandler handler : handlers) {
            OptionalInt fuel = handler.refuel(turtle, stack, slot, limit);
            if (!fuel.isPresent()) continue;
            int refuelled = fuel.getAsInt();
            if (refuelled < 0) {
                throw new IllegalStateException(String.valueOf(handler) + " returned a negative value");
            }
            if (limit == 0 && refuelled != 0) {
                throw new IllegalStateException(String.valueOf(handler) + " refuelled despite given a limit of 0");
            }
            return fuel;
        }
        return OptionalInt.empty();
    }
}

