/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.platform.ModelKey;
import dan200.computercraft.shared.util.ResourceUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10526;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import net.minecraft.class_7775;

@Environment(value=EnvType.CLIENT)
public class CustomModelManager<U extends class_10526, T> {
    private final String kind;
    private final class_7654 lister;
    private final Codec<U> codec;
    private final BiFunction<U, class_7775, T> bake;
    private final ModelKey<T> missingModelKey;
    private final U missingModel;
    private final Map<class_2960, ModelKey<T>> modelKeys = new ConcurrentHashMap<class_2960, ModelKey<T>>();

    public CustomModelManager(String kind, class_7654 lister, Codec<U> codec, BiFunction<U, class_7775, T> bake, U missingModel) {
        this.kind = kind;
        this.lister = lister;
        this.codec = codec;
        this.bake = bake;
        this.missingModelKey = ClientPlatformHelper.get().createModelKey(() -> "Missing " + kind);
        this.missingModel = missingModel;
    }

    private ModelKey<T> getModelKey(class_2960 id) {
        return this.modelKeys.computeIfAbsent(id, o -> ClientPlatformHelper.get().createModelKey(() -> this.kind + " " + String.valueOf(o)));
    }

    public CompletableFuture<Map<class_2960, U>> load(class_3300 resources, Executor executor) {
        return ResourceUtils.load(resources, executor, this.kind, this.lister, (DynamicOps<JsonElement>)JsonOps.INSTANCE, this.codec);
    }

    public void register(ClientRegistry.RegisterExtraModels register, Map<class_2960, U> models) {
        models.forEach((id, model) -> register.register(this.getModelKey((class_2960)id), model, this.bake));
        register.register(this.missingModelKey, this.missingModel, this.bake);
    }

    public T get(class_1092 modelManager, class_2960 id) {
        T model = this.getModelKey(id).get(modelManager);
        if (model != null) {
            return model;
        }
        T missing = this.missingModelKey.get(modelManager);
        if (missing == null) {
            throw new IllegalStateException("Models have not yet been loaded.");
        }
        return missing;
    }
}

