/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_9848;
import org.joml.Vector3f;
import org.jspecify.annotations.Nullable;

public final class StandaloneModel {
    private final List<class_777> quads;
    private final boolean useBlockLight;
    private final class_1058 particleIcon;
    private final class_1921 renderType;
    private final Supplier<Vector3f[]> extents;

    public StandaloneModel(List<class_777> quads, boolean usesBlockLight, class_1058 particleIcon, class_1921 renderType) {
        this.quads = quads;
        this.useBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.renderType = renderType;
        this.extents = Suppliers.memoize(() -> class_10430.method_67990((List)quads));
    }

    public static StandaloneModel of(class_2960 model, class_7775 baker) {
        return StandaloneModel.of(baker.method_45872(model), baker);
    }

    public static StandaloneModel of(class_10819 model, class_7775 baker) {
        return (StandaloneModel)baker.method_68549((class_7775.class_10897)new CacheKey(model));
    }

    private static StandaloneModel ofUncached(class_10819 model, class_7775 baker) {
        class_10419 slots = model.method_68045();
        return new StandaloneModel(model.method_68034(slots, baker, (class_3665)class_1086.field_5350).method_68048(), model.method_68042().method_24299(), model.method_68033(slots, baker), class_4722.method_29382());
    }

    public void setupItemLayer(class_10444.class_10446 layer) {
        layer.method_67995(this.extents);
        layer.method_67992(this.renderType);
        layer.method_67996(this.useBlockLight);
        layer.method_67994(this.particleIcon);
        layer.method_67997().addAll(this.quads);
    }

    public void render(class_4587 transform, class_4597 buffers, int light, int overlay) {
        this.render(transform, buffers, light, overlay, null);
    }

    public void render(class_4587 transform, class_4597 buffers, int light, int overlay, int @Nullable [] tints) {
        class_4587.class_4665 pose = transform.method_23760();
        class_4588 buffer = buffers.getBuffer(this.renderType);
        for (class_777 quad : this.quads) {
            float a;
            float b;
            float g;
            float r;
            int idx = quad.comp_3722();
            if (tints != null && idx >= 0 && idx < tints.length) {
                int tint = tints[idx];
                r = (float)class_9848.method_61327((int)tint) / 255.0f;
                g = (float)class_9848.method_61329((int)tint) / 255.0f;
                b = (float)class_9848.method_61331((int)tint) / 255.0f;
                a = (float)class_9848.method_61320((int)tint) / 255.0f;
            } else {
                a = 1.0f;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            buffer.method_22919(pose, quad, r, g, b, a, light, overlay);
        }
    }

    private record CacheKey(class_10819 model) implements class_7775.class_10897<StandaloneModel>
    {
        public StandaloneModel compute(class_7775 baker) {
            return StandaloneModel.ofUncached(this.model(), baker);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof CacheKey)) return false;
            CacheKey cacheKey = (CacheKey)other;
            try {
                class_10819 class_108192;
                class_10819 otherModel = class_108192 = cacheKey.model();
                if (this.model() != otherModel) return false;
                return true;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.model());
        }
    }
}

